/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.swing.JComponent;
import kernel.AgentProxy;
import kernel.Kernel;
import kernel.SimulatorProxy;
import kernel.ViewerProxy;
import kernel.ui.ComponentManagerGUI;
import rescuecore2.GUIComponent;
import rescuecore2.config.Config;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.connection.ConnectionManagerListener;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.AKAcknowledge;
import rescuecore2.messages.control.AKConnect;
import rescuecore2.messages.control.KAConnectError;
import rescuecore2.messages.control.KAConnectOK;
import rescuecore2.messages.control.KSConnectOK;
import rescuecore2.messages.control.KVConnectOK;
import rescuecore2.messages.control.SKAcknowledge;
import rescuecore2.messages.control.SKConnect;
import rescuecore2.messages.control.VKAcknowledge;
import rescuecore2.messages.control.VKConnect;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class ComponentManager
implements ConnectionManagerListener,
GUIComponent {
    private static final int STARTING_ID = 1;
    private static final int WAIT_TIME = 10000;
    private Kernel kernel;
    private ComponentManagerGUI gui;
    private Map<String, Queue<ControlledEntityInfo>> uncontrolledEntities;
    private Set<AgentAck> agentsToAcknowledge;
    private Set<SimulatorAck> simsToAcknowledge;
    private int nextID;
    private Set<ViewerAck> viewersToAcknowledge;
    private WorldModel<? extends Entity> world;
    private Config config;
    private final Object agentLock = new Object();
    private final Object simLock = new Object();
    private final Object viewerLock = new Object();
    private final Object idLock = new Object();

    public ComponentManager(Kernel kernel, WorldModel<? extends Entity> world, Config config) {
        this.kernel = kernel;
        this.world = world;
        this.config = config;
        this.uncontrolledEntities = new HashMap<String, Queue<ControlledEntityInfo>>();
        this.agentsToAcknowledge = new HashSet<AgentAck>();
        this.simsToAcknowledge = new HashSet<SimulatorAck>();
        this.viewersToAcknowledge = new HashSet<ViewerAck>();
        this.nextID = 1;
        this.gui = new ComponentManagerGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAgentControlledEntity(Entity entity, Collection<? extends Entity> visibleOnStartup, Config agentConfig) {
        Logger.info((String)("Agent controlled entity registered: " + entity));
        Object object = this.agentLock;
        synchronized (object) {
            Queue<ControlledEntityInfo> q = this.uncontrolledEntities.get(entity.getURN());
            if (q == null) {
                q = new LinkedList<ControlledEntityInfo>();
                this.uncontrolledEntities.put(entity.getURN(), q);
            }
            if (visibleOnStartup == null) {
                visibleOnStartup = this.world.getAllEntities();
            }
            q.add(new ControlledEntityInfo(entity, visibleOnStartup, agentConfig));
        }
        this.updateGUIUncontrolledAgents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllAgents() throws InterruptedException {
        Object object = this.agentLock;
        synchronized (object) {
            boolean done = false;
            do {
                done = true;
                for (Map.Entry<String, Queue<ControlledEntityInfo>> next : this.uncontrolledEntities.entrySet()) {
                    if (next.getValue().isEmpty()) continue;
                    done = false;
                    Logger.info((String)("Waiting for " + next.getValue().size() + " entities of type " + next.getKey()));
                }
                if (!this.agentsToAcknowledge.isEmpty()) {
                    done = false;
                    Logger.info((String)("Waiting for " + this.agentsToAcknowledge.size() + " agents to acknowledge"));
                }
                if (done) continue;
                this.agentLock.wait(10000L);
            } while (!done);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllSimulators() throws InterruptedException {
        Object object = this.simLock;
        synchronized (object) {
            while (!this.simsToAcknowledge.isEmpty()) {
                this.simLock.wait(10000L);
                Logger.info((String)("Waiting for " + this.simsToAcknowledge.size() + " simulators to acknowledge"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllViewers() throws InterruptedException {
        Object object = this.viewerLock;
        synchronized (object) {
            while (!this.viewersToAcknowledge.isEmpty()) {
                this.viewerLock.wait(10000L);
                Logger.info((String)("Waiting for " + this.viewersToAcknowledge.size() + " viewers to acknowledge"));
            }
        }
    }

    public void newConnection(Connection c) {
        c.addConnectionListener((ConnectionListener)new ComponentConnectionListener());
    }

    public JComponent getGUIComponent() {
        return this.gui;
    }

    public String getGUIComponentName() {
        return "Component manager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean agentAcknowledge(int requestID, EntityID agentID, Connection c) {
        Object object = this.agentLock;
        synchronized (object) {
            for (AgentAck next : this.agentsToAcknowledge) {
                if (next.requestID != requestID || !next.agentID.equals((Object)agentID) || next.connection != c) continue;
                this.agentsToAcknowledge.remove(next);
                this.kernel.addAgent(next.agent);
                this.agentLock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean simAcknowledge(int requestID, int simulatorID, Connection c) {
        Object object = this.simLock;
        synchronized (object) {
            for (SimulatorAck next : this.simsToAcknowledge) {
                if (next.requestID != requestID || next.simulatorID != simulatorID || next.connection != c) continue;
                this.simsToAcknowledge.remove(next);
                this.kernel.addSimulator(next.sim);
                this.simLock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean viewerAcknowledge(int requestID, int viewerID, Connection c) {
        Object object = this.viewerLock;
        synchronized (object) {
            for (ViewerAck next : this.viewersToAcknowledge) {
                if (next.requestID != requestID || next.viewerID != viewerID || next.connection != c) continue;
                this.viewersToAcknowledge.remove(next);
                this.kernel.addViewer(next.viewer);
                this.viewerLock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextSimulatorID() {
        Object object = this.idLock;
        synchronized (object) {
            return this.nextID++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextViewerID() {
        Object object = this.idLock;
        synchronized (object) {
            return this.nextID++;
        }
    }

    private ControlledEntityInfo findEntityToControl(List<String> types) {
        Logger.debug((String)("Finding entity to control. Requested types: " + types));
        for (String next : types) {
            ControlledEntityInfo info;
            Queue<ControlledEntityInfo> q = this.uncontrolledEntities.get(next);
            Logger.debug((String)("Uncontrolled entities of type " + next + ": " + q));
            if (q == null || (info = q.poll()) == null) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGUIUncontrolledAgents() {
        ArrayList<String> data = new ArrayList<String>();
        Object object = this.agentLock;
        synchronized (object) {
            for (Queue<ControlledEntityInfo> q : this.uncontrolledEntities.values()) {
                for (ControlledEntityInfo info : q) {
                    data.add(info.entity.getURN() + " " + info.entity.getID());
                }
            }
        }
        this.gui.updateUncontrolledAgents(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGUIAgentAck() {
        ArrayList<String> data = new ArrayList<String>();
        Object object = this.agentLock;
        synchronized (object) {
            for (AgentAck ack : this.agentsToAcknowledge) {
                data.add(ack.toString());
            }
        }
        this.gui.updateAgentAck(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGUISimulatorAck() {
        ArrayList<String> data = new ArrayList<String>();
        Object object = this.simLock;
        synchronized (object) {
            for (SimulatorAck ack : this.simsToAcknowledge) {
                data.add(ack.toString());
            }
        }
        this.gui.updateSimulatorAck(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGUIViewerAck() {
        ArrayList<String> data = new ArrayList<String>();
        Object object = this.viewerLock;
        synchronized (object) {
            for (ViewerAck ack : this.viewersToAcknowledge) {
                data.add(ack.toString());
            }
        }
        this.gui.updateViewerAck(data);
    }

    private static class ControlledEntityInfo {
        Entity entity;
        Collection<? extends Entity> visibleSet;
        Config config;

        public ControlledEntityInfo(Entity entity, Collection<? extends Entity> visibleSet, Config config) {
            this.entity = entity;
            this.visibleSet = visibleSet;
            this.config = config;
        }

        public String toString() {
            return this.entity.toString();
        }
    }

    private static class ViewerAck {
        ViewerProxy viewer;
        int viewerID;
        int requestID;
        Connection connection;

        public ViewerAck(ViewerProxy viewer, int viewerID, int requestID, Connection c) {
            this.viewer = viewer;
            this.viewerID = viewerID;
            this.requestID = requestID;
            this.connection = c;
        }

        public String toString() {
            return this.viewer + " " + this.viewerID + "(connection request ID " + this.requestID + ")";
        }
    }

    private static class SimulatorAck {
        SimulatorProxy sim;
        int simulatorID;
        int requestID;
        Connection connection;

        public SimulatorAck(SimulatorProxy sim, int simID, int requestID, Connection c) {
            this.sim = sim;
            this.simulatorID = simID;
            this.requestID = requestID;
            this.connection = c;
        }

        public String toString() {
            return this.sim + " " + this.simulatorID + "(connection request ID " + this.requestID + ")";
        }
    }

    private static class AgentAck {
        AgentProxy agent;
        EntityID agentID;
        int requestID;
        Connection connection;

        public AgentAck(AgentProxy agent, EntityID agentID, int requestID, Connection c) {
            this.agent = agent;
            this.agentID = agentID;
            this.requestID = requestID;
            this.connection = c;
        }

        public String toString() {
            return this.agent.getName() + ": " + this.agent.getControlledEntity().getURN() + " " + this.agent.getControlledEntity().getID() + "(" + this.connection + " request ID " + this.requestID + ")";
        }
    }

    private class ComponentConnectionListener
    implements ConnectionListener {
        private ComponentConnectionListener() {
        }

        public void messageReceived(Connection connection, Message msg) {
            if (msg instanceof AKConnect) {
                this.handleAKConnect((AKConnect)msg, connection);
            }
            if (msg instanceof AKAcknowledge) {
                this.handleAKAcknowledge((AKAcknowledge)msg, connection);
            }
            if (msg instanceof SKConnect) {
                this.handleSKConnect((SKConnect)msg, connection);
            }
            if (msg instanceof SKAcknowledge) {
                this.handleSKAcknowledge((SKAcknowledge)msg, connection);
            }
            if (msg instanceof VKConnect) {
                this.handleVKConnect((VKConnect)msg, connection);
            }
            if (msg instanceof VKAcknowledge) {
                this.handleVKAcknowledge((VKAcknowledge)msg, connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAKConnect(AKConnect connect, Connection connection) {
            int requestID = connect.getRequestID();
            List types = connect.getRequestedEntityTypes();
            KAConnectError reply = null;
            Logger.debug((String)("AKConnect received: " + types));
            Object object = ComponentManager.this.agentLock;
            synchronized (object) {
                ControlledEntityInfo result = ComponentManager.this.findEntityToControl(types);
                if (result == null) {
                    Logger.debug((String)"No suitable entities found");
                    reply = new KAConnectError(requestID, "No more agents");
                } else {
                    Logger.debug((String)("Found entity to control: " + result));
                    Entity entity = result.entity;
                    AgentProxy agent = new AgentProxy(connect.getAgentName(), entity, connection);
                    ComponentManager.this.agentsToAcknowledge.add(new AgentAck(agent, entity.getID(), requestID, connection));
                    Logger.info((String)("Agent '" + connect.getAgentName() + "' id " + entity.getID() + " (" + connection + " request ID " + requestID + ") connected"));
                    reply = new KAConnectOK(requestID, entity.getID(), result.visibleSet, result.config);
                }
            }
            if (reply != null) {
                try {
                    connection.sendMessage((Message)reply);
                }
                catch (ConnectionException e) {
                    Logger.error((String)"Error sending reply", (Throwable)e);
                }
            }
            ComponentManager.this.updateGUIUncontrolledAgents();
            ComponentManager.this.updateGUIAgentAck();
        }

        private void handleAKAcknowledge(AKAcknowledge msg, Connection connection) {
            EntityID agentID;
            int requestID = msg.getRequestID();
            if (ComponentManager.this.agentAcknowledge(requestID, agentID = msg.getAgentID(), connection)) {
                Logger.info((String)("Agent " + agentID + " (" + connection + " request ID " + requestID + ") acknowledged"));
            } else {
                Logger.warn((String)("Unexpected acknowledge from agent " + agentID + " (request ID " + requestID + ")"));
            }
            ComponentManager.this.updateGUIAgentAck();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleSKConnect(SKConnect msg, Connection connection) {
            int simID = ComponentManager.this.getNextSimulatorID();
            int requestID = msg.getRequestID();
            Logger.info((String)("Simulator '" + msg.getSimulatorName() + "' id " + simID + " (" + connection + " request ID " + requestID + ") connected"));
            SimulatorProxy sim = new SimulatorProxy(msg.getSimulatorName(), simID, connection);
            Object object = ComponentManager.this.simLock;
            synchronized (object) {
                ComponentManager.this.simsToAcknowledge.add(new SimulatorAck(sim, simID, requestID, connection));
            }
            sim.send(Collections.singleton(new KSConnectOK(simID, requestID, ComponentManager.this.world.getAllEntities(), ComponentManager.this.config)));
            ComponentManager.this.updateGUISimulatorAck();
        }

        private void handleSKAcknowledge(SKAcknowledge msg, Connection connection) {
            int simID;
            int requestID = msg.getRequestID();
            if (ComponentManager.this.simAcknowledge(requestID, simID = msg.getSimulatorID(), connection)) {
                Logger.info((String)("Simulator " + simID + " (" + connection + " request ID " + requestID + ") acknowledged"));
            } else {
                Logger.warn((String)("Unexpected acknowledge from simulator " + simID + " (request ID " + requestID + ")"));
            }
            ComponentManager.this.updateGUISimulatorAck();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleVKConnect(VKConnect msg, Connection connection) {
            int requestID = msg.getRequestID();
            int viewerID = ComponentManager.this.getNextViewerID();
            Logger.info((String)("Viewer '" + msg.getViewerName() + "' id " + viewerID + " (" + connection + " request ID " + requestID + ") connected"));
            ViewerProxy viewer = new ViewerProxy(msg.getViewerName(), viewerID, connection);
            Object object = ComponentManager.this.viewerLock;
            synchronized (object) {
                ComponentManager.this.viewersToAcknowledge.add(new ViewerAck(viewer, viewerID, requestID, connection));
            }
            viewer.send(Collections.singleton(new KVConnectOK(viewerID, requestID, ComponentManager.this.world.getAllEntities(), ComponentManager.this.config)));
            ComponentManager.this.updateGUIViewerAck();
        }

        private void handleVKAcknowledge(VKAcknowledge msg, Connection connection) {
            int viewerID;
            int requestID = msg.getRequestID();
            if (ComponentManager.this.viewerAcknowledge(requestID, viewerID = msg.getViewerID(), connection)) {
                Logger.info((String)("Viewer " + viewerID + " (" + connection + " request ID " + requestID + ") acknowledged"));
            } else {
                Logger.warn((String)("Unexpected acknowledge from viewer " + viewerID + " (" + requestID + ")"));
            }
            ComponentManager.this.updateGUIViewerAck();
        }
    }
}

