/*
 * Decompiled with CFR 0.152.
 */
package kernel.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import kernel.AgentProxy;
import kernel.Kernel;
import kernel.KernelListener;
import kernel.SimulatorProxy;
import kernel.ViewerProxy;
import rescuecore2.Timestep;
import rescuecore2.misc.gui.ListModelList;

public class KernelStatus
extends JPanel
implements KernelListener {
    private Kernel kernel;
    private ListModelList<AgentProxy> agents;
    private ListModelList<SimulatorProxy> simulators;
    private ListModelList<ViewerProxy> viewers;
    private JList agentsList;
    private JList simulatorsList;
    private JList viewersList;
    private JLabel timeLabel;
    private JLabel scoreLabel;

    public KernelStatus(Kernel kernel) {
        super(new BorderLayout());
        this.kernel = kernel;
        this.agents = new ListModelList(new ArrayList());
        this.simulators = new ListModelList(new ArrayList());
        this.viewers = new ListModelList(new ArrayList());
        kernel.addKernelListener(this);
        this.agentsList = new JList<AgentProxy>((ListModel<AgentProxy>)this.agents);
        this.simulatorsList = new JList<SimulatorProxy>((ListModel<SimulatorProxy>)this.simulators);
        this.viewersList = new JList<ViewerProxy>((ListModel<ViewerProxy>)this.viewers);
        JPanel lists = new JPanel(new GridLayout(3, 1));
        JScrollPane agentsScroll = new JScrollPane(this.agentsList);
        JScrollPane simulatorsScroll = new JScrollPane(this.simulatorsList);
        JScrollPane viewersScroll = new JScrollPane(this.viewersList);
        agentsScroll.setBorder(BorderFactory.createTitledBorder("Agents"));
        simulatorsScroll.setBorder(BorderFactory.createTitledBorder("Simulators"));
        viewersScroll.setBorder(BorderFactory.createTitledBorder("Viewers"));
        lists.add(agentsScroll);
        lists.add(simulatorsScroll);
        lists.add(viewersScroll);
        this.add((Component)lists, "Center");
        this.timeLabel = new JLabel("Time: not started", 0);
        this.scoreLabel = new JLabel("Score: not started", 0);
        JPanel labels = new JPanel(new GridLayout(1, 2));
        labels.add(this.timeLabel);
        labels.add(this.scoreLabel);
        this.add((Component)labels, "North");
        this.agents.addAll(kernel.getAllAgents());
        this.simulators.addAll(kernel.getAllSimulators());
        this.viewers.addAll(kernel.getAllViewers());
    }

    @Override
    public void simulationStarted(Kernel k) {
    }

    @Override
    public void simulationEnded(Kernel k) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KernelStatus.this.timeLabel.setText("Time: ended");
            }
        });
    }

    @Override
    public void timestepCompleted(Kernel k, final Timestep time) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KernelStatus.this.timeLabel.setText("Time: " + time.getTime());
                KernelStatus.this.scoreLabel.setText("Score: " + time.getScore());
            }
        });
    }

    @Override
    public void agentAdded(Kernel k, AgentProxy info) {
        this.agents.add((Object)info);
    }

    @Override
    public void agentRemoved(Kernel k, AgentProxy info) {
        this.agents.remove((Object)info);
    }

    @Override
    public void simulatorAdded(Kernel k, SimulatorProxy info) {
        this.simulators.add((Object)info);
    }

    @Override
    public void simulatorRemoved(Kernel k, SimulatorProxy info) {
        this.simulators.remove((Object)info);
    }

    @Override
    public void viewerAdded(Kernel k, ViewerProxy info) {
        this.viewers.add((Object)info);
    }

    @Override
    public void viewerRemoved(Kernel k, ViewerProxy info) {
        this.viewers.remove((Object)info);
    }
}

