/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.simulator;

import firesimulator.world.Building;
import firesimulator.world.World;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnergyHistory {
    private static final Log LOG = LogFactory.getLog(EnergyHistory.class);
    private int time;
    private Map<Building, Double> initialEnergy = new HashMap<Building, Double>();
    private Map<Building, Double> initialTemperature = new HashMap<Building, Double>();
    private Map<Building, Double> burnEnergy = new HashMap<Building, Double>();
    private Map<Building, Double> coolEnergy = new HashMap<Building, Double>();
    private Map<Building, Double> exchangedWithAir = new HashMap<Building, Double>();
    private Map<Building, Double> lostToRadiation = new HashMap<Building, Double>();
    private Map<Building, Double> gainedByRadiation = new HashMap<Building, Double>();
    private Map<Building, Double> finalEnergy = new HashMap<Building, Double>();
    private Map<Building, Double> finalTemperature = new HashMap<Building, Double>();

    public EnergyHistory(World world, int time) {
        this.time = time;
        for (Building next : world.getBuildings()) {
            this.initialEnergy.put(next, next.getEnergy());
            this.initialTemperature.put(next, next.getTemperature());
        }
    }

    public void registerBurn(Building b, double energy) {
        this.burnEnergy.put(b, energy);
    }

    public void registerCool(Building b, double energy) {
        this.coolEnergy.put(b, energy);
    }

    public void registerAir(Building b, double energy) {
        this.exchangedWithAir.put(b, energy);
    }

    public void registerRadiationLoss(Building b, double energy) {
        this.lostToRadiation.put(b, energy);
    }

    public void registerRadiationGain(Building b, double energy) {
        double old = this.gainedByRadiation.containsKey(b) ? this.gainedByRadiation.get(b) : 0.0;
        this.gainedByRadiation.put(b, old + energy);
    }

    public void registerFinalEnergy(World world) {
        for (Building next : world.getBuildings()) {
            this.finalEnergy.put(next, next.getEnergy());
            this.finalTemperature.put(next, next.getTemperature());
        }
    }

    public void logSummary() {
        LOG.debug((Object)("Energy summary at time " + this.time));
        for (Building next : this.initialEnergy.keySet()) {
            boolean changed = this.burnEnergy.containsKey(next) || this.coolEnergy.containsKey(next) || this.exchangedWithAir.containsKey(next) || this.lostToRadiation.containsKey(next) || this.gainedByRadiation.containsKey(next);
            if (!changed || this.initialEnergy.get(next).equals(this.finalEnergy.get(next))) continue;
            LOG.debug((Object)("Building " + next.getID()));
            LOG.debug((Object)("  Initial energy / temperature: " + this.initialEnergy.get(next) + " / " + this.initialTemperature.get(next)));
            LOG.debug((Object)("  Burn energy                 : " + this.burnEnergy.get(next)));
            LOG.debug((Object)("  Cool energy                 : " + this.coolEnergy.get(next)));
            LOG.debug((Object)("  Exchanged with air          : " + this.exchangedWithAir.get(next)));
            LOG.debug((Object)("  Lost to radiation           : " + this.lostToRadiation.get(next)));
            LOG.debug((Object)("  Gained by radiation         : " + this.gainedByRadiation.get(next)));
            LOG.debug((Object)("  Final energy / temperature  : " + this.finalEnergy.get(next) + " / " + this.finalTemperature.get(next)));
        }
    }
}

