/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import rescuecore.tools.mapgenerator.BuildingGenerator;
import rescuecore.tools.mapgenerator.RescueMap;
import rescuecore.tools.mapgenerator.RescueMapToolkit;

public abstract class BlocksBuildingGenerator
implements BuildingGenerator {
    private int[] outerBlock;

    @Override
    public void addBuildings(RescueMap rm, int uniformity, int buildDensity, Random rand) {
        int[][] blocks = this.getBlocks(rm);
        System.out.println("Filling blocks");
        for (int i = 0; i < blocks.length; ++i) {
            int[][][] builds = this.fillBlock(rm, blocks[i], buildDensity, rand);
            for (int j = 0; j < builds.length; ++j) {
                int[] centre = RescueMapToolkit.centre(builds[j]);
                rm.addBuilding(builds[j], RescueMapToolkit.makeEntrance(rm, centre), (int)(rand.nextDouble() * 4.0) + 1, 0);
            }
            System.out.println(i + " of " + blocks.length);
        }
        int[][][] builds = this.fillOuterBlock(rm, this.outerBlock, buildDensity, rand);
        for (int j = 0; j < builds.length; ++j) {
            int[] centre = RescueMapToolkit.centre(builds[j]);
            rm.addBuilding(builds[j], RescueMapToolkit.makeEntrance(rm, centre), (int)(rand.nextDouble() * 4.0) + 1, 0);
        }
    }

    protected abstract int[][][] fillBlock(RescueMap var1, int[] var2, int var3, Random var4);

    protected abstract int[][][] fillOuterBlock(RescueMap var1, int[] var2, int var3, Random var4);

    private int[][] getBlocks(RescueMap m) {
        int[][] rs = m.getRoads();
        HashMap<Integer, Integer> visited = new HashMap<Integer, Integer>();
        ArrayList<int[]> blocks = new ArrayList<int[]>(100);
        for (int i = 0; i < rs.length; ++i) {
            int[] c;
            Integer vis = (Integer)visited.get(BlocksBuildingGenerator.hash(rs[i]));
            int v = 0;
            if (vis != null) {
                v = vis;
            }
            if ((v & 1) == 0) {
                visited.put(BlocksBuildingGenerator.hash(rs[i]), new Integer(v |= 1));
                c = this.walkCircuit(m, rs[i], visited, true);
                if (c.length > 0) {
                    blocks.add(c);
                }
            }
            if ((v & 2) != 0) continue;
            visited.put(BlocksBuildingGenerator.hash(rs[i]), new Integer(v |= 2));
            c = this.walkCircuit(m, rs[i], visited, false);
            if (c.length <= 0) continue;
            blocks.add(c);
        }
        int[][] blks = new int[blocks.size()][];
        blocks.toArray((T[])blks);
        return blks;
    }

    private static Integer hash(int[] road) {
        int a = Math.min(road[0], road[1]);
        int b = Math.max(road[0], road[1]);
        return new Integer(b * 10000 + a);
    }

    private int[] walkCircuit(RescueMap m, int[] curr, HashMap visited, boolean isTail) {
        ArrayList<Integer> circ = new ArrayList<Integer>(20);
        double totalAngle = 0.0;
        int t = 0;
        int s = 1;
        if (isTail) {
            t = 1;
            s = 0;
        }
        int[] first = new int[]{curr[t], curr[s]};
        circ.add(new Integer(curr[t]));
        do {
            circ.add(new Integer(curr[s]));
            int[] nbs = m.getUnderlyingNeighbours(curr[s]);
            int ind = 0;
            double maxAngle = -Math.PI;
            for (int k = 0; k < nbs.length; ++k) {
                double angle;
                if (nbs[k] == curr[t] || !((angle = RescueMapToolkit.angle(m, curr[t], curr[s], nbs[k])) > maxAngle)) continue;
                maxAngle = angle;
                ind = k;
            }
            totalAngle += maxAngle;
            curr[t] = curr[s];
            curr[s] = nbs[ind];
            Integer val = (Integer)visited.get(BlocksBuildingGenerator.hash(curr));
            int v = 0;
            if (val != null) {
                v = val;
            }
            if (curr[s] > curr[t]) {
                visited.put(BlocksBuildingGenerator.hash(curr), new Integer(v | 1));
                continue;
            }
            visited.put(BlocksBuildingGenerator.hash(curr), new Integer(v | 2));
        } while (curr[s] != first[0]);
        int[] rs = new int[circ.size()];
        for (int i = 0; i < rs.length; ++i) {
            rs[i] = (Integer)circ.get(i);
        }
        if (totalAngle <= 0.0) {
            this.outerBlock = rs;
            return new int[0];
        }
        return rs;
    }
}

