/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import rescuecore.tools.mapgenerator.PairNode;

public class PairHeap {
    private int size = 0;
    private PairNode root = null;
    private PairNode[] treeArray = new PairNode[5];

    public PairNode insert(int val, int priority) {
        PairNode newNode = new PairNode(val, priority);
        ++this.size;
        this.root = this.root == null ? newNode : this.compareAndLink(this.root, newNode);
        return newNode;
    }

    public PairNode addItem(int val, int priority) {
        PairNode newNode = this.insert(val, priority);
        return newNode;
    }

    public int findMin() {
        if (this.isEmpty()) {
            return -1;
        }
        return this.root.getValue();
    }

    public int deleteMin() {
        int val = this.findMin();
        this.root = this.root.getLeftChild() == null ? null : this.combineSiblings(this.root.getLeftChild());
        --this.size;
        return val;
    }

    public void decreaseKey(PairNode p, int newPriority) {
        if (p.getPriority() > newPriority) {
            return;
        }
        p.setPriority(newPriority);
        if (p != this.root) {
            if (p.getNextSibling() != null) {
                p.getNextSibling().setPrev(p.getPrev());
            }
            if (p.getPrev().getLeftChild() == p) {
                p.getPrev().setLeftChild(p.getNextSibling());
            } else {
                p.getPrev().setNextSibling(p.getNextSibling());
            }
            p.setNextSibling(null);
            this.root = this.compareAndLink(this.root, p);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void makeEmpty() {
        this.size = 0;
        this.root = null;
    }

    private PairNode compareAndLink(PairNode first, PairNode second) {
        if (second == null) {
            return first;
        }
        if (second.getPriority() < first.getPriority()) {
            second.setPrev(first.getPrev());
            first.setPrev(second);
            first.setNextSibling(second.getLeftChild());
            if (first.getNextSibling() != null) {
                first.getNextSibling().setPrev(first);
            }
            second.setLeftChild(first);
            return second;
        }
        second.setPrev(first);
        first.setNextSibling(second.getNextSibling());
        if (first.getNextSibling() != null) {
            first.getNextSibling().setPrev(first);
        }
        second.setNextSibling(first.getLeftChild());
        if (second.getNextSibling() != null) {
            second.getNextSibling().setPrev(second);
        }
        first.setLeftChild(second);
        return first;
    }

    private PairNode[] doubleIfFull(PairNode[] array, int index) {
        if (index == array.length) {
            PairNode[] oldArray = array;
            array = new PairNode[index * 2];
            for (int i = 0; i < index; ++i) {
                array[i] = oldArray[i];
            }
        }
        return array;
    }

    private PairNode combineSiblings(PairNode firstSibling) {
        if (firstSibling.getNextSibling() == null) {
            return firstSibling;
        }
        int numSiblings = 0;
        while (firstSibling != null) {
            this.treeArray = this.doubleIfFull(this.treeArray, numSiblings);
            this.treeArray[numSiblings] = firstSibling;
            firstSibling.getPrev().setNextSibling(null);
            firstSibling = firstSibling.getNextSibling();
            ++numSiblings;
        }
        this.treeArray = this.doubleIfFull(this.treeArray, numSiblings);
        this.treeArray[numSiblings] = null;
        int i = 0;
        while (i + 1 < numSiblings) {
            this.treeArray[i] = this.compareAndLink(this.treeArray[i], this.treeArray[i + 1]);
            i += 2;
        }
        int j = i - 2;
        if (j == numSiblings - 3) {
            this.treeArray[j] = this.compareAndLink(this.treeArray[j], this.treeArray[j + 2]);
        }
        while (j >= 2) {
            this.treeArray[j - 2] = this.compareAndLink(this.treeArray[j - 2], this.treeArray[j]);
            j -= 2;
        }
        return this.treeArray[0];
    }

    public static void main(String[] args) {
        PairHeap h = new PairHeap();
        int numItems = 40000;
        int i = 37;
        i = 37;
        while (i != 0) {
            h.insert(i, i);
            i = (i + 37) % numItems;
        }
        for (i = numItems - 1; i > 0; --i) {
            if (h.deleteMin() == i) continue;
            System.out.println("Oops! " + i);
        }
    }
}

