/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import rescuecore.tools.mapgenerator.PairHeap;
import rescuecore.tools.mapgenerator.RescueMapToolkit;

public class RescueMap {
    private int nodeCount;
    private int roadCount;
    private int[] xs;
    private int[] ys;
    private int[][] roads;
    private int width;
    private int height;
    private int[] inDegree;
    private int[] outDegree;
    private int[][] distances;
    private boolean[] invalid;
    private int[] buildingXs;
    private int[] buildingYs;
    private int[][][] buildingApi;
    private int[] buildingEntrances;
    private int[] buildingFloors;
    private int[] buildingTypes;
    private int buildingCount;

    public RescueMap(int nodeCount, int width, int height) {
        this.width = width;
        this.height = height;
        this.nodeCount = nodeCount;
        this.xs = new int[nodeCount * 2];
        this.ys = new int[nodeCount * 2];
        this.inDegree = new int[nodeCount * 2];
        this.outDegree = new int[nodeCount * 2];
        this.roads = new int[nodeCount * 2][nodeCount * 2];
        this.distances = new int[nodeCount * 2][nodeCount * 2];
        this.invalid = new boolean[nodeCount * 2];
        this.roadCount = 0;
        this.buildingXs = new int[nodeCount * 2];
        this.buildingYs = new int[nodeCount * 2];
        this.buildingEntrances = new int[nodeCount * 2];
        this.buildingApi = new int[nodeCount * 2][][];
        this.buildingFloors = new int[nodeCount * 2];
        this.buildingTypes = new int[nodeCount * 2];
    }

    public void setX(int node, int x) {
        if (x != this.xs[node]) {
            this.invalid[node] = true;
        }
        this.xs[node] = x;
    }

    public void setY(int node, int y) {
        if (y != this.ys[node]) {
            this.invalid[node] = true;
        }
        this.ys[node] = y;
    }

    public void setRoad(int a, int b, int size) {
        if (size != 0 && this.roads[a][b] == 0) {
            ++this.roadCount;
            int n = b;
            this.inDegree[n] = this.inDegree[n] + 1;
            int n2 = a;
            this.outDegree[n2] = this.outDegree[n2] + 1;
        } else if (size == 0 && this.roads[a][b] != 0) {
            --this.roadCount;
            int n = b;
            this.inDegree[n] = this.inDegree[n] - 1;
            int n3 = a;
            this.outDegree[n3] = this.outDegree[n3] - 1;
        }
        this.roads[a][b] = size;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getX(int node) {
        return this.xs[node];
    }

    public int getY(int node) {
        return this.ys[node];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getInDegree(int node) {
        return this.inDegree[node];
    }

    public int getOutDegree(int node) {
        return this.outDegree[node];
    }

    public int getRoad(int n1, int n2) {
        return this.roads[n1][n2];
    }

    public void addNode() {
        if (this.nodeCount + 1 > this.xs.length) {
            this.resize();
        }
        ++this.nodeCount;
    }

    public void addBuilding(int[][] api, int entrance, int floors, int type) {
        if (this.buildingCount + 1 > this.buildingXs.length) {
            this.resizeBs();
        }
        ++this.buildingCount;
        this.buildingApi[this.buildingCount - 1] = new int[api.length][2];
        for (int i = 0; i < api.length; ++i) {
            this.buildingApi[this.buildingCount - 1][i][0] = api[i][0];
            this.buildingApi[this.buildingCount - 1][i][1] = api[i][1];
        }
        int[] cent = RescueMapToolkit.centre(api);
        this.buildingXs[this.buildingCount - 1] = cent[0];
        this.buildingYs[this.buildingCount - 1] = cent[1];
        this.buildingEntrances[this.buildingCount - 1] = entrance;
        this.buildingFloors[this.buildingCount - 1] = floors;
        this.buildingTypes[this.buildingCount - 1] = type;
    }

    public int[][] getRoads() {
        ArrayList<Integer> rs = new ArrayList<Integer>(this.nodeCount * 4);
        for (int i = 0; i < this.nodeCount; ++i) {
            for (int j = i + 1; j < this.nodeCount; ++j) {
                if (this.roads[i][j] <= 0 && this.roads[j][i] <= 0) continue;
                rs.add(new Integer(j));
                rs.add(new Integer(i));
            }
        }
        int[][] rds = new int[rs.size() / 2][2];
        for (int i = 0; i < rs.size(); i += 2) {
            rds[i / 2][0] = (Integer)rs.get(i);
            rds[i / 2][1] = (Integer)rs.get(i + 1);
        }
        return rds;
    }

    public int[] getNeighbours(int node) {
        ArrayList<Integer> ns = new ArrayList<Integer>(10);
        for (int i = 0; i < this.nodeCount; ++i) {
            if (this.roads[node][i] <= 0) continue;
            ns.add(new Integer(i));
        }
        int[] nbs = new int[ns.size()];
        for (int i = 0; i < ns.size(); ++i) {
            nbs[i] = (Integer)ns.get(i);
        }
        return nbs;
    }

    public int[] getUnderlyingNeighbours(int node) {
        ArrayList<Integer> ns = new ArrayList<Integer>(10);
        for (int i = 0; i < this.nodeCount; ++i) {
            if (this.roads[node][i] <= 0 && this.roads[i][node] <= 0) continue;
            ns.add(new Integer(i));
        }
        int[] nbs = new int[ns.size()];
        for (int i = 0; i < ns.size(); ++i) {
            nbs[i] = (Integer)ns.get(i);
        }
        return nbs;
    }

    public int[] edges(int[] bIds, int[] rIds, int[][] rs, int n) {
        int i;
        ArrayList<Integer> es = new ArrayList<Integer>(10);
        for (i = 0; i < this.buildingCount; ++i) {
            if (this.buildingEntrances[i] != n) continue;
            es.add(new Integer(bIds[i]));
        }
        for (i = 0; i < rs.length; ++i) {
            if (rs[i][0] != n && rs[i][1] != n) continue;
            es.add(new Integer(rIds[i]));
        }
        int[] edges = new int[es.size()];
        for (int i2 = 0; i2 < edges.length; ++i2) {
            edges[i2] = (Integer)es.get(i2);
        }
        return edges;
    }

    public void toFile() throws IOException {
        this.toFile(null);
    }

    public void toFile(File parentDir) throws IOException {
        File road = new File(parentDir, "road.bin");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(road)));
        this.writeInt(out, 0);
        this.writeInt(out, 0);
        this.writeInt(out, 0);
        int[][] rds = this.getRoads();
        this.writeInt(out, rds.length);
        int[] rIds = new int[rds.length];
        int id = this.nodeCount + 2;
        for (int i = 0; i < rds.length; ++i) {
            this.writeInt(out, 17);
            rIds[i] = id;
            this.writeInt(out, id++);
            this.writeInt(out, rds[i][0] + 1);
            this.writeInt(out, rds[i][1] + 1);
            this.writeInt(out, this.distance(rds[i][0], rds[i][1]));
            this.writeInt(out, 0);
            this.writeInt(out, 0);
            this.writeInt(out, 0);
            this.writeInt(out, 0);
            this.writeInt(out, 0);
            this.writeInt(out, (this.roads[rds[i][1]][rds[i][0]] + this.roads[rds[i][0]][rds[i][1]]) * 2000);
            this.writeInt(out, 0);
            this.writeInt(out, 0);
            this.writeInt(out, 0);
            this.writeInt(out, this.roads[rds[i][1]][rds[i][0]]);
            this.writeInt(out, this.roads[rds[i][0]][rds[i][1]]);
            this.writeInt(out, 0);
        }
        out.flush();
        out.close();
        File building = new File(parentDir, "building.bin");
        out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(building)));
        int[] bIds = new int[this.buildingCount];
        this.writeInt(out, 0);
        this.writeInt(out, 0);
        this.writeInt(out, 0);
        this.writeInt(out, this.buildingCount);
        for (int i = 0; i < this.buildingCount; ++i) {
            this.writeInt(out, 16 + this.buildingApi[i].length * 2);
            bIds[i] = id;
            this.writeInt(out, id++);
            this.writeInt(out, this.buildingXs[i]);
            this.writeInt(out, this.buildingYs[i]);
            this.writeInt(out, this.buildingFloors[i]);
            this.writeInt(out, this.buildingTypes[i]);
            this.writeInt(out, 0);
            this.writeInt(out, 0);
            this.writeInt(out, 0);
            this.writeInt(out, 1);
            this.writeInt(out, this.buildingEntrances[i] + 1);
            this.writeInt(out, 0);
            int area = RescueMapToolkit.area(this.buildingApi[i]);
            this.writeInt(out, area);
            this.writeInt(out, area * this.buildingFloors[i]);
            this.writeInt(out, 0);
            this.writeInt(out, this.buildingApi[i].length);
            for (int j = 0; j < this.buildingApi[i].length; ++j) {
                this.writeInt(out, this.buildingApi[i][j][0]);
                this.writeInt(out, this.buildingApi[i][j][1]);
            }
        }
        out.flush();
        out.close();
        File node = new File(parentDir, "node.bin");
        out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(node)));
        this.writeInt(out, 0);
        this.writeInt(out, 0);
        this.writeInt(out, 0);
        this.writeInt(out, this.nodeCount);
        for (int i = 0; i < this.nodeCount; ++i) {
            int j;
            int[] edges = this.edges(bIds, rIds, rds, i);
            this.writeInt(out, 6 + 7 * edges.length);
            this.writeInt(out, i + 1);
            this.writeInt(out, this.xs[i]);
            this.writeInt(out, this.ys[i]);
            this.writeInt(out, edges.length);
            for (j = 0; j < edges.length; ++j) {
                this.writeInt(out, edges[j]);
            }
            this.writeInt(out, 0);
            for (j = 0; j < edges.length; ++j) {
                this.writeInt(out, 0);
            }
            for (j = 0; j < edges.length; ++j) {
                this.writeInt(out, 0);
                this.writeInt(out, 0);
            }
            for (j = 0; j < edges.length; ++j) {
                this.writeInt(out, 0);
                this.writeInt(out, 0);
                this.writeInt(out, 0);
            }
        }
        out.flush();
        out.close();
    }

    private void writeInt(DataOutputStream out, int n) throws IOException {
        int result = (n & 0xFF) << 24 | (n & 0xFF00) << 8 | (n & 0xFF0000) >> 8 | (n & 0xFF000000) >> 24;
        out.writeInt(result);
    }

    public int distance(int n1, int n2) {
        int i;
        if (this.invalid[n1]) {
            for (i = 0; i < this.nodeCount; ++i) {
                this.distances[n1][i] = 0;
                this.distances[i][n1] = 0;
            }
            this.invalid[n1] = false;
        }
        if (this.invalid[n2]) {
            for (i = 0; i < this.nodeCount; ++i) {
                this.distances[n2][i] = 0;
                this.distances[i][n2] = 0;
            }
            this.invalid[n2] = false;
        }
        if (this.distances[n1][n2] == 0) {
            long x = this.xs[n1] - this.xs[n2];
            long y = this.ys[n1] - this.ys[n2];
            this.distances[n1][n2] = (int)Math.sqrt(x * x + y * y);
            this.distances[n2][n1] = this.distances[n1][n2];
        }
        return this.distances[n1][n2];
    }

    public boolean pathExists(int start, int end) {
        boolean[] visited = new boolean[this.nodeCount];
        PairHeap q = new PairHeap();
        visited[start] = true;
        int next = start;
        try {
            while (next != end) {
                for (int j = 0; j < this.nodeCount; ++j) {
                    if (this.roads[next][j] <= 0 || visited[j]) continue;
                    visited[j] = true;
                    int x = this.xs[j] - this.xs[end];
                    int y = this.ys[j] - this.ys[end];
                    int d = (int)Math.sqrt(x * x + y * y);
                    q.insert(j, d);
                }
                next = q.deleteMin();
            }
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public void align() {
        int i;
        int x;
        int y = x = Integer.MAX_VALUE;
        for (i = 0; i < this.nodeCount; ++i) {
            if (this.xs[i] < x) {
                x = this.xs[i];
            }
            if (this.ys[i] >= y) continue;
            y = this.ys[i];
        }
        for (i = 0; i < this.buildingCount; ++i) {
            if (this.buildingXs[i] < x) {
                x = this.buildingXs[i];
            }
            if (this.buildingYs[i] < y) {
                y = this.buildingYs[i];
            }
            for (int j = 0; j < this.buildingApi[i].length; ++j) {
                if (this.buildingApi[i][j][0] < x) {
                    x = this.buildingApi[i][j][0];
                }
                if (this.buildingApi[i][j][1] >= y) continue;
                y = this.buildingApi[i][j][1];
            }
        }
        int dx = x - 1;
        int dy = y - 1;
        System.out.println("Shifting by (" + -dx + "," + -dy + ").");
        int i2 = 0;
        while (i2 < this.nodeCount) {
            int n = i2;
            this.xs[n] = this.xs[n] - dx;
            int n2 = i2++;
            this.ys[n2] = this.ys[n2] - dy;
        }
        for (i2 = 0; i2 < this.buildingCount; ++i2) {
            int n = i2;
            this.buildingXs[n] = this.buildingXs[n] - dx;
            int n3 = i2;
            this.buildingYs[n3] = this.buildingYs[n3] - dy;
            for (int j = 0; j < this.buildingApi[i2].length; ++j) {
                int[] nArray = this.buildingApi[i2][j];
                nArray[0] = nArray[0] - dx;
                int[] nArray2 = this.buildingApi[i2][j];
                nArray2[1] = nArray2[1] - dy;
            }
        }
    }

    private void resize() {
        int newSize = this.xs.length * 3 / 2;
        int[] newXs = new int[newSize];
        int[] newYs = new int[newSize];
        int[] newIn = new int[newSize];
        int[] newOut = new int[newSize];
        int[][] newRoads = new int[newSize][newSize];
        int[][] newDist = new int[newSize][newSize];
        boolean[] newVal = new boolean[newSize];
        System.arraycopy(this.xs, 0, newXs, 0, this.nodeCount);
        System.arraycopy(this.ys, 0, newYs, 0, this.nodeCount);
        System.arraycopy(this.inDegree, 0, newIn, 0, this.nodeCount);
        System.arraycopy(this.outDegree, 0, newOut, 0, this.nodeCount);
        System.arraycopy(this.invalid, 0, newVal, 0, this.nodeCount);
        for (int i = 0; i < this.nodeCount; ++i) {
            System.arraycopy(this.roads[i], 0, newRoads[i], 0, this.nodeCount);
            System.arraycopy(this.distances[i], 0, newDist[i], 0, this.nodeCount);
        }
        this.xs = newXs;
        this.ys = newYs;
        this.inDegree = newIn;
        this.outDegree = newOut;
        this.roads = newRoads;
        this.distances = newDist;
        this.invalid = newVal;
    }

    private void resizeBs() {
        int newSize = this.buildingXs.length * 2;
        int[] newXs = new int[newSize];
        int[] newYs = new int[newSize];
        int[] newEnt = new int[newSize];
        int[] newFloors = new int[newSize];
        int[] newTypes = new int[newSize];
        int[][][] newApi = new int[newSize][][];
        System.arraycopy(this.buildingXs, 0, newXs, 0, this.buildingCount);
        System.arraycopy(this.buildingYs, 0, newYs, 0, this.buildingCount);
        System.arraycopy(this.buildingEntrances, 0, newEnt, 0, this.buildingCount);
        System.arraycopy(this.buildingFloors, 0, newFloors, 0, this.buildingCount);
        System.arraycopy(this.buildingTypes, 0, newTypes, 0, this.buildingCount);
        for (int i = 0; i < this.buildingCount; ++i) {
            newApi[i] = this.buildingApi[i];
        }
        this.buildingXs = newXs;
        this.buildingYs = newYs;
        this.buildingEntrances = newEnt;
        this.buildingFloors = newFloors;
        this.buildingTypes = newTypes;
        this.buildingApi = newApi;
    }
}

