/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import rescuecore.tools.simulationrunner.ConfigFile;
import rescuecore.tools.simulationrunner.ProcessHandler;
import rescuecore.tools.simulationrunner.ProcessViewer;
import rescuecore.tools.simulationrunner.RescueProcess;

public class StartSimulation {
    private static final String DEFAULT_CONFIG_FILE = "simulation.config";
    private static final String DEFAULT_LOG_PREFIX = "";
    private static final String[] FILTER_NAMES = new String[]{"Kernel"};
    private static final Class[] FILTER_CLASSES = new Class[]{KernelProcessFilter.class};
    private static final Map filters = new HashMap();
    private ProcessHandler handler;
    private final Thread HALT = new Thread(){

        @Override
        public void run() {
            StartSimulation.this.handler.stopAll();
        }
    };

    public static void main(String[] args) {
        new StartSimulation(args);
    }

    private StartSimulation(String[] args) {
        String config = DEFAULT_CONFIG_FILE;
        String logPrefix = DEFAULT_LOG_PREFIX;
        boolean gui = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-c") || args[i].equalsIgnoreCase("--config")) {
                config = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-l") || args[i].equalsIgnoreCase("--log-prefix")) {
                logPrefix = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-g") || args[i].equalsIgnoreCase("--nogui")) {
                gui = false;
                continue;
            }
            this.printUsage();
            return;
        }
        try {
            ConfigFile configFile = new ConfigFile(config, logPrefix);
            ProcessViewer viewer = new ProcessViewer(configFile.getProcesses().toArray(new RescueProcess[0]));
            this.handler = new ProcessHandler(configFile.getProcesses().toArray(new RescueProcess[0]), viewer);
            if (gui) {
                JFrame frame = new JFrame("Robocup Rescue Simulation");
                frame.setContentPane(viewer);
                frame.pack();
                frame.setVisible(true);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SwingUtilities.invokeLater(StartSimulation.this.HALT);
                    }
                });
            }
            Runtime.getRuntime().addShutdownHook(this.HALT);
            this.handler.runAll();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void printUsage() {
        System.out.println("Usage: StartSimulation [(-c | --config) <config file>] [(-l | --log-prefix) <log prefix>] [(-g | --nogui)]");
        System.out.println("-c\t--config\tUse <config file> to configure the simulator. Default \"simulation.config\"");
        System.out.println("-l\t--log-prefix\tPrepend all log files with <log prefix>. Default is no prefix");
        System.out.println("-g\t--nogui\tDon't show the gui");
    }

    static {
        for (int i = 0; i < FILTER_NAMES.length; ++i) {
            filters.put(FILTER_NAMES[i], FILTER_CLASSES[i]);
        }
    }

    private class KernelProcessFilter
    extends ProcessFilter {
        private KernelProcessFilter() {
        }
    }

    private abstract class ProcessFilter
    implements Runnable {
        private boolean running;
        private boolean alive;
        private BufferedReader reader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            this.running = false;
            ProcessFilter processFilter = this;
            synchronized (processFilter) {
                while (this.alive) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.alive = true;
            this.running = true;
            while (this.running) {
                try {
                    String line = this.reader.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            ProcessFilter processFilter = this;
            synchronized (processFilter) {
                this.alive = false;
                this.notifyAll();
            }
        }

        public JComponent getViewComponent() {
            return null;
        }
    }
}

