/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Shape;
import rescuecore.Memory;
import rescuecore.view.ConvexHull;
import rescuecore.view.MapRenderer;
import rescuecore.view.ScreenTransform;

public class ConvexHullRenderer
implements MapRenderer {
    public static final ConvexHullRenderer RED = new ConvexHullRenderer(Color.RED);
    public static final ConvexHullRenderer GREEN = new ConvexHullRenderer(Color.GREEN);
    public static final ConvexHullRenderer BLUE = new ConvexHullRenderer(Color.BLUE);
    public static final ConvexHullRenderer ORANGE = new ConvexHullRenderer(Color.ORANGE);
    public static final ConvexHullRenderer YELLOW = new ConvexHullRenderer(Color.YELLOW);
    public static final ConvexHullRenderer WHITE = new ConvexHullRenderer(Color.WHITE);
    private Color outline;
    private Color fill;

    private ConvexHullRenderer(Color outline) {
        this.outline = outline;
        this.fill = new Color(outline.getRed(), outline.getGreen(), outline.getBlue(), 96);
    }

    @Override
    public boolean canRender(Object o) {
        return o instanceof ConvexHull;
    }

    @Override
    public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
        int i;
        ConvexHull hull = (ConvexHull)o;
        int[] hullXs = hull.getXs();
        int[] hullYs = hull.getYs();
        int[] xs = new int[hullXs.length];
        int[] ys = new int[hullYs.length];
        System.arraycopy(hullXs, 0, xs, 0, xs.length);
        System.arraycopy(hullYs, 0, ys, 0, ys.length);
        int num = hull.countPoints();
        g.setColor(this.outline);
        for (i = 0; i < num; ++i) {
            g.drawRect(transform.toScreenX(xs[i]) - 1, transform.toScreenY(ys[i]) - 1, 3, 3);
        }
        for (i = 0; i < num; ++i) {
            xs[i] = transform.toScreenX(xs[i]);
            ys[i] = transform.toScreenY(ys[i]);
        }
        Polygon p = new Polygon(xs, ys, xs.length);
        g.setColor(this.fill);
        g.fillPolygon(p);
        g.setColor(this.outline);
        g.drawPolygon(p);
        return p;
    }
}

