/*
 * Decompiled with CFR 0.152.
 */
package traffic3.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityListener;
import rescuecore2.worldmodel.Property;
import traffic3.objects.TrafficArea;

public class TrafficBlockade {
    private Blockade blockade;
    private TrafficArea area;
    private List<Line2D> lines = new ArrayList<Line2D>();

    public TrafficBlockade(final Blockade blockade, TrafficArea area) {
        this.blockade = blockade;
        this.area = area;
        this.lines = null;
        blockade.addEntityListener(new EntityListener(){

            public void propertyChanged(Entity e, Property p, Object oldValue, Object newValue) {
                if (p == blockade.getApexesProperty()) {
                    TrafficBlockade.this.lines = null;
                }
            }
        });
    }

    public List<Line2D> getLines() {
        if (this.lines == null) {
            this.lines = new ArrayList<Line2D>();
            int[] apexes = this.blockade.getApexes();
            for (int i = 0; i < apexes.length - 3; i += 2) {
                Point2D first = new Point2D((double)apexes[i], (double)apexes[i + 1]);
                Point2D second = new Point2D((double)apexes[i + 2], (double)apexes[i + 3]);
                this.lines.add(new Line2D(first, second));
            }
            this.lines.add(new Line2D(new Point2D((double)apexes[apexes.length - 2], (double)apexes[apexes.length - 1]), new Point2D((double)apexes[0], (double)apexes[1])));
        }
        return Collections.unmodifiableList(this.lines);
    }

    public Blockade getBlockade() {
        return this.blockade;
    }

    public TrafficArea getArea() {
        return this.area;
    }

    public boolean contains(double x, double y) {
        return this.blockade.getShape().contains(x, y);
    }
}

