/*
 * Decompiled with CFR 0.152.
 */
package commlib.information;

import commlib.data.DataType;
import commlib.data.EntityIDData;
import commlib.information.WorldInformation;
import commlib.message.BaseMessageType;
import java.util.EnumMap;
import java.util.List;
import rescuecore2.worldmodel.EntityID;

public class UnpassableInformation
extends WorldInformation {
    public UnpassableInformation(int time, EntityID platoonID, EntityID from, EntityID to, EntityID blockade) {
        super(BaseMessageType.UNPASSABLE, time);
        super.setData(new EntityIDData(DataType.PLATOON_AGENT, platoonID));
        super.setData(new EntityIDData(DataType.AREA, from), 0);
        super.setData(new EntityIDData(DataType.AREA, to), 1);
        super.setData(new EntityIDData(DataType.BLOCKADE, blockade));
    }

    public UnpassableInformation(List<Integer> bitList, int offset, EnumMap<DataType, Integer> bitSizeMap) {
        this(BaseMessageType.UNPASSABLE, bitList, offset, bitSizeMap);
    }

    protected UnpassableInformation(BaseMessageType type, List<Integer> bitList, int offset, EnumMap<DataType, Integer> bitSizeMap) {
        super(type, bitList, offset, bitSizeMap);
    }

    public EntityID getAgentID() {
        return super.getID(DataType.PLATOON_AGENT, 0);
    }

    @Override
    public EntityID getEntityID() {
        return this.getAgentID();
    }

    public EntityID getFromAreaID() {
        return super.getID(DataType.AREA, 0);
    }

    public EntityID getToAreaID() {
        return super.getID(DataType.AREA, 1);
    }

    public EntityID getBLockadeID() {
        return super.getID(DataType.BLOCKADE, 0);
    }
}

