/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.components;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import rescuecore2.components.AbstractComponent;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.RequestIDGenerator;
import rescuecore2.components.Viewer;
import rescuecore2.config.Config;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.KVConnectError;
import rescuecore2.messages.control.KVConnectOK;
import rescuecore2.messages.control.KVTimestep;
import rescuecore2.messages.control.VKAcknowledge;
import rescuecore2.messages.control.VKConnect;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public abstract class AbstractViewer<T extends WorldModel<? extends Entity>>
extends AbstractComponent<T>
implements Viewer {
    protected int viewerID;
    private int lastUpdateTime;

    protected AbstractViewer() {
    }

    public final int getViewerID() {
        return this.viewerID;
    }

    @Override
    public void postConnect(Connection c, int id, Collection<Entity> entities, Config kernelConfig) {
        this.viewerID = id;
        this.lastUpdateTime = 0;
        super.postConnect(c, entities, kernelConfig);
    }

    @Override
    public void connect(Connection connection, RequestIDGenerator generator, Config config) throws ConnectionException, ComponentConnectionException, InterruptedException {
        this.config = config;
        int requestID = generator.generateRequestID();
        VKConnect connect = new VKConnect(requestID, 1, this.getName());
        CountDownLatch latch = new CountDownLatch(1);
        ViewerConnectionListener l = new ViewerConnectionListener(requestID, latch);
        connection.addConnectionListener(l);
        connection.sendMessage(connect);
        latch.await();
        l.testSuccess();
    }

    protected void handleTimestep(KVTimestep timestep) {
        ChangeSet changes = timestep.getChangeSet();
        int time = timestep.getTime();
        if (time != this.lastUpdateTime + 1) {
            Logger.warn("Recieved an unexpected update from the kernel. Last update: " + this.lastUpdateTime + ", this update: " + time);
        }
        this.lastUpdateTime = time;
        this.model.merge(changes);
    }

    @Override
    protected void processMessage(Message msg) {
        if (msg instanceof KVTimestep) {
            KVTimestep t = (KVTimestep)msg;
            if (t.getTargetID() == this.viewerID) {
                this.handleTimestep(t);
            }
        } else {
            super.processMessage(msg);
        }
    }

    private class ViewerConnectionListener
    implements ConnectionListener {
        private int requestID;
        private CountDownLatch latch;
        private ComponentConnectionException failureReason;

        public ViewerConnectionListener(int requestID, CountDownLatch latch) {
            this.requestID = requestID;
            this.latch = latch;
            this.failureReason = null;
        }

        @Override
        public void messageReceived(Connection c, Message msg) {
            if (msg instanceof KVConnectOK) {
                this.handleConnectOK(c, (KVConnectOK)msg);
            }
            if (msg instanceof KVConnectError) {
                this.handleConnectError(c, (KVConnectError)msg);
            }
        }

        private void handleConnectOK(Connection c, KVConnectOK ok) {
            if (ok.getRequestID() == this.requestID) {
                c.removeConnectionListener(this);
                AbstractViewer.this.postConnect(c, ok.getViewerID(), ok.getEntities(), ok.getConfig());
                try {
                    c.sendMessage(new VKAcknowledge(this.requestID, ok.getViewerID()));
                }
                catch (ConnectionException e) {
                    this.failureReason = new ComponentConnectionException(e);
                }
                this.latch.countDown();
            }
        }

        private void handleConnectError(Connection c, KVConnectError error) {
            if (error.getRequestID() == this.requestID) {
                c.removeConnectionListener(this);
                this.failureReason = new ComponentConnectionException(error.getReason());
                this.latch.countDown();
            }
        }

        void testSuccess() throws ComponentConnectionException {
            if (this.failureReason != null) {
                throw this.failureReason;
            }
        }
    }
}

