/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.components;

import rescuecore2.components.Component;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.RequestIDGenerator;
import rescuecore2.config.Config;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.log.Logger;
import rescuecore2.registry.Registry;

public abstract class ComponentLauncher
implements RequestIDGenerator {
    private Config config;
    private int nextRequestID;
    private Registry defaultRegistry;

    public ComponentLauncher(Config config) {
        this.config = config;
        this.nextRequestID = 1;
        this.defaultRegistry = Registry.SYSTEM_REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Component c) throws InterruptedException, ConnectionException, ComponentConnectionException {
        Connection connection = this.makeConnection();
        connection.setName("Connection from " + c.getName());
        Logger.pushLogContext(c.getPreferredLogContext());
        connection.setRegistry(c.getPreferredRegistry(this.defaultRegistry));
        connection.startup();
        try {
            c.connect(connection, this, new Config(this.config));
        }
        finally {
            Logger.popLogContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generateRequestID() {
        ComponentLauncher componentLauncher = this;
        synchronized (componentLauncher) {
            return this.nextRequestID++;
        }
    }

    public void setDefaultRegistry(Registry registry) {
        this.defaultRegistry = registry;
    }

    public Registry getDefaultRegistry() {
        return this.defaultRegistry;
    }

    protected abstract Connection makeConnection() throws ConnectionException;
}

