/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.uncommons.maths.random.MersenneTwisterRNG;
import org.uncommons.maths.random.SeedGenerator;
import rescuecore2.config.ConfigConstraint;
import rescuecore2.config.ConfigException;
import rescuecore2.config.NoSuchConfigOptionException;
import rescuecore2.log.Logger;

public class Config {
    private static final String ARRAY_REGEX = " |,";
    private Map<String, String> data = new HashMap<String, String>();
    private Set<String> noCache = new HashSet<String>();
    private Map<String, Integer> intData = new HashMap<String, Integer>();
    private Map<String, Double> floatData = new HashMap<String, Double>();
    private Map<String, Boolean> booleanData = new HashMap<String, Boolean>();
    private Map<String, List<String>> arrayData = new HashMap<String, List<String>>();
    private Set<ConfigConstraint> constraints = new HashSet<ConfigConstraint>();
    private Set<ConfigConstraint> violatedConstraints = new HashSet<ConfigConstraint>();
    private Random random;

    public Config() {
    }

    public Config(File file) throws ConfigException {
        this();
        this.read(file);
    }

    public Config(Config other) {
        this();
        this.data.putAll(other.data);
    }

    public void read(String resource) throws ConfigException {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        new ResourceContext(resource).process(this);
        this.checkAllConstraints();
    }

    public void read(File file) throws ConfigException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        new FileContext(file).process(this);
        this.checkAllConstraints();
    }

    public void read(Reader reader, String name) throws ConfigException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        new ReaderContext(reader, name).process(this);
        this.checkAllConstraints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWithContext(BufferedReader reader, Context context) throws ConfigException {
        String line = "";
        int lineNumber = 0;
        String name = context.getName();
        try {
            while (line != null) {
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    throw new ConfigException(name, e);
                }
                ++lineNumber;
                if (line == null) continue;
                int hashIndex = line.indexOf("#");
                if (hashIndex != -1) {
                    line = line.substring(0, hashIndex).trim();
                }
                if ("".equals(line = line.trim())) continue;
                LineType.process(line, context, this, lineNumber);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                Logger.error("Error reading config", e);
            }
        }
    }

    public void write(PrintWriter out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        for (Map.Entry<String, String> next : this.data.entrySet()) {
            out.print(next.getKey());
            out.print(" : ");
            out.println(next.getValue());
        }
    }

    public void merge(Config other) {
        this.clearCache();
        this.data.putAll(other.data);
        this.checkAllConstraints();
    }

    public void addConstraint(ConfigConstraint c) {
        this.constraints.add(c);
        this.checkConstraint(c);
    }

    public void removeConstraint(ConfigConstraint c) {
        this.constraints.remove(c);
        this.violatedConstraints.remove(c);
    }

    public Set<ConfigConstraint> getViolatedConstraints() {
        return Collections.unmodifiableSet(this.violatedConstraints);
    }

    public Set<String> getAllKeys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public boolean isDefined(String key) {
        return this.data.containsKey(key);
    }

    public String getValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (!this.data.containsKey(key)) {
            throw new NoSuchConfigOptionException(key);
        }
        return this.processDollarNotation(key, this.data.get(key));
    }

    public String getValue(String key, String defaultValue) {
        try {
            return this.getValue(key);
        }
        catch (NoSuchConfigOptionException e) {
            return defaultValue;
        }
    }

    public int getIntValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (!this.noCache.contains(key) && this.intData.containsKey(key)) {
            return this.intData.get(key);
        }
        int result = Integer.parseInt(this.getValue(key));
        this.intData.put(key, result);
        return result;
    }

    public int getIntValue(String key, int defaultValue) {
        try {
            return this.getIntValue(key);
        }
        catch (NoSuchConfigOptionException e) {
            return defaultValue;
        }
    }

    public double getFloatValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (!this.noCache.contains(key) && this.floatData.containsKey(key)) {
            return this.floatData.get(key);
        }
        double result = Double.parseDouble(this.getValue(key));
        this.floatData.put(key, result);
        return result;
    }

    public double getFloatValue(String key, double defaultValue) {
        try {
            return this.getFloatValue(key);
        }
        catch (NoSuchConfigOptionException e) {
            return defaultValue;
        }
    }

    public boolean getBooleanValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (!this.noCache.contains(key) && this.booleanData.containsKey(key)) {
            return this.booleanData.get(key);
        }
        boolean result = false;
        String value = this.getValue(key);
        if ("true".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            result = true;
        }
        this.booleanData.put(key, result);
        return result;
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        try {
            return this.getBooleanValue(key);
        }
        catch (NoSuchConfigOptionException e) {
            return defaultValue;
        }
    }

    public List<String> getArrayValue(String key) {
        List<String> entry;
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (!this.noCache.contains(key) && this.arrayData.containsKey(key) && (entry = this.arrayData.get(key)) != null) {
            return entry;
        }
        List<String> result = this.splitArrayValue(this.getValue(key));
        this.arrayData.put(key, result);
        return result;
    }

    public List<String> getArrayValue(String key, String defaultValue) {
        try {
            return this.getArrayValue(key);
        }
        catch (NoSuchConfigOptionException e) {
            if (defaultValue == null) {
                return null;
            }
            return this.splitArrayValue(defaultValue);
        }
    }

    private List<String> splitArrayValue(String value) {
        String[] s;
        ArrayList<String> result = new ArrayList<String>();
        for (String next : s = value.split(ARRAY_REGEX)) {
            if ("".equals(next)) continue;
            result.add(next);
        }
        return result;
    }

    public void setValue(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (value == null) {
            this.removeKey(key);
            return;
        }
        this.clearCache(key);
        this.noCache.remove(key);
        this.data.put(key, value);
        this.checkAllConstraints();
    }

    public void appendValue(String key, String value) {
        this.appendValue(key, value, " ");
    }

    public void appendValue(String key, String value, String separator) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.clearCache(key);
        if (this.data.containsKey(key)) {
            String old = this.data.get(key);
            this.data.put(key, old + separator + value);
        } else {
            this.data.put(key, value);
        }
        this.checkAllConstraints();
    }

    public void setIntValue(String key, int value) {
        this.setValue(key, Integer.valueOf(value).toString());
        this.intData.put(key, value);
    }

    public void setFloatValue(String key, double value) {
        this.setValue(key, Double.valueOf(value).toString());
        this.floatData.put(key, value);
    }

    public void setBooleanValue(String key, boolean value) {
        this.setValue(key, value ? "true" : "false");
        this.booleanData.put(key, value);
    }

    public void removeKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.clearCache(key);
        this.noCache.remove(key);
        this.data.remove(key);
    }

    public void removeAllKeys() {
        this.data.clear();
        this.noCache.clear();
        this.intData.clear();
        this.floatData.clear();
        this.booleanData.clear();
        this.arrayData.clear();
    }

    public void removeExcept(String ... exceptions) {
        this.removeExcept(Arrays.asList(exceptions));
    }

    public void removeExcept(Collection<String> exceptions) {
        this.data.keySet().retainAll(exceptions);
        this.noCache.retainAll(exceptions);
    }

    public void removeExceptRegex(Collection<String> exceptions) {
        HashSet<String> toRemove = new HashSet<String>(this.data.keySet());
        Logger.debug("Removing all except " + exceptions);
        for (String exception : exceptions) {
            Pattern p = Pattern.compile(exception);
            for (String key : this.data.keySet()) {
                if (!p.matcher(key).matches()) continue;
                Logger.debug(key + " matches " + exception);
                toRemove.remove(key);
            }
        }
        Logger.debug("Removing " + toRemove);
        for (String next : toRemove) {
            this.data.remove(next);
            this.noCache.remove(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Random getRandom() {
        Config config = this;
        synchronized (config) {
            if (this.random == null) {
                block26: {
                    String className = this.getValue("random.class", "org.uncommons.maths.random.MersenneTwisterRNG");
                    String seed = this.getValue("random.seed", "");
                    try {
                        Constructor<Random> constructor;
                        Class<Random> clazz = Class.forName(className).asSubclass(Random.class);
                        Logger.debug("Instantiating random number generator: " + className);
                        if ("".equals(seed)) {
                            try {
                                Logger.trace("Trying to find no-arg constructor");
                                this.random = clazz.newInstance();
                                Logger.trace("Success");
                            }
                            catch (IllegalAccessException e) {
                                Logger.trace("No-arg constructor for " + className, e);
                            }
                            catch (InstantiationException e) {
                                Logger.trace("No-arg constructor for " + className, e);
                            }
                            break block26;
                        }
                        Logger.debug("Using seed " + seed);
                        BigInteger bi = new BigInteger(seed, 16);
                        try {
                            Logger.trace("Trying to find a SeedGenerator constructor");
                            constructor = clazz.getConstructor(SeedGenerator.class);
                            this.random = constructor.newInstance(new StaticSeedGenerator(bi.toByteArray()));
                            Logger.trace("Success");
                        }
                        catch (IllegalAccessException e) {
                            Logger.trace("SeedGenerator constructor for " + className, e);
                        }
                        catch (InstantiationException e) {
                            Logger.trace("SeedGenerator constructor for " + className, e);
                        }
                        catch (NoSuchMethodException e) {
                            Logger.trace("SeedGenerator constructor for " + className, e);
                        }
                        catch (InvocationTargetException e) {
                            Logger.trace("SeedGenerator constructor for " + className, e);
                        }
                        if (this.random == null) {
                            Logger.trace("Trying to find a long constructor");
                            try {
                                constructor = clazz.getConstructor(Long.TYPE);
                                this.random = constructor.newInstance(bi.longValue());
                                Logger.trace("Success");
                            }
                            catch (IllegalAccessException e) {
                                Logger.trace("Long constructor for " + className, e);
                            }
                            catch (InstantiationException e) {
                                Logger.trace("Long constructor for " + className, e);
                            }
                            catch (NoSuchMethodException e) {
                                Logger.trace("Long constructor for " + className, e);
                            }
                            catch (InvocationTargetException e) {
                                Logger.trace("Long constructor for " + className, e);
                            }
                        }
                        if (this.random == null) {
                            try {
                                Logger.trace("Trying to find no-arg constructor");
                                this.random = clazz.newInstance();
                                Logger.trace("Success");
                            }
                            catch (IllegalAccessException e) {
                                Logger.trace("No-arg constructor for " + className, e);
                            }
                            catch (InstantiationException e) {
                                Logger.trace("No-arg constructor for " + className, e);
                            }
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Logger.debug("Class not found: " + className);
                    }
                }
                if (this.random == null) {
                    Logger.debug("Using fallback RNG");
                    this.random = new MersenneTwisterRNG();
                }
            }
            return this.random;
        }
    }

    private void clearCache() {
        this.intData.clear();
        this.floatData.clear();
        this.booleanData.clear();
        this.arrayData.clear();
    }

    private void clearCache(String key) {
        this.intData.remove(key);
        this.floatData.remove(key);
        this.booleanData.remove(key);
        this.arrayData.remove(key);
    }

    private String processDollarNotation(String key, String value) {
        int index = value.indexOf("${");
        if (index == -1) {
            return value;
        }
        this.noCache.add(key);
        int end = value.indexOf("}", index);
        int colon = value.indexOf(":", index);
        String reference = value.substring(index + 2, end);
        String defaultValue = null;
        if (colon > index && colon < end) {
            reference = value.substring(index + 2, colon);
            defaultValue = value.substring(colon + 1, end);
        }
        StringBuilder result = new StringBuilder();
        result.append(value.substring(0, index));
        result.append(this.resolveReferences(reference, defaultValue));
        result.append(this.processDollarNotation(key, value.substring(end + 1)));
        return result.toString();
    }

    private String resolveReferences(String s, String defaultValue) {
        try {
            return this.getValue(s);
        }
        catch (NoSuchConfigOptionException e) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw e;
        }
    }

    private void checkAllConstraints() {
        this.violatedConstraints.clear();
        for (ConfigConstraint next : this.constraints) {
            this.checkConstraint(next);
        }
    }

    private void checkConstraint(ConfigConstraint c) {
        if (c == null) {
            return;
        }
        if (c.isViolated(this)) {
            this.violatedConstraints.add(c);
        } else {
            this.violatedConstraints.remove(c);
        }
    }

    private static enum LineType {
        INCLUDE{

            @Override
            public void process(Matcher matcher, Context context, Config config, int lineNumber) throws ConfigException {
                String includeName = matcher.group(1).trim();
                if ("".equals(includeName)) {
                    throw new ConfigException(context.getName(), lineNumber, "Empty include directive");
                }
                Logger.trace("Reading included config '" + includeName + "'");
                Context newContext = context.include(includeName);
                newContext.process(config);
            }

            @Override
            protected String getRegex() {
                return "^!include\\s*(.*)";
            }
        }
        ,
        ADDITIVE{

            @Override
            public void process(Matcher matcher, Context context, Config config, int lineNumber) throws ConfigException {
                String key = matcher.group(1).trim();
                String value = matcher.group(2).trim();
                if ("".equals(key)) {
                    throw new ConfigException(context.getName(), lineNumber, "Empty key");
                }
                if ("".equals(value)) {
                    throw new ConfigException(context.getName(), lineNumber, "Empty value");
                }
                String existing = config.getValue(key, null);
                if (existing != null && !"".equals(existing)) {
                    Logger.trace("Appending '" + value + "' to '" + key + "'");
                    value = existing + " " + value;
                } else {
                    Logger.trace("Setting '" + key + "' to '" + value + "'");
                }
                config.setValue(key, value);
            }

            @Override
            protected String getRegex() {
                return "^([^+]*)(?:\\+:|=)(.*)";
            }
        }
        ,
        NORMAL{

            @Override
            public void process(Matcher matcher, Context context, Config config, int lineNumber) throws ConfigException {
                String key = matcher.group(1).trim();
                String value = matcher.group(2).trim();
                if ("".equals(key)) {
                    throw new ConfigException(context.getName(), lineNumber, "Empty key");
                }
                if ("".equals(value)) {
                    throw new ConfigException(context.getName(), lineNumber, "Empty value");
                }
                Logger.trace("Setting '" + key + "' to '" + value + "'");
                if (config.isDefined(key) && !value.equals(config.getValue(key))) {
                    Logger.warn("Redefining config key '" + key + "' as '" + value + "'");
                }
                config.setValue(key, value);
            }

            @Override
            protected String getRegex() {
                return "^([^:=]*)(?::|=)(.*)";
            }
        };

        private Pattern pattern = Pattern.compile(this.getRegex());

        public Pattern getPattern() {
            return this.pattern;
        }

        protected abstract String getRegex();

        protected abstract void process(Matcher var1, Context var2, Config var3, int var4) throws ConfigException;

        public static void process(String line, Context context, Config config, int lineNumber) throws ConfigException {
            for (LineType next : LineType.values()) {
                Matcher matcher = next.getPattern().matcher(line);
                if (!matcher.matches()) continue;
                next.process(matcher, context, config, lineNumber);
                return;
            }
            throw new ConfigException(context.getName(), lineNumber, "Unrecognised config option: '" + line + "'");
        }
    }

    private static class StaticSeedGenerator
    implements SeedGenerator {
        private byte[] data;

        StaticSeedGenerator(byte[] data) {
            this.data = data;
        }

        public byte[] generateSeed(int length) {
            byte[] result = new byte[length];
            System.arraycopy(this.data, 0, result, 0, Math.min(this.data.length, result.length));
            return result;
        }
    }

    private static class ResourceContext
    implements Context {
        private String name;

        public ResourceContext(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void process(Config config) throws ConfigException {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.name);
            if (in == null) {
                throw new ConfigException(this.name, "Resource not found");
            }
            config.readWithContext(new BufferedReader(new InputStreamReader(in)), this);
        }

        @Override
        public Context include(String path) throws ConfigException {
            return new ResourceContext(path);
        }
    }

    private static class ReaderContext
    implements Context {
        private BufferedReader reader;
        private String name;

        public ReaderContext(Reader r, String name) {
            this.name = name;
            this.reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void process(Config config) throws ConfigException {
            config.readWithContext(this.reader, this);
        }

        @Override
        public Context include(String path) throws ConfigException {
            throw new ConfigException(this.name, "Cannot process include directives when reading raw data streams");
        }
    }

    private static class FileContext
    implements Context {
        private File file;

        public FileContext(File file) {
            this.file = file;
        }

        @Override
        public String getName() {
            return this.file.getAbsolutePath();
        }

        @Override
        public void process(Config config) throws ConfigException {
            if (!this.file.exists()) {
                throw new ConfigException(this.getName(), "File does not exist");
            }
            if (this.file.isDirectory()) {
                for (File next : this.file.listFiles()) {
                    new FileContext(next).process(config);
                }
                return;
            }
            try {
                config.readWithContext(new BufferedReader(new FileReader(this.file)), this);
            }
            catch (IOException e) {
                throw new ConfigException(this.getName(), e);
            }
        }

        @Override
        public Context include(String path) throws ConfigException {
            File newFile = new File(this.file.getParentFile(), path);
            return new FileContext(newFile);
        }
    }

    private static interface Context {
        public String getName();

        public void process(Config var1) throws ConfigException;

        public Context include(String var1) throws ConfigException;
    }
}

