/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.geometry;

import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;
import rescuecore2.misc.geometry.spatialindex.Indexable;
import rescuecore2.misc.geometry.spatialindex.LineRegion;
import rescuecore2.misc.geometry.spatialindex.Region;

public class Line2D
implements Indexable {
    private Point2D origin;
    private Point2D end;
    private Vector2D direction;
    private LineRegion region;

    public Line2D(Point2D origin, Vector2D direction) {
        this.origin = origin;
        this.direction = direction;
        this.end = origin.plus(direction);
    }

    public Line2D(Point2D origin, Point2D end) {
        this.origin = origin;
        this.end = end;
        this.direction = end.minus(origin);
    }

    public Line2D(double x, double y, double dx, double dy) {
        this(new Point2D(x, y), new Vector2D(dx, dy));
    }

    public Point2D getPoint(double t) {
        return this.origin.translate(t * this.direction.getX(), t * this.direction.getY());
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public Point2D getEndPoint() {
        return this.end;
    }

    public Vector2D getDirection() {
        return this.direction;
    }

    public String toString() {
        return "Line from " + this.origin + " towards " + this.end + " (direction = " + this.direction + ")";
    }

    public double getIntersection(Line2D other) {
        double bxax = this.direction.getX();
        double dycy = other.direction.getY();
        double byay = this.direction.getY();
        double dxcx = other.direction.getX();
        double cxax = other.origin.getX() - this.origin.getX();
        double cyay = other.origin.getY() - this.origin.getY();
        double d = bxax * dycy - byay * dxcx;
        double t = cxax * dycy - cyay * dxcx;
        if (GeometryTools2D.nearlyZero(d)) {
            return Double.NaN;
        }
        return t / d;
    }

    @Override
    public Region getBoundingRegion() {
        if (this.region == null) {
            this.region = new LineRegion(this.origin.getX(), this.origin.getY(), this.end.getX(), this.end.getY());
        }
        return this.region;
    }
}

