/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import rescuecore2.misc.collections.ArrayTools;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.Property;

public class EntityInspector
extends JTable {
    private static final Comparator<Property> PROPERTY_NAME_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            return p1.getURN().compareTo(p2.getURN());
        }
    };
    private EntityTableModel model = new EntityTableModel();

    public EntityInspector() {
        this.setModel(this.model);
    }

    public void inspect(Entity e) {
        this.model.setEntity(e);
    }

    private static class EntityTableModel
    extends AbstractTableModel {
        private Entity e = null;
        private List<Property> props = new ArrayList<Property>();

        public void setEntity(Entity entity) {
            this.e = entity;
            this.props.clear();
            if (this.e != null) {
                this.props.addAll(this.e.getProperties());
                Collections.sort(this.props, PROPERTY_NAME_COMPARATOR);
            }
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.props.size() + 2;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    if (row == 0) {
                        return "ID";
                    }
                    if (row == 1) {
                        return "Type";
                    }
                    return this.props.get(row - 2).getURN();
                }
                case 1: {
                    if (row == 0) {
                        return this.e == null ? "" : this.e.getID();
                    }
                    if (row == 1) {
                        return this.e == null ? "" : this.e.getURN();
                    }
                    Property prop = this.props.get(row - 2);
                    if (prop.isDefined()) {
                        Object value = prop.getValue();
                        if (value.getClass().isArray()) {
                            return ArrayTools.convertArrayObjectToString(value);
                        }
                        return value;
                    }
                    return "Undefined";
                }
            }
            throw new IllegalArgumentException("Invalid column: " + col);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Property";
                }
                case 1: {
                    return "Value";
                }
            }
            throw new IllegalArgumentException("Invalid column: " + col);
        }
    }
}

