/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rescuecore2.misc.EncodingTools;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.Property;

public class Point2DProperty
extends AbstractProperty {
    private Point2D value;

    public Point2DProperty(String urn) {
        super(urn);
    }

    public Point2DProperty(Enum<?> urn) {
        super(urn);
    }

    public Point2DProperty(String urn, Point2D value) {
        super(urn, true);
        this.value = value;
    }

    public Point2DProperty(Enum<?> urn, Point2D value) {
        super(urn, true);
        this.value = value;
    }

    public Point2DProperty(Point2DProperty other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public Point2D getValue() {
        if (!this.isDefined()) {
            return null;
        }
        return this.value;
    }

    public void setValue(Point2D value) {
        this.value = value;
        this.setDefined();
    }

    @Override
    public void takeValue(Property p) {
        if (p instanceof Point2DProperty) {
            Point2DProperty i = (Point2DProperty)p;
            if (i.isDefined()) {
                this.setValue(i.getValue());
            } else {
                this.undefine();
            }
        } else {
            throw new IllegalArgumentException(this + " cannot take value from " + p);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeDouble(this.value.getX(), out);
        EncodingTools.writeDouble(this.value.getY(), out);
    }

    @Override
    public void read(InputStream in) throws IOException {
        double x = EncodingTools.readDouble(in);
        double y = EncodingTools.readDouble(in);
        this.setValue(new Point2D(x, y));
    }

    @Override
    public Point2DProperty copy() {
        return new Point2DProperty(this);
    }
}

