/*
 * Decompiled with CFR 0.152.
 */
package maps.convert;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import maps.Map;
import maps.MapFormat;
import maps.MapWriter;
import maps.convert.osm2gml.Convertor;
import maps.gml.GMLMap;
import maps.gml.formats.RobocupFormat;
import maps.gml.view.GMLMapViewer;
import maps.osm.OSMException;
import maps.osm.OSMMap;
import maps.osm.OSMMapViewer;
import org.dom4j.DocumentException;

public final class Convert {
    private static final double NEARBY_NODE_THRESHOLD = 1.0E-6;
    private static final int PROGRESS_WIDTH = 200;
    private static final int PROGRESS_HEIGHT = 10;
    private static final int VIEWER_SIZE = 500;
    private static final int STATUS_WIDTH = 500;
    private static final int STATUS_HEIGHT = 10;
    private static final int MARGIN = 4;

    private Convert() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: Convert <osm-mapname> <gml-mapname>");
            return;
        }
        try {
            OSMMap osmMap = Convert.readOSMMap(args[0]);
            OSMMapViewer osmViewer = new OSMMapViewer(osmMap);
            Convertor convert = new Convertor();
            GMLMap gmlMap = convert.convert(osmMap);
            MapWriter.writeMap((Map)gmlMap, args[1], (MapFormat)RobocupFormat.INSTANCE);
            GMLMapViewer gmlViewer = new GMLMapViewer(gmlMap);
            JFrame frame = new JFrame("Convertor");
            JPanel main = new JPanel(new GridLayout(1, 2));
            osmViewer.setPreferredSize(new Dimension(500, 500));
            gmlViewer.setPreferredSize(new Dimension(500, 500));
            osmViewer.setBorder(BorderFactory.createTitledBorder("OSM map"));
            gmlViewer.setBorder(BorderFactory.createTitledBorder("GML map"));
            main.add(osmViewer);
            main.add(gmlViewer);
            frame.setContentPane(main);
            frame.pack();
            frame.setVisible(true);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static OSMMap readOSMMap(String file) throws OSMException, IOException, DocumentException {
        File f = new File(file);
        return new OSMMap(f);
    }
}

