/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.ConvertTools;
import maps.convert.osm2gml.OSMBuildingInfo;
import maps.convert.osm2gml.OSMIntersectionInfo;
import maps.convert.osm2gml.OSMRoadInfo;
import maps.convert.osm2gml.TemporaryMap;
import maps.osm.OSMBuilding;
import maps.osm.OSMMap;
import maps.osm.OSMNode;
import maps.osm.OSMRoad;

public class ScanOSMStep
extends ConvertStep {
    private TemporaryMap map;
    private Map<OSMNode, OSMIntersectionInfo> nodeToIntersection;
    private List<OSMIntersectionInfo> intersections;
    private List<OSMRoadInfo> roads;
    private List<OSMBuildingInfo> buildings;

    public ScanOSMStep(TemporaryMap map) {
        this.map = map;
    }

    @Override
    public String getDescription() {
        return "Scanning OpenStreetMap data";
    }

    @Override
    protected void step() {
        this.nodeToIntersection = new HashMap<OSMNode, OSMIntersectionInfo>();
        this.intersections = new ArrayList<OSMIntersectionInfo>();
        this.roads = new ArrayList<OSMRoadInfo>();
        this.buildings = new ArrayList<OSMBuildingInfo>();
        OSMMap osm = this.map.getOSMMap();
        this.setProgressLimit(osm.getRoads().size() + osm.getBuildings().size());
        this.setStatus("Scanning roads and buildings");
        this.scanRoads();
        this.scanBuildings();
        double sizeOf1m = ConvertTools.sizeOf1Metre(osm);
        this.setStatus("Generating intersections");
        this.setProgressLimit(this.intersections.size());
        this.setProgress(0);
        for (OSMIntersectionInfo next : this.intersections) {
            next.process(sizeOf1m);
            this.bumpProgress();
        }
        this.setStatus("Created " + this.roads.size() + " roads, " + this.intersections.size() + " intersections, " + this.buildings.size() + " buildings");
        this.map.setOSMInfo(this.intersections, this.roads, this.buildings);
    }

    private void scanRoads() {
        OSMMap osm = this.map.getOSMMap();
        for (OSMRoad road : osm.getRoads()) {
            Iterator<Long> it = road.getNodeIDs().iterator();
            OSMNode start = osm.getNode(it.next());
            while (it.hasNext()) {
                OSMNode end = osm.getNode(it.next());
                if (start == end) {
                    System.out.println("Degenerate road: " + road.getID());
                    continue;
                }
                OSMIntersectionInfo from = this.nodeToIntersection.get(start);
                OSMIntersectionInfo to = this.nodeToIntersection.get(end);
                if (from == null) {
                    from = new OSMIntersectionInfo(start);
                    this.nodeToIntersection.put(start, from);
                    this.intersections.add(from);
                }
                if (to == null) {
                    to = new OSMIntersectionInfo(end);
                    this.nodeToIntersection.put(end, to);
                    this.intersections.add(to);
                }
                OSMRoadInfo roadInfo = new OSMRoadInfo(start, end);
                from.addRoadSegment(roadInfo);
                to.addRoadSegment(roadInfo);
                start = end;
                this.roads.add(roadInfo);
            }
            this.bumpProgress();
        }
    }

    private void scanBuildings() {
        OSMMap osm = this.map.getOSMMap();
        for (OSMBuilding building : osm.getBuildings()) {
            this.buildings.add(new OSMBuildingInfo(building, osm));
            this.bumpProgress();
        }
    }
}

