/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import maps.convert.osm2gml.ConvertTools;
import maps.convert.osm2gml.DirectedEdge;
import maps.convert.osm2gml.Edge;
import maps.convert.osm2gml.Node;
import maps.convert.osm2gml.OSMBuildingInfo;
import maps.convert.osm2gml.OSMIntersectionInfo;
import maps.convert.osm2gml.OSMRoadInfo;
import maps.convert.osm2gml.TemporaryBuilding;
import maps.convert.osm2gml.TemporaryIntersection;
import maps.convert.osm2gml.TemporaryObject;
import maps.convert.osm2gml.TemporaryRoad;
import maps.osm.OSMMap;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.misc.geometry.Point2D;

public class TemporaryMap {
    private static final double NEARBY_THRESHOLD_M = 1.0;
    private double threshold;
    private Set<Node> nodes;
    private Set<Edge> edges;
    private Map<Node, Set<Edge>> edgesAtNode;
    private Map<Edge, Set<TemporaryObject>> objectsAtEdge;
    private Set<TemporaryRoad> tempRoads;
    private Set<TemporaryIntersection> tempIntersections;
    private Set<TemporaryBuilding> tempBuildings;
    private Set<TemporaryObject> allObjects;
    private OSMMap osmMap;
    private Collection<OSMIntersectionInfo> osmIntersections;
    private Collection<OSMRoadInfo> osmRoads;
    private Collection<OSMBuildingInfo> osmBuildings;
    private int nextID;

    public TemporaryMap(OSMMap osmMap) {
        this.osmMap = osmMap;
        this.nextID = 0;
        this.nodes = new HashSet<Node>();
        this.edges = new HashSet<Edge>();
        this.threshold = ConvertTools.nearbyThreshold(osmMap, 1.0);
        this.tempRoads = new HashSet<TemporaryRoad>();
        this.tempIntersections = new HashSet<TemporaryIntersection>();
        this.tempBuildings = new HashSet<TemporaryBuilding>();
        this.allObjects = new HashSet<TemporaryObject>();
        this.edgesAtNode = new LazyMap<Node, Set<Edge>>(){

            public Set<Edge> createValue() {
                return new HashSet<Edge>();
            }
        };
        this.objectsAtEdge = new LazyMap<Edge, Set<TemporaryObject>>(){

            public Set<TemporaryObject> createValue() {
                return new HashSet<TemporaryObject>();
            }
        };
    }

    public OSMMap getOSMMap() {
        return this.osmMap;
    }

    public void setOSMInfo(Collection<OSMIntersectionInfo> intersections, Collection<OSMRoadInfo> roads, Collection<OSMBuildingInfo> buildings) {
        this.osmIntersections = new HashSet<OSMIntersectionInfo>(intersections);
        this.osmRoads = new HashSet<OSMRoadInfo>(roads);
        this.osmBuildings = new HashSet<OSMBuildingInfo>(buildings);
    }

    public Collection<OSMIntersectionInfo> getOSMIntersectionInfo() {
        return Collections.unmodifiableCollection(this.osmIntersections);
    }

    public Collection<OSMRoadInfo> getOSMRoadInfo() {
        return Collections.unmodifiableCollection(this.osmRoads);
    }

    public Collection<OSMBuildingInfo> getOSMBuildingInfo() {
        return Collections.unmodifiableCollection(this.osmBuildings);
    }

    public void addRoad(TemporaryRoad road) {
        this.tempRoads.add(road);
        this.addObject(road);
    }

    public void removeRoad(TemporaryRoad road) {
        this.tempRoads.remove(road);
        this.removeObject(road);
    }

    public void addIntersection(TemporaryIntersection intersection) {
        this.tempIntersections.add(intersection);
        this.addObject(intersection);
    }

    public void removeIntersection(TemporaryIntersection intersection) {
        this.tempIntersections.remove(intersection);
        this.removeObject(intersection);
    }

    public void addBuilding(TemporaryBuilding building) {
        this.tempBuildings.add(building);
        this.addObject(building);
    }

    public void removeBuilding(TemporaryBuilding building) {
        this.tempBuildings.remove(building);
        this.removeObject(building);
    }

    public void addTemporaryObject(TemporaryObject object) {
        if (object instanceof TemporaryRoad) {
            this.addRoad((TemporaryRoad)object);
        }
        if (object instanceof TemporaryIntersection) {
            this.addIntersection((TemporaryIntersection)object);
        }
        if (object instanceof TemporaryBuilding) {
            this.addBuilding((TemporaryBuilding)object);
        }
    }

    public void removeTemporaryObject(TemporaryObject object) {
        if (object instanceof TemporaryRoad) {
            this.removeRoad((TemporaryRoad)object);
        }
        if (object instanceof TemporaryIntersection) {
            this.removeIntersection((TemporaryIntersection)object);
        }
        if (object instanceof TemporaryBuilding) {
            this.removeBuilding((TemporaryBuilding)object);
        }
    }

    public Collection<TemporaryRoad> getRoads() {
        return new HashSet<TemporaryRoad>(this.tempRoads);
    }

    public Collection<TemporaryIntersection> getIntersections() {
        return new HashSet<TemporaryIntersection>(this.tempIntersections);
    }

    public Collection<TemporaryBuilding> getBuildings() {
        return new HashSet<TemporaryBuilding>(this.tempBuildings);
    }

    public Collection<TemporaryObject> getAllObjects() {
        return new HashSet<TemporaryObject>(this.allObjects);
    }

    public Collection<Node> getAllNodes() {
        return new HashSet<Node>(this.nodes);
    }

    public Collection<Edge> getAllEdges() {
        return new HashSet<Edge>(this.edges);
    }

    public Set<TemporaryObject> getAttachedObjects(Edge e) {
        return new HashSet<TemporaryObject>((Collection)this.objectsAtEdge.get(e));
    }

    public Set<Edge> getAttachedEdges(Node n) {
        return new HashSet<Edge>((Collection)this.edgesAtNode.get(n));
    }

    public void setNearbyThreshold(double t) {
        this.threshold = t;
    }

    public double getNearbyThreshold() {
        return this.threshold;
    }

    public boolean isNear(Point2D point1, Point2D point2) {
        return this.isNear(point1.getX(), point1.getY(), point2.getX(), point2.getY());
    }

    public boolean isNear(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx >= -this.threshold && dx <= this.threshold && dy >= -this.threshold && dy <= this.threshold;
    }

    public Node getNode(Point2D p) {
        return this.getNode(p.getX(), p.getY());
    }

    public Node getNode(double x, double y) {
        for (Node next : this.nodes) {
            if (!this.isNear(x, y, next.getX(), next.getY())) continue;
            return next;
        }
        return this.createNode(x, y);
    }

    public Edge getEdge(Node from, Node to) {
        for (Edge next : this.edges) {
            if ((!next.getStart().equals(from) || !next.getEnd().equals(to)) && (!next.getStart().equals(to) || !next.getEnd().equals(from))) continue;
            return next;
        }
        return this.createEdge(from, to);
    }

    public DirectedEdge getDirectedEdge(Node from, Node to) {
        Edge e = this.getEdge(from, to);
        return new DirectedEdge(e, from);
    }

    public void replaceEdge(Edge edge, Collection<Edge> newEdges) {
        for (TemporaryObject next : this.getAttachedObjects(edge)) {
            next.replaceEdge(edge, newEdges);
            for (Edge nextEdge : newEdges) {
                this.objectsAtEdge.get(nextEdge).add(next);
            }
        }
        this.removeEdge(edge);
    }

    public List<Edge> splitEdge(Edge edge, Node ... splitPoints) {
        ArrayList<Edge> replacements = new ArrayList<Edge>();
        Edge current = edge;
        for (Node n : splitPoints) {
            if (n.equals(current.getStart()) || n.equals(current.getEnd())) continue;
            replacements.add(this.getEdge(current.getStart(), n));
            current = this.getEdge(n, current.getEnd());
        }
        if (!edge.equals(current)) {
            replacements.add(current);
        }
        if (!replacements.isEmpty()) {
            this.replaceEdge(edge, replacements);
        }
        return replacements;
    }

    private Node createNode(double x, double y) {
        Node result = new Node(this.nextID++, x, y);
        this.nodes.add(result);
        return result;
    }

    private Edge createEdge(Node from, Node to) {
        Edge result = new Edge(this.nextID++, from, to);
        this.edges.add(result);
        this.edgesAtNode.get(from).add(result);
        this.edgesAtNode.get(to).add(result);
        return result;
    }

    private void addObject(TemporaryObject object) {
        this.allObjects.add(object);
        for (DirectedEdge next : object.getEdges()) {
            this.objectsAtEdge.get(next.getEdge()).add(object);
        }
    }

    private void removeNode(Node n) {
        this.nodes.remove(n);
        this.edgesAtNode.remove(n);
    }

    private void removeEdge(Edge e) {
        this.edges.remove(e);
        this.edgesAtNode.get(e.getStart()).remove(e);
        this.edgesAtNode.get(e.getEnd()).remove(e);
        this.objectsAtEdge.remove(e);
    }

    private void removeObject(TemporaryObject object) {
        this.allObjects.remove(object);
        for (DirectedEdge next : object.getEdges()) {
            this.objectsAtEdge.get(next.getEdge()).remove(object);
        }
    }
}

