/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.Random;
import maps.gml.GMLCoordinates;
import maps.gml.GMLNode;
import maps.gml.editor.GMLEditor;
import maps.gml.editor.ProgressFunction;
import org.uncommons.maths.random.DiscreteUniformGenerator;
import org.uncommons.maths.random.MersenneTwisterRNG;

public class AddNoiseFunction
extends ProgressFunction {
    private static final int RANGE = 5;
    private static final double FACTOR = 0.001;
    private Random random = new MersenneTwisterRNG();

    public AddNoiseFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Add noise";
    }

    @Override
    protected String getTitle() {
        return "Adding noise";
    }

    @Override
    protected void executeImpl() {
        DiscreteUniformGenerator generator = new DiscreteUniformGenerator(-5, 5, this.random);
        this.setProgressLimit(this.editor.getMap().getNodes().size());
        for (GMLNode next : this.editor.getMap().getNodes()) {
            GMLCoordinates c = next.getCoordinates();
            c.setX(c.getX() + (double)generator.nextValue().intValue() * 0.001);
            c.setY(c.getY() + (double)generator.nextValue().intValue() * 0.001);
            this.bumpProgress();
        }
        this.editor.setChanged();
        this.editor.getViewer().repaint();
    }
}

