/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import maps.gml.GMLBuilding;
import maps.gml.GMLNode;
import maps.gml.editor.CreateShapeTool;
import maps.gml.editor.GMLEditor;

public class CreateBuildingTool
extends CreateShapeTool {
    public CreateBuildingTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Create building";
    }

    @Override
    protected UndoableEdit finished(List<GMLNode> nodes) {
        GMLBuilding building = this.editor.getMap().createBuildingFromNodes(nodes);
        return new CreateBuildingEdit(building);
    }

    private class CreateBuildingEdit
    extends AbstractUndoableEdit {
        private GMLBuilding building;

        public CreateBuildingEdit(GMLBuilding building) {
            this.building = building;
        }

        @Override
        public void undo() {
            super.undo();
            CreateBuildingTool.this.editor.getMap().removeBuilding(this.building);
            CreateBuildingTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            CreateBuildingTool.this.editor.getMap().addBuilding(this.building);
            CreateBuildingTool.this.editor.getViewer().repaint();
        }
    }
}

