/*
 * Decompiled with CFR 0.152.
 */
package maps.validate;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import maps.gml.GMLMap;
import maps.gml.GMLShape;
import maps.validate.JTSTools;
import maps.validate.MapValidator;
import maps.validate.ValidationError;
import maps.validate.ValidationException;

public class GMLShapeValidator
implements MapValidator<GMLMap> {
    @Override
    public Collection<ValidationError> validate(GMLMap map) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ArrayList<Geometry> polygons = new ArrayList<Geometry>();
        ArrayList<GMLShape> shapes = new ArrayList<GMLShape>(map.getAllShapes());
        for (GMLShape shape : shapes) {
            try {
                Geometry polygon = GMLShapeValidator.checkShape(shape);
                polygons.add(polygon);
            }
            catch (ValidationException e) {
                errors.add(e.getError());
                polygons.add(null);
            }
        }
        for (int i = 0; i < polygons.size(); ++i) {
            Geometry s1 = (Geometry)polygons.get(i);
            if (s1 == null) continue;
            for (int j = i + 1; j < polygons.size(); ++j) {
                Geometry s2 = (Geometry)polygons.get(j);
                if (s2 == null || !s1.intersects(s2) || s1.touches(s2)) continue;
                int s1Id = ((GMLShape)shapes.get(i)).getID();
                int s2Id = ((GMLShape)shapes.get(j)).getID();
                String message = " Shape overlaps with shape " + s2Id;
                errors.add(new ValidationError(s1Id, message));
            }
        }
        return errors;
    }

    private static Geometry checkShape(GMLShape shape) throws ValidationException {
        Geometry polygon = JTSTools.shapeToPolygon(shape);
        if (!polygon.isValid()) {
            throw new ValidationException(shape.getID(), "invalid shape");
        }
        if (!polygon.contains((Geometry)polygon.getCentroid())) {
            throw new ValidationException(shape.getID(), "Shape doesn't contain centroid.");
        }
        return polygon;
    }
}

