/*
 * Decompiled with CFR 0.152.
 */
package maps.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.linemerge.LineSequencer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import maps.gml.GMLBuilding;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLMap;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.validate.JTSTools;
import maps.validate.MapValidator;
import maps.validate.ValidationError;
import maps.validate.ValidationException;

public class GMLTraversabilityValidator
implements MapValidator<GMLMap> {
    private static final double MIN_ROAD_WIDTH = 1.0;
    private static final double SHAPE_PADDING = 0.01;

    @Override
    public Collection<ValidationError> validate(GMLMap map) {
        ValidationError error;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (GMLRoad gMLRoad : map.getRoads()) {
            error = this.checkTraversability(gMLRoad, 1.0);
            if (error == null) continue;
            errors.add(error);
        }
        for (GMLBuilding gMLBuilding : map.getBuildings()) {
            error = this.checkTraversability(gMLBuilding, 1.0);
            if (error == null) continue;
            errors.add(error);
        }
        return errors;
    }

    private ValidationError checkTraversability(GMLShape shape, double minWidth) {
        try {
            Geometry polygon = JTSTools.shapeToPolygon(shape);
            if (!polygon.isValid()) {
                return new ValidationError(shape.getID(), "invalid shape");
            }
            Geometry boundary = GMLTraversabilityValidator.impassableLines(shape);
            Geometry buffer = boundary.buffer(minWidth / 2.0);
            Geometry result = polygon.difference(buffer);
            result = result.buffer(0.01);
            Coordinate centroid = JTSTools.pointToCoordinate(shape.getCentroid());
            List<GMLDirectedEdge> edges = shape.getEdges();
            ArrayList entrances = new ArrayList();
            ArrayList<GMLDirectedEdge> entrance = new ArrayList<GMLDirectedEdge>();
            for (GMLDirectedEdge e : edges) {
                if (shape.hasNeighbour(e)) {
                    entrance.add(e);
                    LineString edge = JTSTools.edgeToLine(e);
                    Coordinate coordinate = edge.getCentroid().getCoordinate();
                    Coordinate[] coords = new Coordinate[]{centroid, coordinate};
                    LineString lineOfSight = JTSTools.getFactory().createLineString(coords);
                    if (!lineOfSight.intersects(boundary)) continue;
                    String message = "Edge " + e.getEdge().getID() + " has no line of sight to shape center.";
                    return new ValidationError(shape.getID(), message);
                }
                if (!entrance.isEmpty()) {
                    entrances.add(entrance);
                }
                entrance = new ArrayList();
            }
            if (!entrance.isEmpty()) {
                if (shape.hasNeighbour(edges.get(0)) && !entrances.isEmpty()) {
                    ((List)entrances.get(0)).addAll(entrance);
                } else {
                    entrances.add(entrance);
                }
            }
            GMLDirectedEdge firstEdge = null;
            int firstPolygon = -1;
            for (List list : entrances) {
                String message;
                GMLDirectedEdge e;
                int polyIndex = -1;
                Iterator i$ = list.iterator();
                while (i$.hasNext() && (polyIndex = GMLTraversabilityValidator.findPolygonPartOfEdge(e = (GMLDirectedEdge)i$.next(), result)) == -1) {
                }
                if (polyIndex == -1) {
                    message = "Edge is too narrow to pass through.";
                    return new ValidationError(((GMLDirectedEdge)list.get(0)).getEdge().getID(), message);
                }
                if (firstEdge == null) {
                    firstEdge = (GMLDirectedEdge)list.get(0);
                    firstPolygon = polyIndex;
                    continue;
                }
                if (firstPolygon == polyIndex || !(shape instanceof GMLRoad)) continue;
                message = "Can't reach edge " + firstEdge.getEdge().getID() + " from " + ((GMLDirectedEdge)list.get(0)).getEdge().getID();
                return new ValidationError(shape.getID(), message);
            }
            return null;
        }
        catch (ValidationException e) {
            return e.getError();
        }
    }

    private static int findPolygonPartOfEdge(GMLDirectedEdge edge, Geometry geom) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            if (!GMLTraversabilityValidator.edgePartOfPolygon(edge, geom.getGeometryN(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean edgePartOfPolygon(GMLDirectedEdge edge, Geometry polygon) {
        return polygon.intersects((Geometry)JTSTools.edgeToLine(edge));
    }

    private static Geometry impassableLines(GMLShape shape) {
        LineSequencer seq = new LineSequencer();
        for (GMLDirectedEdge e : shape.getEdges()) {
            if (shape.hasNeighbour(e)) continue;
            Coordinate[] coord = new Coordinate[]{JTSTools.nodeToCoordinate(e.getStartNode()), JTSTools.nodeToCoordinate(e.getEndNode())};
            seq.add((Geometry)JTSTools.getFactory().createLineString(coord));
        }
        return seq.getSequencedLineStrings();
    }
}

