/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.IOException;
import rescuecore2.components.Component;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.ComponentLauncher;
import rescuecore2.components.TCPComponentLauncher;
import rescuecore2.config.Config;
import rescuecore2.config.ConfigException;
import rescuecore2.connection.ConnectionException;
import rescuecore2.log.Logger;
import rescuecore2.misc.CommandLineOptions;
import rescuecore2.registry.EntityFactory;
import rescuecore2.registry.MessageFactory;
import rescuecore2.registry.PropertyFactory;
import rescuecore2.registry.Registry;
import rescuecore2.standard.entities.StandardEntityFactory;
import rescuecore2.standard.entities.StandardPropertyFactory;
import rescuecore2.standard.messages.StandardMessageFactory;
import sample.DummyAgent;
import sample.SampleAmbulanceTeam;
import sample.SampleCentre;
import sample.SampleFireBrigade;
import sample.SamplePoliceForce;

public final class LaunchSampleAgents {
    private static final String FIRE_BRIGADE_FLAG = "-fb";
    private static final String POLICE_FORCE_FLAG = "-pf";
    private static final String AMBULANCE_TEAM_FLAG = "-at";
    private static final String CIVILIAN_FLAG = "-cv";

    private LaunchSampleAgents() {
    }

    public static void main(String[] args) {
        Logger.setLogContext((String)"sample");
        try {
            Registry.SYSTEM_REGISTRY.registerEntityFactory((EntityFactory)StandardEntityFactory.INSTANCE);
            Registry.SYSTEM_REGISTRY.registerMessageFactory((MessageFactory)StandardMessageFactory.INSTANCE);
            Registry.SYSTEM_REGISTRY.registerPropertyFactory((PropertyFactory)StandardPropertyFactory.INSTANCE);
            Config config = new Config();
            args = CommandLineOptions.processArgs((String[])args, (Config)config);
            int port = config.getIntValue("kernel.port", 7000);
            String host = config.getValue("kernel.host", "localhost");
            int fb = -1;
            int pf = -1;
            int at = -1;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(FIRE_BRIGADE_FLAG)) {
                    fb = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals(POLICE_FORCE_FLAG)) {
                    pf = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals(AMBULANCE_TEAM_FLAG)) {
                    at = Integer.parseInt(args[++i]);
                    continue;
                }
                Logger.warn((String)("Unrecognised option: " + args[i]));
            }
            TCPComponentLauncher launcher = new TCPComponentLauncher(host, port, config);
            LaunchSampleAgents.connect((ComponentLauncher)launcher, fb, pf, at, config);
        }
        catch (IOException e) {
            Logger.error((String)"Error connecting agents", (Throwable)e);
        }
        catch (ConfigException e) {
            Logger.error((String)"Configuration error", (Throwable)e);
        }
        catch (ConnectionException e) {
            Logger.error((String)"Error connecting agents", (Throwable)e);
        }
        catch (InterruptedException e) {
            Logger.error((String)"Error connecting agents", (Throwable)e);
        }
    }

    private static void connect(ComponentLauncher launcher, int fb, int pf, int at, Config config) throws InterruptedException, ConnectionException {
        int i = 0;
        try {
            while (fb-- != 0) {
                Logger.info((String)("Connecting fire brigade " + i++ + "..."));
                launcher.connect((Component)new SampleFireBrigade());
                Logger.info((String)"success");
            }
        }
        catch (ComponentConnectionException e) {
            Logger.info((String)("failed: " + e.getMessage()));
        }
        try {
            while (pf-- != 0) {
                Logger.info((String)("Connecting police force " + i++ + "..."));
                launcher.connect((Component)new SamplePoliceForce());
                Logger.info((String)"success");
            }
        }
        catch (ComponentConnectionException e) {
            Logger.info((String)("failed: " + e.getMessage()));
        }
        try {
            while (at-- != 0) {
                Logger.info((String)("Connecting ambulance team " + i++ + "..."));
                launcher.connect((Component)new SampleAmbulanceTeam());
                Logger.info((String)"success");
            }
        }
        catch (ComponentConnectionException e) {
            Logger.info((String)("failed: " + e.getMessage()));
        }
        try {
            while (true) {
                Logger.info((String)("Connecting centre " + i++ + "..."));
                launcher.connect((Component)new SampleCentre());
                Logger.info((String)"success");
            }
        }
        catch (ComponentConnectionException e) {
            Logger.info((String)("failed: " + e.getMessage()));
            try {
                while (true) {
                    Logger.info((String)("Connecting dummy agent " + i++ + "..."));
                    launcher.connect((Component)new DummyAgent());
                    Logger.info((String)"success");
                }
            }
            catch (ComponentConnectionException e2) {
                Logger.info((String)("failed: " + e2.getMessage()));
                return;
            }
        }
    }
}

