/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kernel.AbstractKernelComponent;
import kernel.AgentProxy;
import kernel.CommandCollector;
import kernel.CommandFilter;
import kernel.CommunicationModel;
import kernel.EntityIDGenerator;
import kernel.KernelException;
import kernel.KernelListener;
import kernel.KernelState;
import kernel.Perception;
import kernel.SimulatorProxy;
import kernel.TerminationCondition;
import kernel.ViewerProxy;
import rescuecore2.Timestep;
import rescuecore2.config.Config;
import rescuecore2.log.CommandsRecord;
import rescuecore2.log.ConfigRecord;
import rescuecore2.log.EndLogRecord;
import rescuecore2.log.FileLogWriter;
import rescuecore2.log.InitialConditionsRecord;
import rescuecore2.log.LogException;
import rescuecore2.log.LogRecord;
import rescuecore2.log.LogWriter;
import rescuecore2.log.Logger;
import rescuecore2.log.PerceptionRecord;
import rescuecore2.log.StartLogRecord;
import rescuecore2.log.UpdatesRecord;
import rescuecore2.messages.Command;
import rescuecore2.score.ScoreFunction;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class Kernel {
    public static final String KERNEL_LOG_CONTEXT = "kernel";
    private Config config;
    private Perception perception;
    private CommunicationModel communicationModel;
    private WorldModel<? extends Entity> worldModel;
    private LogWriter log;
    private Set<KernelListener> listeners;
    private Collection<AgentProxy> agents;
    private Collection<SimulatorProxy> sims;
    private Collection<ViewerProxy> viewers;
    private int time;
    private Timestep previousTimestep;
    private EntityIDGenerator idGenerator;
    private CommandFilter commandFilter;
    private TerminationCondition termination;
    private ScoreFunction score;
    private CommandCollector commandCollector;
    private boolean isShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Kernel(Config config, Perception perception, CommunicationModel communicationModel, WorldModel<? extends Entity> worldModel, EntityIDGenerator idGenerator, CommandFilter commandFilter, TerminationCondition termination, ScoreFunction score, CommandCollector collector) throws KernelException {
        try {
            Logger.pushLogContext((String)KERNEL_LOG_CONTEXT);
            this.config = config;
            this.perception = perception;
            this.communicationModel = communicationModel;
            this.worldModel = worldModel;
            this.commandFilter = commandFilter;
            this.score = score;
            this.termination = termination;
            this.commandCollector = collector;
            this.idGenerator = idGenerator;
            this.listeners = new HashSet<KernelListener>();
            this.agents = new HashSet<AgentProxy>();
            this.sims = new HashSet<SimulatorProxy>();
            this.viewers = new HashSet<ViewerProxy>();
            this.time = 0;
            try {
                String logName = config.getValue("kernel.logname");
                Logger.info((String)("Logging to " + logName));
                File logFile = new File(logName);
                if (logFile.getParentFile().mkdirs()) {
                    Logger.info((String)("Created log directory: " + logFile.getParentFile().getAbsolutePath()));
                }
                if (logFile.createNewFile()) {
                    Logger.info((String)("Created log file: " + logFile.getAbsolutePath()));
                }
                this.log = new FileLogWriter(logFile);
                this.log.writeRecord((LogRecord)new StartLogRecord());
                this.log.writeRecord((LogRecord)new InitialConditionsRecord(worldModel));
                this.log.writeRecord((LogRecord)new ConfigRecord(config));
            }
            catch (IOException e) {
                throw new KernelException("Couldn't open log file for writing", e);
            }
            catch (LogException e) {
                throw new KernelException("Couldn't open log file for writing", e);
            }
            config.setValue("kernel.communication-model", communicationModel.getClass().getName());
            config.setValue("kernel.perception", perception.getClass().getName());
            perception.initialise(config, worldModel);
            communicationModel.initialise(config, worldModel);
            commandFilter.initialise(config);
            score.initialise(worldModel, config);
            termination.initialise(config);
            this.commandCollector.initialise(config);
            this.isShutdown = false;
            Logger.info((String)"Kernel initialised");
            Logger.info((String)("Perception module: " + perception));
            Logger.info((String)("Communication module: " + communicationModel));
            Logger.info((String)("Command filter: " + commandFilter));
            Logger.info((String)("Score function: " + score));
            Logger.info((String)("Termination condition: " + termination));
            Logger.info((String)("Command collector: " + collector));
        }
        finally {
            Logger.popLogContext();
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public KernelState getState() {
        return new KernelState(this.getTime(), this.getWorldModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgent(AgentProxy agent) {
        Kernel kernel = this;
        synchronized (kernel) {
            this.agents.add(agent);
        }
        this.fireAgentAdded(agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgent(AgentProxy agent) {
        Kernel kernel = this;
        synchronized (kernel) {
            this.agents.remove(agent);
        }
        this.fireAgentRemoved(agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AgentProxy> getAllAgents() {
        Kernel kernel = this;
        synchronized (kernel) {
            return Collections.unmodifiableCollection(this.agents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulator(SimulatorProxy sim) {
        Kernel kernel = this;
        synchronized (kernel) {
            this.sims.add(sim);
            sim.setEntityIDGenerator(this.idGenerator);
        }
        this.fireSimulatorAdded(sim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimulator(SimulatorProxy sim) {
        Kernel kernel = this;
        synchronized (kernel) {
            this.sims.remove(sim);
        }
        this.fireSimulatorRemoved(sim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SimulatorProxy> getAllSimulators() {
        Kernel kernel = this;
        synchronized (kernel) {
            return Collections.unmodifiableCollection(this.sims);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewer(ViewerProxy viewer) {
        Kernel kernel = this;
        synchronized (kernel) {
            this.viewers.add(viewer);
        }
        this.fireViewerAdded(viewer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewer(ViewerProxy viewer) {
        Kernel kernel = this;
        synchronized (kernel) {
            this.viewers.remove(viewer);
        }
        this.fireViewerRemoved(viewer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ViewerProxy> getAllViewers() {
        Kernel kernel = this;
        synchronized (kernel) {
            return Collections.unmodifiableCollection(this.viewers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKernelListener(KernelListener l) {
        Set<KernelListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKernelListener(KernelListener l) {
        Set<KernelListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTime() {
        Kernel kernel = this;
        synchronized (kernel) {
            return this.time;
        }
    }

    public WorldModel<? extends Entity> getWorldModel() {
        return this.worldModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTerminated() {
        Kernel kernel = this;
        synchronized (kernel) {
            return this.isShutdown || this.termination.shouldStop(this.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timestep() throws InterruptedException, KernelException, LogException {
        try {
            Logger.pushLogContext((String)KERNEL_LOG_CONTEXT);
            Kernel kernel = this;
            synchronized (kernel) {
                block9: {
                    if (this.time == 0) {
                        this.fireStarted();
                    }
                    if (!this.isShutdown) break block9;
                    return;
                }
                ++this.time;
                Timestep nextTimestep = new Timestep(this.time);
                Logger.info((String)("Timestep " + this.time));
                Logger.debug((String)"Sending agent updates");
                long start = System.currentTimeMillis();
                this.sendAgentUpdates(nextTimestep, this.previousTimestep == null ? new HashSet() : this.previousTimestep.getCommands());
                long perceptionTime = System.currentTimeMillis();
                Logger.debug((String)"Waiting for commands");
                Collection<Command> commands = this.waitForCommands(this.time);
                nextTimestep.setCommands(commands);
                this.log.writeRecord((LogRecord)new CommandsRecord(this.time, commands));
                long commandsTime = System.currentTimeMillis();
                Logger.debug((String)"Broadcasting commands");
                ChangeSet changes = this.sendCommandsToSimulators(this.time, commands);
                nextTimestep.setChangeSet(changes);
                this.log.writeRecord((LogRecord)new UpdatesRecord(this.time, changes));
                long updatesTime = System.currentTimeMillis();
                this.worldModel.merge(changes);
                long mergeTime = System.currentTimeMillis();
                Logger.debug((String)"Broadcasting updates");
                this.sendUpdatesToSimulators(this.time, changes);
                this.sendToViewers(nextTimestep);
                long broadcastTime = System.currentTimeMillis();
                Logger.debug((String)"Computing score");
                double s = this.score.score(this.worldModel, nextTimestep);
                long scoreTime = System.currentTimeMillis();
                nextTimestep.setScore(s);
                Logger.info((String)("Timestep " + this.time + " complete"));
                Logger.debug((String)("Score: " + s));
                Logger.debug((String)("Perception took        : " + (perceptionTime - start) + "ms"));
                Logger.debug((String)("Agent commands took    : " + (commandsTime - perceptionTime) + "ms"));
                Logger.debug((String)("Simulator updates took : " + (updatesTime - commandsTime) + "ms"));
                Logger.debug((String)("World model merge took : " + (mergeTime - updatesTime) + "ms"));
                Logger.debug((String)("Update broadcast took  : " + (broadcastTime - mergeTime) + "ms"));
                Logger.debug((String)("Score calculation took : " + (scoreTime - broadcastTime) + "ms"));
                Logger.debug((String)("Total time             : " + (scoreTime - start) + "ms"));
                this.fireTimestepCompleted(nextTimestep);
                this.previousTimestep = nextTimestep;
                Logger.debug((String)("Commands: " + commands));
                Logger.debug((String)("Timestep commands: " + this.previousTimestep.getCommands()));
            }
        }
        finally {
            Logger.popLogContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Kernel kernel = this;
        synchronized (kernel) {
            AgentProxy proxy;
            AbstractKernelComponent next;
            if (this.isShutdown) {
                return;
            }
            Logger.info((String)"Kernel is shutting down");
            ExecutorService service = Executors.newFixedThreadPool(this.agents.size() + this.sims.size() + this.viewers.size());
            ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>();
            Iterator<AbstractKernelComponent> i$ = this.agents.iterator();
            while (i$.hasNext()) {
                proxy = next = i$.next();
                callables.add(Executors.callable(new Runnable(){

                    @Override
                    public void run() {
                        proxy.shutdown();
                    }
                }));
            }
            i$ = this.sims.iterator();
            while (i$.hasNext()) {
                proxy = next = (SimulatorProxy)i$.next();
                callables.add(Executors.callable(new Runnable((SimulatorProxy)((Object)proxy)){
                    final /* synthetic */ SimulatorProxy val$proxy;
                    {
                        this.val$proxy = simulatorProxy;
                    }

                    @Override
                    public void run() {
                        this.val$proxy.shutdown();
                    }
                }));
            }
            i$ = this.viewers.iterator();
            while (i$.hasNext()) {
                proxy = next = (ViewerProxy)i$.next();
                callables.add(Executors.callable(new Runnable((ViewerProxy)((Object)proxy)){
                    final /* synthetic */ ViewerProxy val$proxy;
                    {
                        this.val$proxy = viewerProxy;
                    }

                    @Override
                    public void run() {
                        this.val$proxy.shutdown();
                    }
                }));
            }
            try {
                service.invokeAll(callables);
            }
            catch (InterruptedException e) {
                Logger.warn((String)"Interrupted during shutdown");
            }
            try {
                this.log.writeRecord((LogRecord)new EndLogRecord());
                this.log.close();
            }
            catch (LogException e) {
                Logger.error((String)"Error closing log", (Throwable)e);
            }
            Logger.info((String)"Kernel has shut down");
            this.isShutdown = true;
            this.fireShutdown();
        }
    }

    private void sendAgentUpdates(Timestep timestep, Collection<Command> commandsLastTimestep) throws InterruptedException, KernelException, LogException {
        this.perception.setTime(this.time);
        this.communicationModel.process(this.time, commandsLastTimestep);
        for (AgentProxy next : this.agents) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ChangeSet visible = this.perception.getVisibleEntities(next);
            Collection<Command> heard = this.communicationModel.getHearing(next.getControlledEntity());
            EntityID id = next.getControlledEntity().getID();
            timestep.registerPerception(id, visible, heard);
            this.log.writeRecord((LogRecord)new PerceptionRecord(this.time, id, visible, heard));
            next.sendPerceptionUpdate(this.time, visible, heard);
        }
    }

    private Collection<Command> waitForCommands(int timestep) throws InterruptedException {
        Collection<Command> commands = this.commandCollector.getAgentCommands(this.agents, timestep);
        Logger.debug((String)("Raw commands: " + commands));
        this.commandFilter.filter(commands, this.getState());
        Logger.debug((String)("Filtered commands: " + commands));
        return commands;
    }

    private ChangeSet sendCommandsToSimulators(int timestep, Collection<Command> commands) throws InterruptedException {
        for (SimulatorProxy next : this.sims) {
            next.sendAgentCommands(timestep, commands);
        }
        ChangeSet result = new ChangeSet();
        for (SimulatorProxy next : this.sims) {
            Logger.debug((String)("Fetching updates from " + next));
            result.merge(next.getUpdates(timestep));
        }
        return result;
    }

    private void sendUpdatesToSimulators(int timestep, ChangeSet updates) throws InterruptedException {
        for (SimulatorProxy next : this.sims) {
            next.sendUpdate(timestep, updates);
        }
    }

    private void sendToViewers(Timestep timestep) {
        for (ViewerProxy next : this.viewers) {
            next.sendTimestep(timestep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<KernelListener> getListeners() {
        HashSet<KernelListener> result;
        Set<KernelListener> set = this.listeners;
        synchronized (set) {
            result = new HashSet<KernelListener>(this.listeners);
        }
        return result;
    }

    private void fireStarted() {
        for (KernelListener next : this.getListeners()) {
            next.simulationStarted(this);
        }
    }

    private void fireShutdown() {
        for (KernelListener next : this.getListeners()) {
            next.simulationEnded(this);
        }
    }

    private void fireTimestepCompleted(Timestep timestep) {
        for (KernelListener next : this.getListeners()) {
            next.timestepCompleted(this, timestep);
        }
    }

    private void fireAgentAdded(AgentProxy agent) {
        for (KernelListener next : this.getListeners()) {
            next.agentAdded(this, agent);
        }
    }

    private void fireAgentRemoved(AgentProxy agent) {
        for (KernelListener next : this.getListeners()) {
            next.agentRemoved(this, agent);
        }
    }

    private void fireSimulatorAdded(SimulatorProxy sim) {
        for (KernelListener next : this.getListeners()) {
            next.simulatorAdded(this, sim);
        }
    }

    private void fireSimulatorRemoved(SimulatorProxy sim) {
        for (KernelListener next : this.getListeners()) {
            next.simulatorRemoved(this, sim);
        }
    }

    private void fireViewerAdded(ViewerProxy viewer) {
        for (KernelListener next : this.getListeners()) {
            next.viewerAdded(this, viewer);
        }
    }

    private void fireViewerRemoved(ViewerProxy viewer) {
        for (KernelListener next : this.getListeners()) {
            next.viewerRemoved(this, viewer);
        }
    }
}

