/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import kernel.KernelException;
import kernel.WorldModelCreator;
import rescuecore2.config.Config;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.connection.TCPConnection;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.GKConnectError;
import rescuecore2.messages.control.GKConnectOK;
import rescuecore2.messages.control.KGAcknowledge;
import rescuecore2.messages.control.KGConnect;
import rescuecore2.worldmodel.DefaultWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class RemoteGISWorldModelCreator
implements WorldModelCreator {
    private int nextID;

    @Override
    public WorldModel<? extends Entity> buildWorldModel(Config config) throws KernelException {
        TCPConnection conn;
        Logger.info((String)"Connecting to remote GIS...");
        DefaultWorldModel world = DefaultWorldModel.create();
        CountDownLatch latch = new CountDownLatch(1);
        int gisPort = config.getIntValue("gis.port", 7001);
        try {
            conn = new TCPConnection(gisPort);
            conn.addConnectionListener((ConnectionListener)new GISConnectionListener(latch, (DefaultWorldModel<Entity>)world));
            conn.startup();
            conn.sendMessage((Message)new KGConnect(1));
        }
        catch (IOException e) {
            throw new KernelException("Couldn't connect to GIS", e);
        }
        catch (ConnectionException e) {
            throw new KernelException("Couldn't connect to GIS", e);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new KernelException("Interrupted while connecting to GIS", e);
        }
        conn.shutdown();
        return world;
    }

    public String toString() {
        return "Remote GIS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityID generateID() {
        RemoteGISWorldModelCreator remoteGISWorldModelCreator = this;
        synchronized (remoteGISWorldModelCreator) {
            return new EntityID(this.nextID++);
        }
    }

    private class GISConnectionListener
    implements ConnectionListener {
        private CountDownLatch latch;
        private DefaultWorldModel<Entity> model;

        public GISConnectionListener(CountDownLatch latch, DefaultWorldModel<Entity> model) {
            this.latch = latch;
            this.model = model;
        }

        public void messageReceived(Connection c, Message m) {
            if (m instanceof GKConnectOK) {
                try {
                    this.model.removeAllEntities();
                    this.model.addEntities((Collection)((GKConnectOK)m).getEntities());
                    c.sendMessage((Message)new KGAcknowledge());
                    Logger.info((String)"GIS connected OK");
                    this.latch.countDown();
                    RemoteGISWorldModelCreator.this.nextID = 0;
                    for (Entity next : this.model) {
                        RemoteGISWorldModelCreator.this.nextID = Math.max(RemoteGISWorldModelCreator.this.nextID, next.getID().getValue());
                    }
                    ++RemoteGISWorldModelCreator.this.nextID;
                }
                catch (ConnectionException e) {
                    Logger.error((String)"RemoteGISWorldModelCreator.messageReceived", (Throwable)e);
                }
            }
            if (m instanceof GKConnectError) {
                Logger.error((String)("Error connecting to remote GIS: " + ((GKConnectError)m).getReason()));
                this.latch.countDown();
            }
        }
    }
}

