/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.simulator;

import firesimulator.simulator.Simulator;

public class WindShift {
    float speed;
    float direction;
    float directionDg;
    int[][] grid = new int[4][2];
    float[] weights = new float[4];

    public WindShift(float direction, float speed, int gridSize) {
        this.speed = speed % (float)gridSize;
        this.directionDg = direction;
        direction %= 360.0f;
        this.direction = direction = (float)((double)direction / 57.29577951308232);
        float v_y = -((float)Math.cos(direction) * speed);
        float v_x = -((float)Math.sin(direction) * speed);
        float[][] points = new float[4][2];
        points[0][0] = v_x;
        points[0][1] = v_y;
        points[1][0] = v_x + (float)gridSize;
        points[1][1] = v_y;
        points[2][0] = v_x + (float)gridSize;
        points[2][1] = v_y + (float)gridSize;
        points[3][0] = v_x;
        points[3][1] = v_y + (float)gridSize;
        float areaTotal = gridSize * gridSize;
        for (int c = 0; c < 4; ++c) {
            float weight;
            float tx = this.grid[c][0] * gridSize;
            float ty = this.grid[c][1] * gridSize;
            float sx = points[0][0];
            float sy = points[0][1];
            float dx = (float)gridSize - Math.abs(sx - tx);
            float dy = (float)gridSize - Math.abs(sy - ty);
            this.weights[c] = weight = dx * dy / areaTotal;
        }
    }

    private float getArea() {
        return 0.0f;
    }

    public float getDirection() {
        return this.directionDg;
    }

    public double[][] shift(double[][] source, Simulator sim) {
        if (this.speed == 0.0f) {
            return source;
        }
        double[][] result = new double[source.length][source[0].length];
        for (int x = 0; x < source.length; ++x) {
            for (int y = 0; y < source[0].length; ++y) {
                float temp = 0.0f;
                for (int c = 0; c < 4; ++c) {
                    temp = (float)((double)temp + sim.getTempAt(x - this.grid[c][0], y - this.grid[c][1]) * (double)this.weights[c]);
                }
                result[x][y] = temp;
            }
        }
        return result;
    }
}

