/*
 * Decompiled with CFR 0.152.
 */
package firesimulator.util;

import firesimulator.world.Wall;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    private static final String PREFIX = "resq-fire.";
    private static LinkedList Props = new LinkedList();
    private static final String CONFIG_TXT_PATH = ".";
    public static String VERSION = "06.08.2005";

    public void initialize() {
        Props.add(new Prop("resq-fire.store", "s", "Stores the intial data from the kernel in the given file.", "filename", true, null));
        Props.add(new Prop("resq-fire.virtual", "v", "Use the virtual kernel instead of the rescue kernel.\nRequires a .scn file.", "filename", true, null));
        Props.add(new Prop("resq-fire.host", "h", "The host to connect to. Default host is localhost.", "host", true, "localhost"));
        Props.add(new Prop("resq-fire.port", "p", "The port to connect to. Default port is 6000", "port", true, "6000"));
        Props.add(new Prop("resq-fire.setup", "stp", "Uses the given setup file", "filename", true, null));
        Props.add(new Prop("resq-fire.csetup", "cstp", "Uses the given config.txt file", "filename", true, null));
        Props.add(new Prop("resq-fire.ray_rate", "ray_rate", "Number of emitted rays per mm while sampling. Default rate is " + Wall.RAY_RATE, "rate", true, Wall.RAY_RATE + ""));
        Props.add(new Prop("resq-fire.help", "help", "Prints this text and exits", null, false, null));
        Props.add(new Prop("resq-fire.cell_size", "cell_size", null, null, true, null));
        Props.add(new Prop("resq-fire.max_ray_distance", "max_ray_distance", null, null, true, null));
        Props.add(new Prop("resq-fire.energy_loss", "energy_loss", null, null, true, null));
        Props.add(new Prop("resq-fire.air_to_air_flow", "air_to_air_flow", null, null, true, null));
        Props.add(new Prop("resq-fire.air_to_building_flow", "air_to_building_flow", null, null, true, null));
        Props.add(new Prop("resq-fire.air_cell_heat_capacity", "air_cell_heat_capacity", null, null, true, null));
        Props.add(new Prop("resq-fire.wooden_capacity", "wooden_capacity", null, null, true, null));
        Props.add(new Prop("resq-fire.wooden_energy", "wooden_energy", null, null, true, null));
        Props.add(new Prop("resq-fire.wooden_ignition", "wooden_ignition", null, null, true, null));
        Props.add(new Prop("resq-fire.wooden_burning", "wooden_burning", null, null, true, null));
        Props.add(new Prop("resq-fire.wooden_speed", "wooden_speed", null, null, true, null));
        Props.add(new Prop("resq-fire.steel_capacity", "steel_capacity", null, null, true, null));
        Props.add(new Prop("resq-fire.steel_energy", "steel_energy", null, null, true, null));
        Props.add(new Prop("resq-fire.steel_ignition", "steel_ignition", null, null, true, null));
        Props.add(new Prop("resq-fire.steel_burning", "steel_burning", null, null, true, null));
        Props.add(new Prop("resq-fire.steel_speed", "steel_speed", null, null, true, null));
        Props.add(new Prop("resq-fire.concrete_capacity", "concrete_capacity", null, null, true, null));
        Props.add(new Prop("resq-fire.concrete_energy", "concrete_energy", null, null, true, null));
        Props.add(new Prop("resq-fire.concrete_ignition", "concrete_ignition", null, null, true, null));
        Props.add(new Prop("resq-fire.concrete_burning", "concrete_burning", null, null, true, null));
        Props.add(new Prop("resq-fire.concrete_speed", "concrete_speed", null, null, true, null));
        Props.add(new Prop("resq-fire.max_extinguish_power_sum", "max_extinguish_power_sum", null, null, true, null));
        Props.add(new Prop("resq-fire.water_refill_rate", "water_refill_rate", null, null, true, null));
        Props.add(new Prop("resq-fire.water_capacity", "water_capacity", null, null, true, null));
        Props.add(new Prop("resq-fire.water_thermal_capacity", "water_thermal_capacity", null, null, true, null));
        Props.add(new Prop("resq-fire.water_distance", "water_distance", null, null, true, null));
        Props.add(new Prop("resq-fire.radiation_coefficient", "radiation_coefficient", null, null, true, null));
        Props.add(new Prop("resq-fire.wind_speed", "wind_speed", null, null, true, null));
        Props.add(new Prop("resq-fire.wind_direction", "wind_direction", null, null, true, null));
        Props.add(new Prop("resq-fire.wind_random", "wind_random", null, null, true, null));
        Props.add(new Prop("resq-fire.randomseed", "randomseed", null, null, true, null));
        Props.add(new Prop("resq-fire.refuge_inflammable", "refuge_inflammable", null, null, true, null));
        Props.add(new Prop("resq-fire.fire_station_inflammable", "firestation_inflammable", null, null, true, null));
        Props.add(new Prop("resq-fire.police_office_inflammable", "policeoffice_inflammable", null, null, true, null));
        Props.add(new Prop("resq-fire.ambulance_center_inflammable", "ambulancecenter_inflammable", null, null, true, null));
        Props.add(new Prop("resq-fire.gamma", "gamma", null, null, true, null));
        Props.add(new Prop("resq-fire.rays.dir", "rays", null, null, true, "rays"));
        Props.add(new Prop("resq-fire.burn-rate-average", "burn-rate-average", null, null, true, "0.2"));
        Props.add(new Prop("resq-fire.burn-rate-variance", "burn-rate-variance", null, null, true, "0"));
    }

    public void parse(String cmdLine) {
        StringTokenizer st = new StringTokenizer(cmdLine, "-");
        try {
            while (st.hasMoreTokens()) {
                Prop p;
                String cmd;
                String tok = st.nextToken();
                int index = tok.indexOf(" ");
                if (index == -1) {
                    cmd = tok.trim();
                    if (cmd.length() == 0) continue;
                    p = Configuration.propForCmd(cmd);
                    p.active = true;
                    continue;
                }
                cmd = tok.substring(0, index).trim();
                if (cmd.length() == 0) continue;
                p = Configuration.propForCmd(cmd);
                p.active = true;
                p.value = tok.substring(index).trim();
            }
        }
        catch (Exception e) {
            this.printHelpAndExit();
        }
        if (Configuration.isActive("help")) {
            this.printHelpAndExit();
        }
    }

    private void printHelpAndExit() {
        System.out.println("ResQ Firesimulator");
        System.out.println(VERSION);
        System.out.println("author: Timo N\ufffdssle\nemail: nuessle@informatik.uni-freiburg.de\n");
        System.out.println("java Main [-<option> <value>]*");
        Iterator i = Props.iterator();
        while (i.hasNext()) {
            System.out.print(((Prop)i.next()).getDescription());
        }
        System.exit(0);
    }

    private static Prop propForCmd(String cmd) {
        for (Prop p : Props) {
            if (p.command.compareTo(cmd) != 0) continue;
            return p;
        }
        return null;
    }

    public static boolean isActive(String name) {
        for (Prop p : Props) {
            if (p.name.compareTo(name) != 0) continue;
            return p.isActive();
        }
        return false;
    }

    public static String getValue(String name) {
        for (Prop p : Props) {
            if (p.name.compareTo(name) != 0) continue;
            return p.getValue();
        }
        return null;
    }

    public void parse(String[] args) {
        if (args.length < 1) {
            return;
        }
        String s = "";
        for (int i = 0; i < args.length; ++i) {
            s = s + " " + args[i];
        }
        this.parse(s);
    }

    public static boolean loadSetup(String fileName) {
        try {
            FileInputStream fis = new FileInputStream(new File(fileName));
            Properties prop = new Properties();
            prop.load(fis);
            fis.close();
            for (Prop p : Props) {
                String val = prop.getProperty(p.command);
                if (val == null) continue;
                p.value = val;
                p.active = true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void loadConfigTXT(String filename) {
        String fname = CONFIG_TXT_PATH + File.separator + "config.txt";
        if (filename != null) {
            fname = filename;
        }
        LOG.info((Object)("loading values from \"" + fname + "\""));
        try {
            String value;
            String line;
            Pattern comment = Pattern.compile("([^#]*)(#(.*))*", 32);
            Pattern keyValue = Pattern.compile("([^:]*):(.*)", 32);
            BufferedReader br = new BufferedReader(new FileReader(fname));
            Hashtable<String, String> lines = new Hashtable<String, String>();
            while ((line = br.readLine()) != null) {
                Matcher gm;
                Matcher m = comment.matcher(line = line.trim());
                if (!m.matches() || !(gm = keyValue.matcher(m.group(1))).matches() || gm.groupCount() != 2) continue;
                String key = gm.group(1).trim();
                value = gm.group(2).trim();
                lines.put(key, value);
            }
            for (Prop p : Props) {
                String name = p.name;
                value = (String)lines.get(name);
                if (value == null) continue;
                p.active = true;
                p.value = value;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("unable to load \"" + fname + "\""), (Throwable)e);
        }
    }

    public static void setProperty(String name, String value, boolean state) {
        for (Prop p : Props) {
            if (p.name.compareTo(name) != 0) continue;
            p.value = value;
            p.active = state;
            break;
        }
    }

    public static List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Prop next : Props) {
            result.add(next.name);
        }
        return result;
    }

    public static void dump() {
        for (Prop p : Props) {
            LOG.debug((Object)(p.command + "=" + p.value + "[" + p.active + "]"));
        }
    }

    public static void storeHiddenProps(String fileName) throws IOException {
        File f;
        Properties prop = new Properties();
        for (Prop p : Props) {
            if (p.description != null) continue;
            if (p.value == null) {
                LOG.debug((Object)p.command);
            }
            prop.put(p.command, p.value);
        }
        if (!fileName.endsWith(".stp")) {
            fileName = fileName + ".stp";
        }
        if ((f = new File(fileName)).exists()) {
            f.delete();
        }
        f.createNewFile();
        FileOutputStream fos = new FileOutputStream(f);
        prop.store(fos, "fire simulator setup file");
        fos.close();
    }

    public class Prop {
        private String name;
        private String command;
        private String description;
        private String paramName;
        private boolean paramReq;
        private String value;
        boolean active;

        public Prop(String name, String command, String description, String paramName, boolean paramReq, String def) {
            this.name = name;
            this.command = command;
            this.description = description;
            this.paramName = paramName;
            this.paramReq = paramReq;
            if (def != null) {
                this.value = def;
                this.active = true;
            } else {
                this.value = null;
                this.active = false;
            }
        }

        public String getValue() {
            return this.value;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean validate() {
            return !this.paramReq || this.value != null && this.value.length() != 0;
        }

        public String getDescription() {
            if (this.description == null) {
                return "";
            }
            return "\n" + this.name + ":  " + this.command + " " + (this.paramName != null ? (!this.paramReq ? "[" : "") + "<" + this.paramName + ">" + (!this.paramReq ? "]" : "") : "") + "\n" + this.description + "\n";
        }
    }
}

