/*
 * Decompiled with CFR 0.152.
 */
package maps.gml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import maps.CoordinateConversion;
import maps.Map;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.GMLSpace;
import maps.gml.GMLTools;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;

public class GMLMap
implements Map {
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private boolean boundsKnown = false;
    private java.util.Map<Integer, GMLNode> nodes = new HashMap<Integer, GMLNode>();
    private java.util.Map<Integer, GMLEdge> edges = new HashMap<Integer, GMLEdge>();
    private java.util.Map<Integer, GMLBuilding> buildings = new HashMap<Integer, GMLBuilding>();
    private java.util.Map<Integer, GMLRoad> roads = new HashMap<Integer, GMLRoad>();
    private java.util.Map<Integer, GMLSpace> spaces = new HashMap<Integer, GMLSpace>();
    private Set<GMLShape> allShapes = new HashSet<GMLShape>();
    private Set<GMLObject> allObjects = new HashSet<GMLObject>();
    private java.util.Map<GMLNode, Collection<GMLEdge>> attachedEdges = new LazyMap<GMLNode, Collection<GMLEdge>>(){

        public Collection<GMLEdge> createValue() {
            return new HashSet<GMLEdge>();
        }
    };
    private java.util.Map<GMLEdge, Collection<GMLShape>> attachedShapes = new LazyMap<GMLEdge, Collection<GMLShape>>(){

        public Collection<GMLShape> createValue() {
            return new HashSet<GMLShape>();
        }
    };
    private int nextID = 0;

    public GMLNode createNode(double x, double y) {
        GMLNode n = new GMLNode(this.nextID++, x, y);
        this.addNode(n);
        return n;
    }

    public GMLNode createNode(GMLCoordinates coords) {
        GMLNode n = new GMLNode(this.nextID++, coords);
        this.addNode(n);
        return n;
    }

    public List<GMLNode> createNodes(List<GMLCoordinates> coords) {
        ArrayList<GMLNode> result = new ArrayList<GMLNode>(coords.size());
        for (GMLCoordinates c : coords) {
            GMLNode n = new GMLNode(this.nextID++, c);
            this.addNode(n);
            result.add(n);
        }
        return result;
    }

    public List<GMLNode> createNodesFromPoints(List<Point2D> coords) {
        ArrayList<GMLNode> result = new ArrayList<GMLNode>(coords.size());
        for (Point2D p : coords) {
            GMLNode n = new GMLNode(this.nextID++, p.getX(), p.getY());
            this.addNode(n);
            result.add(n);
        }
        return result;
    }

    public GMLEdge createEdge(GMLNode first, GMLNode second) {
        GMLEdge e = new GMLEdge(this.nextID++, first, second, false);
        this.addEdge(e);
        return e;
    }

    public GMLBuilding createBuildingFromNodes(List<GMLNode> apexes) {
        return this.createBuilding(this.apexesToEdges(apexes));
    }

    public GMLBuilding createBuilding(List<GMLDirectedEdge> bEdges) {
        GMLBuilding b = new GMLBuilding(this.nextID++, bEdges);
        this.addBuilding(b);
        return b;
    }

    public GMLRoad createRoadFromNodes(List<GMLNode> apexes) {
        return this.createRoad(this.apexesToEdges(apexes));
    }

    public GMLRoad createRoad(List<GMLDirectedEdge> rEdges) {
        GMLRoad r = new GMLRoad(this.nextID++, rEdges);
        this.addRoad(r);
        return r;
    }

    public GMLSpace createSpaceFromNodes(List<GMLNode> apexes) {
        return this.createSpace(this.apexesToEdges(apexes));
    }

    public GMLSpace createSpace(List<GMLDirectedEdge> sEdges) {
        GMLSpace s = new GMLSpace(this.nextID++, sEdges);
        this.addSpace(s);
        return s;
    }

    public void addNode(GMLNode n) {
        if (this.nodes.containsKey(n.getID())) {
            return;
        }
        this.addObject(n);
        this.nodes.put(n.getID(), n);
        this.boundsKnown = false;
    }

    public void addEdge(GMLEdge e) {
        if (this.edges.containsKey(e.getID())) {
            return;
        }
        this.addObject(e);
        this.edges.put(e.getID(), e);
        this.addNode(e.getStart());
        this.addNode(e.getEnd());
        this.attachedEdges.get(e.getStart()).add(e);
        this.attachedEdges.get(e.getEnd()).add(e);
    }

    public void addBuilding(GMLBuilding b) {
        if (this.buildings.containsKey(b.getID())) {
            return;
        }
        this.addShape(b);
        this.buildings.put(b.getID(), b);
    }

    public void addRoad(GMLRoad r) {
        if (this.roads.containsKey(r.getID())) {
            return;
        }
        this.addShape(r);
        this.roads.put(r.getID(), r);
    }

    public void addSpace(GMLSpace s) {
        if (this.spaces.containsKey(s.getID())) {
            return;
        }
        this.addShape(s);
        this.spaces.put(s.getID(), s);
    }

    public void add(GMLObject object) {
        if (object instanceof GMLNode) {
            this.addNode((GMLNode)object);
        } else if (object instanceof GMLEdge) {
            this.addEdge((GMLEdge)object);
        } else if (object instanceof GMLRoad) {
            this.addRoad((GMLRoad)object);
        } else if (object instanceof GMLBuilding) {
            this.addBuilding((GMLBuilding)object);
        } else if (object instanceof GMLSpace) {
            this.addSpace((GMLSpace)object);
        } else {
            throw new IllegalArgumentException("Don't know how to add " + object + " (class: " + object.getClass().getName() + ")");
        }
    }

    public void add(Collection<? extends GMLObject> objects) {
        for (GMLObject gMLObject : objects) {
            this.add(gMLObject);
        }
    }

    public void add(GMLObject ... objects) {
        for (GMLObject next : objects) {
            this.add(next);
        }
    }

    public Collection<GMLObject> removeNode(GMLNode n) {
        HashSet<GMLObject> result = new HashSet<GMLObject>();
        if (this.nodes.containsKey(n.getID())) {
            this.removeObject(n);
            this.nodes.remove(n.getID());
            HashSet<GMLEdge> attached = new HashSet<GMLEdge>(this.getAttachedEdges(n));
            for (GMLEdge next : attached) {
                result.add(next);
                result.addAll(this.removeEdge(next));
            }
            this.boundsKnown = false;
        }
        return result;
    }

    public Collection<GMLObject> removeEdge(GMLEdge e) {
        HashSet<GMLObject> result = new HashSet<GMLObject>();
        if (this.edges.containsKey(e.getID())) {
            this.removeObject(e);
            this.edges.remove(e.getID());
            HashSet<GMLShape> attached = new HashSet<GMLShape>(this.getAttachedShapes(e));
            for (GMLShape next : attached) {
                result.add(next);
                this.remove((GMLObject)next);
            }
            this.attachedEdges.get(e.getStart()).remove(e);
            this.attachedEdges.get(e.getEnd()).remove(e);
        }
        return result;
    }

    public void removeBuilding(GMLBuilding b) {
        if (this.buildings.containsKey(b.getID())) {
            this.removeShape(b);
            this.buildings.remove(b.getID());
        }
    }

    public void removeRoad(GMLRoad r) {
        if (this.roads.containsKey(r.getID())) {
            this.removeShape(r);
            this.roads.remove(r.getID());
        }
    }

    public void removeSpace(GMLSpace s) {
        if (this.spaces.containsKey(s.getID())) {
            this.removeShape(s);
            this.spaces.remove(s.getID());
        }
    }

    public void remove(GMLObject object) {
        if (object instanceof GMLNode) {
            this.removeNode((GMLNode)object);
        } else if (object instanceof GMLEdge) {
            this.removeEdge((GMLEdge)object);
        } else if (object instanceof GMLRoad) {
            this.removeRoad((GMLRoad)object);
        } else if (object instanceof GMLBuilding) {
            this.removeBuilding((GMLBuilding)object);
        } else if (object instanceof GMLSpace) {
            this.removeSpace((GMLSpace)object);
        } else {
            throw new IllegalArgumentException("Don't know how to remove " + object + " (class: " + object.getClass().getName() + ")");
        }
    }

    public void remove(Collection<? extends GMLObject> objects) {
        for (GMLObject gMLObject : objects) {
            this.remove(gMLObject);
        }
    }

    public void remove(GMLObject ... objects) {
        for (GMLObject next : objects) {
            this.remove(next);
        }
    }

    public void removeAllNodes() {
        this.nodes.clear();
        this.edges.clear();
        this.roads.clear();
        this.buildings.clear();
        this.spaces.clear();
        this.allShapes.clear();
        this.allObjects.clear();
        this.attachedEdges.clear();
        this.attachedShapes.clear();
        this.boundsKnown = false;
    }

    public void removeAllEdges() {
        this.edges.clear();
        this.roads.clear();
        this.buildings.clear();
        this.spaces.clear();
        this.allShapes.clear();
        this.allObjects.retainAll(this.nodes.values());
        this.attachedEdges.clear();
        this.attachedShapes.clear();
    }

    public void removeAllBuildings() {
        for (Map.Entry<GMLEdge, Collection<GMLShape>> entry : this.attachedShapes.entrySet()) {
            entry.getValue().removeAll(this.buildings.values());
        }
        this.allShapes.removeAll(this.buildings.values());
        this.allObjects.removeAll(this.buildings.values());
        this.buildings.clear();
    }

    public void removeAllRoads() {
        for (Map.Entry<GMLEdge, Collection<GMLShape>> entry : this.attachedShapes.entrySet()) {
            entry.getValue().removeAll(this.buildings.values());
        }
        this.allShapes.removeAll(this.roads.values());
        this.allObjects.removeAll(this.roads.values());
        this.roads.clear();
    }

    public void removeAllSpaces() {
        for (Map.Entry<GMLEdge, Collection<GMLShape>> entry : this.attachedShapes.entrySet()) {
            entry.getValue().removeAll(this.buildings.values());
        }
        this.allShapes.removeAll(this.spaces.values());
        this.allObjects.removeAll(this.spaces.values());
        this.spaces.clear();
    }

    public GMLNode getNode(int id) {
        return this.nodes.get(id);
    }

    public GMLEdge getEdge(int id) {
        return this.edges.get(id);
    }

    public GMLBuilding getBuilding(int id) {
        return this.buildings.get(id);
    }

    public GMLRoad getRoad(int id) {
        return this.roads.get(id);
    }

    public GMLSpace getSpace(int id) {
        return this.spaces.get(id);
    }

    public GMLShape getShape(int id) {
        GMLBuilding b = this.getBuilding(id);
        if (b != null) {
            return b;
        }
        GMLRoad r = this.getRoad(id);
        if (r != null) {
            return r;
        }
        GMLSpace s = this.getSpace(id);
        if (s != null) {
            return s;
        }
        return null;
    }

    public GMLObject getObject(int id) {
        GMLNode n = this.getNode(id);
        if (n != null) {
            return n;
        }
        GMLEdge e = this.getEdge(id);
        if (e != null) {
            return e;
        }
        GMLBuilding b = this.getBuilding(id);
        if (b != null) {
            return b;
        }
        GMLRoad r = this.getRoad(id);
        if (r != null) {
            return r;
        }
        GMLSpace s = this.getSpace(id);
        if (s != null) {
            return s;
        }
        return null;
    }

    public Set<GMLNode> getNodes() {
        return new HashSet<GMLNode>(this.nodes.values());
    }

    public Set<GMLEdge> getEdges() {
        return new HashSet<GMLEdge>(this.edges.values());
    }

    public Set<GMLBuilding> getBuildings() {
        return new HashSet<GMLBuilding>(this.buildings.values());
    }

    public Set<GMLRoad> getRoads() {
        return new HashSet<GMLRoad>(this.roads.values());
    }

    public Set<GMLSpace> getSpaces() {
        return new HashSet<GMLSpace>(this.spaces.values());
    }

    public Set<GMLShape> getAllShapes() {
        return Collections.unmodifiableSet(this.allShapes);
    }

    public Set<GMLObject> getAllObjects() {
        return Collections.unmodifiableSet(this.allObjects);
    }

    public double getMinX() {
        this.calculateBounds();
        return this.minX;
    }

    public double getMaxX() {
        this.calculateBounds();
        return this.maxX;
    }

    public double getMinY() {
        this.calculateBounds();
        return this.minY;
    }

    public double getMaxY() {
        this.calculateBounds();
        return this.maxY;
    }

    public boolean hasSize() {
        return this.nodes.size() > 1;
    }

    public void convertCoordinates(CoordinateConversion conversion) {
        for (GMLNode next : this.nodes.values()) {
            next.convert(conversion);
        }
        this.boundsKnown = false;
    }

    public GMLEdge ensureEdge(GMLNode first, GMLNode second) {
        for (GMLEdge next : this.edges.values()) {
            if ((!next.getStart().equals(first) || !next.getEnd().equals(second)) && (!next.getStart().equals(second) || !next.getEnd().equals(first))) continue;
            return next;
        }
        return this.createEdge(first, second);
    }

    public List<GMLDirectedEdge> apexesToEdges(GMLNode ... apexes) {
        return this.apexesToEdges(Arrays.asList(apexes));
    }

    public List<GMLDirectedEdge> apexesToEdges(List<GMLNode> apexes) {
        GMLNode first;
        ArrayList<GMLDirectedEdge> edgeList = new ArrayList<GMLDirectedEdge>(apexes.size());
        Iterator<GMLNode> it = apexes.iterator();
        GMLNode previous = first = it.next();
        while (it.hasNext()) {
            GMLNode next = it.next();
            GMLEdge edge = this.ensureEdge(previous, next);
            edgeList.add(new GMLDirectedEdge(edge, previous));
            previous = next;
        }
        GMLEdge edge = this.ensureEdge(previous, first);
        edgeList.add(new GMLDirectedEdge(edge, previous));
        return edgeList;
    }

    public Collection<GMLNode> getNodesInRegion(double xMin, double yMin, double xMax, double yMax) {
        ArrayList<GMLNode> result = new ArrayList<GMLNode>();
        for (GMLNode next : this.nodes.values()) {
            double x = next.getX();
            double y = next.getY();
            if (!(x >= xMin) || !(x <= xMax) || !(y >= yMin) || !(y <= yMax)) continue;
            result.add(next);
        }
        return result;
    }

    public GMLNode findNearestNode(double x, double y) {
        GMLNode best = null;
        double bestDistance = Double.NaN;
        for (GMLNode next : this.nodes.values()) {
            double dx = x - next.getX();
            double dy = y - next.getY();
            double d = dx * dx + dy * dy;
            if (best != null && !(d < bestDistance)) continue;
            best = next;
            bestDistance = d;
        }
        return best;
    }

    public GMLEdge findNearestEdge(double x, double y) {
        return this.findNearestEdge(x, y, this.edges.values());
    }

    public GMLEdge findNearestEdge(double x, double y, Collection<? extends GMLEdge> possible) {
        GMLEdge best = null;
        double bestDistance = Double.NaN;
        Point2D test = new Point2D(x, y);
        for (GMLEdge gMLEdge : possible) {
            Line2D line = GMLTools.toLine(gMLEdge);
            Point2D closest = GeometryTools2D.getClosestPointOnSegment((Line2D)line, (Point2D)test);
            double d = GeometryTools2D.getDistance((Point2D)test, (Point2D)closest);
            if (best != null && !(d < bestDistance)) continue;
            best = gMLEdge;
            bestDistance = d;
        }
        return best;
    }

    public GMLShape findShapeUnder(double x, double y) {
        for (GMLShape next : this.allShapes) {
            if (!GMLTools.coordsToShape(next.getUnderlyingCoordinates()).contains(x, y)) continue;
            return next;
        }
        return null;
    }

    public Collection<GMLEdge> getAttachedEdges(GMLNode node) {
        return Collections.unmodifiableCollection(this.attachedEdges.get(node));
    }

    public Collection<GMLShape> getAttachedShapes(GMLEdge edge) {
        return Collections.unmodifiableCollection(this.attachedShapes.get(edge));
    }

    public GMLEdge mergeEdges(GMLEdge edge1, GMLEdge edge2) {
        GMLNode commonNode = edge1.getStart();
        if (!commonNode.equals(edge2.getStart()) && !commonNode.equals(edge2.getEnd())) {
            commonNode = edge1.getEnd();
        }
        if (!commonNode.equals(edge2.getStart()) && !commonNode.equals(edge2.getEnd())) {
            throw new IllegalArgumentException("Edges " + edge1 + " and " + edge2 + " do not have a common node");
        }
        GMLNode start = commonNode.equals(edge1.getStart()) ? edge1.getEnd() : edge1.getStart();
        GMLNode end = commonNode.equals(edge2.getStart()) ? edge2.getEnd() : edge2.getStart();
        return this.ensureEdge(start, end);
    }

    public void replaceNode(GMLNode oldNode, GMLNode newNode) {
        ArrayList<GMLEdge> attached = new ArrayList<GMLEdge>(this.getAttachedEdges(oldNode));
        for (GMLEdge next : attached) {
            if (next.getStart().equals(oldNode)) {
                next.setStart(newNode);
                this.attachedEdges.get(oldNode).remove(next);
                this.attachedEdges.get(newNode).add(next);
            }
            if (!next.getEnd().equals(oldNode)) continue;
            next.setEnd(newNode);
            this.attachedEdges.get(oldNode).remove(next);
            this.attachedEdges.get(newNode).add(next);
        }
    }

    public void replaceEdge(GMLEdge oldEdge, GMLEdge newEdge) {
        if (oldEdge.getStart() != newEdge.getStart() && oldEdge.getStart() != newEdge.getEnd() || oldEdge.getEnd() != newEdge.getStart() && oldEdge.getEnd() != newEdge.getEnd()) {
            throw new IllegalArgumentException("oldEdge and newEdge do not share start and end nodes");
        }
        HashSet<GMLShape> attached = new HashSet<GMLShape>(this.getAttachedShapes(oldEdge));
        for (GMLShape next : attached) {
            for (GMLDirectedEdge dEdge : next.getEdges()) {
                if (dEdge.getEdge() != oldEdge) continue;
                boolean forward = oldEdge.getStart() == newEdge.getStart() ? dEdge.isForward() : !dEdge.isForward();
                GMLDirectedEdge replacement = new GMLDirectedEdge(newEdge, forward);
                next.replaceEdge(dEdge, replacement);
                this.attachedShapes.get(oldEdge).remove(next);
                this.attachedShapes.get(newEdge).add(next);
            }
        }
    }

    public Collection<GMLEdge> splitEdge(GMLEdge edge, GMLNode node) {
        ArrayList<GMLEdge> result = new ArrayList<GMLEdge>(2);
        GMLEdge first = this.ensureEdge(edge.getStart(), node);
        GMLEdge second = this.ensureEdge(node, edge.getEnd());
        result.add(first);
        result.add(second);
        HashSet<GMLShape> attached = new HashSet<GMLShape>(this.getAttachedShapes(edge));
        for (GMLShape shape : attached) {
            for (GMLDirectedEdge dEdge : shape.getEdges()) {
                GMLDirectedEdge d2;
                GMLDirectedEdge d1;
                if (dEdge.getEdge() != edge) continue;
                if (dEdge.isForward()) {
                    d1 = new GMLDirectedEdge(first, true);
                    d2 = new GMLDirectedEdge(second, true);
                } else {
                    d1 = new GMLDirectedEdge(second, false);
                    d2 = new GMLDirectedEdge(first, false);
                }
                shape.replaceEdge(dEdge, d1, d2);
                this.attachedShapes.get(edge).remove(shape);
                this.attachedShapes.get(first).add(shape);
                this.attachedShapes.get(second).add(shape);
            }
        }
        return result;
    }

    private void addShape(GMLShape shape) {
        this.addObject(shape);
        this.allShapes.add(shape);
        for (GMLDirectedEdge edge : shape.getEdges()) {
            this.addEdge(edge.getEdge());
            this.attachedShapes.get(edge.getEdge()).add(shape);
        }
    }

    private void addObject(GMLObject object) {
        this.allObjects.add(object);
        this.nextID = Math.max(this.nextID, object.getID() + 1);
    }

    private void removeShape(GMLShape shape) {
        this.removeObject(shape);
        this.allShapes.remove(shape);
        for (GMLDirectedEdge edge : shape.getEdges()) {
            this.attachedShapes.get(edge.getEdge()).remove(shape);
        }
    }

    private void removeObject(GMLObject object) {
        this.allObjects.remove(object);
    }

    private void calculateBounds() {
        if (this.boundsKnown) {
            return;
        }
        this.minX = Double.POSITIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        for (GMLNode n : this.nodes.values()) {
            GMLCoordinates c = n.getCoordinates();
            this.minX = Math.min(this.minX, c.getX());
            this.maxX = Math.max(this.maxX, c.getX());
            this.minY = Math.min(this.minY, c.getY());
            this.maxY = Math.max(this.maxY, c.getY());
        }
        this.boundsKnown = true;
    }
}

