/*
 * Decompiled with CFR 0.152.
 */
package maps.gml;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import maps.gml.GMLCoordinates;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLEdge;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLShape;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;

public final class GMLTools {
    private GMLTools() {
    }

    public static String getCoordinatesString(List<GMLCoordinates> coords) {
        StringBuilder result = new StringBuilder();
        Iterator<GMLCoordinates> it = coords.iterator();
        while (it.hasNext()) {
            GMLCoordinates next = it.next();
            result.append(String.valueOf(next.getX()));
            result.append(",");
            result.append(String.valueOf(next.getY()));
            if (!it.hasNext()) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public static List<GMLCoordinates> getCoordinatesList(String coords) {
        ArrayList<GMLCoordinates> result = new ArrayList<GMLCoordinates>();
        StringTokenizer tokens = new StringTokenizer(coords, " ");
        while (tokens.hasMoreTokens()) {
            result.add(new GMLCoordinates(tokens.nextToken()));
        }
        return result;
    }

    public static List<Point2D> coordinatesAsPoints(List<GMLCoordinates> coords) {
        ArrayList<Point2D> result = new ArrayList<Point2D>(coords.size());
        for (GMLCoordinates next : coords) {
            result.add(new Point2D(next.getX(), next.getY()));
        }
        return result;
    }

    public static Rectangle2D getBounds(List<GMLCoordinates> coords) {
        if (coords.isEmpty()) {
            return null;
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (GMLCoordinates next : coords) {
            minX = Math.min(minX, next.getX());
            minY = Math.min(minY, next.getY());
            maxX = Math.max(maxX, next.getX());
            maxY = Math.max(maxY, next.getY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public static Rectangle2D getObjectBounds(List<? extends GMLObject> objects) {
        Rectangle2D result = null;
        for (GMLObject gMLObject : objects) {
            result = GMLTools.expand(result, gMLObject);
        }
        return result;
    }

    public static Shape coordsToShape(List<GMLCoordinates> coords) {
        Path2D.Double path = new Path2D.Double();
        Iterator<GMLCoordinates> it = coords.iterator();
        GMLCoordinates c = it.next();
        ((Path2D)path).moveTo(c.getX(), c.getY());
        while (it.hasNext()) {
            c = it.next();
            ((Path2D)path).lineTo(c.getX(), c.getY());
        }
        path.closePath();
        return path;
    }

    public static Point2D toPoint(GMLNode node) {
        return new Point2D(node.getX(), node.getY());
    }

    public static Line2D toLine(GMLEdge edge) {
        return new Line2D(GMLTools.toPoint(edge.getStart()), GMLTools.toPoint(edge.getEnd()));
    }

    private static Rectangle2D expand(Rectangle2D rect, double x, double y) {
        if (rect == null) {
            return new Rectangle2D.Double(x, y, 0.0, 0.0);
        }
        double newMinX = Math.min(x, rect.getX());
        double newMaxX = Math.max(x, rect.getX() + rect.getWidth());
        double newMinY = Math.min(y, rect.getY());
        double newMaxY = Math.max(y, rect.getY() + rect.getHeight());
        rect.setRect(newMinX, newMinY, newMaxX - newMinX, newMaxY - newMinY);
        return rect;
    }

    private static Rectangle2D expand(Rectangle2D rect, GMLNode node) {
        return GMLTools.expand(rect, node.getX(), node.getY());
    }

    private static Rectangle2D expand(Rectangle2D rect, GMLEdge edge) {
        return GMLTools.expand(GMLTools.expand(rect, edge.getStart()), edge.getEnd());
    }

    private static Rectangle2D expand(Rectangle2D rect, GMLShape shape) {
        for (GMLDirectedEdge next : shape.getEdges()) {
            rect = GMLTools.expand(rect, next.getEdge());
        }
        return rect;
    }

    private static Rectangle2D expand(Rectangle2D rect, GMLObject object) {
        if (object instanceof GMLNode) {
            return GMLTools.expand(rect, (GMLNode)object);
        }
        if (object instanceof GMLEdge) {
            return GMLTools.expand(rect, (GMLEdge)object);
        }
        if (object instanceof GMLShape) {
            return GMLTools.expand(rect, (GMLShape)object);
        }
        return rect;
    }
}

