/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLEdge;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.editor.GMLEditor;
import maps.gml.editor.ProgressFunction;
import rescuecore2.log.Logger;

public class ComputePassableEdgesFunction
extends ProgressFunction {
    public ComputePassableEdgesFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Compute passable edges";
    }

    @Override
    protected String getTitle() {
        return "Finding neighbours";
    }

    @Override
    protected void executeImpl() {
        Set<GMLEdge> edges = this.editor.getMap().getEdges();
        this.setProgressLimit(edges.size());
        int passable = 0;
        int impassable = 0;
        for (GMLEdge next : edges) {
            Collection<GMLShape> shapes = this.editor.getMap().getAttachedShapes(next);
            if (shapes.size() == 2) {
                Iterator<GMLShape> it = shapes.iterator();
                GMLShape first = it.next();
                GMLShape second = it.next();
                if (first instanceof GMLRoad || second instanceof GMLRoad) {
                    next.setPassable(true);
                    GMLDirectedEdge firstEdge = this.findDirectedEdge(first.getEdges(), next);
                    GMLDirectedEdge secondEdge = this.findDirectedEdge(second.getEdges(), next);
                    first.setNeighbour(firstEdge, (Integer)second.getID());
                    second.setNeighbour(secondEdge, (Integer)first.getID());
                    ++passable;
                } else {
                    this.makeImpassable(next, shapes);
                    ++impassable;
                }
            } else {
                this.makeImpassable(next, shapes);
                ++impassable;
            }
            this.bumpProgress();
        }
        this.editor.setChanged();
        this.editor.getViewer().repaint();
        Logger.debug((String)("Made " + passable + " edges passable and " + impassable + " impassable"));
    }

    private void makeImpassable(GMLEdge edge, Collection<GMLShape> attached) {
        edge.setPassable(false);
        for (GMLShape shape : attached) {
            shape.setNeighbour(edge, null);
        }
    }

    private GMLDirectedEdge findDirectedEdge(List<GMLDirectedEdge> possible, GMLEdge target) {
        for (GMLDirectedEdge next : possible) {
            if (next.getEdge() != target) continue;
            return next;
        }
        return null;
    }
}

