/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLCoordinates;
import maps.gml.GMLNode;
import maps.gml.editor.AbstractTool;
import maps.gml.editor.GMLEditor;

public class CreateNodeTool
extends AbstractTool {
    private Listener listener = new Listener();

    public CreateNodeTool(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Create node";
    }

    @Override
    public void activate() {
        this.editor.getViewer().addMouseListener(this.listener);
        this.editor.getViewer().addMouseMotionListener(this.listener);
    }

    @Override
    public void deactivate() {
        this.editor.getViewer().removeMouseListener(this.listener);
        this.editor.getViewer().removeMouseMotionListener(this.listener);
    }

    private class CreateNodeEdit
    extends AbstractUndoableEdit {
        private GMLNode node;

        public CreateNodeEdit(GMLNode node) {
            this.node = node;
        }

        @Override
        public void undo() {
            super.undo();
            CreateNodeTool.this.editor.getMap().removeNode(this.node);
            CreateNodeTool.this.editor.getViewer().repaint();
        }

        @Override
        public void redo() {
            super.redo();
            CreateNodeTool.this.editor.getMap().addNode(this.node);
            CreateNodeTool.this.editor.getViewer().repaint();
        }
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                Point p = this.fixEventPoint(e.getPoint());
                GMLCoordinates c = CreateNodeTool.this.editor.snap(CreateNodeTool.this.editor.getViewer().getCoordinatesAtPoint(p.x, p.y));
                GMLNode node = CreateNodeTool.this.editor.getMap().createNode(c);
                CreateNodeTool.this.editor.setChanged();
                CreateNodeTool.this.editor.addEdit(new CreateNodeEdit(node));
                CreateNodeTool.this.editor.getViewer().repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private Point fixEventPoint(Point p) {
            Insets insets = CreateNodeTool.this.editor.getViewer().getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

