/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import maps.Map;
import maps.MapException;
import maps.MapFormat;
import maps.MapReader;
import maps.MapWriter;
import maps.gml.GMLCoordinates;
import maps.gml.GMLMap;
import maps.gml.GMLObject;
import maps.gml.editor.CancelledByUserException;
import maps.gml.editor.ComputePassableEdgesFunction;
import maps.gml.editor.CreateBuildingTool;
import maps.gml.editor.CreateEdgeTool;
import maps.gml.editor.CreateNodeTool;
import maps.gml.editor.CreateRoadTool;
import maps.gml.editor.CreateSpaceTool;
import maps.gml.editor.DeleteEdgeTool;
import maps.gml.editor.DeleteNodeTool;
import maps.gml.editor.DeleteShapeTool;
import maps.gml.editor.FixAttachedObjectsFunction;
import maps.gml.editor.FixDegenerateShapesFunction;
import maps.gml.editor.FixDuplicateEdgesFunction;
import maps.gml.editor.FixNearbyNodesFunction;
import maps.gml.editor.Function;
import maps.gml.editor.InspectTool;
import maps.gml.editor.MergeLinesTool;
import maps.gml.editor.MergeNodesTool;
import maps.gml.editor.MoveNodeTool;
import maps.gml.editor.PruneOrphanEdgesFunction;
import maps.gml.editor.PruneOrphanNodesFunction;
import maps.gml.editor.ScaleFunction;
import maps.gml.editor.Snap;
import maps.gml.editor.SplitEdgeTool;
import maps.gml.editor.SplitEdgesFunction;
import maps.gml.editor.TogglePassableTool;
import maps.gml.editor.Tool;
import maps.gml.formats.RobocupFormat;
import maps.gml.view.GMLMapViewer;
import maps.gml.view.GMLObjectInspector;
import rescuecore2.log.Logger;

public class GMLEditor
extends JPanel {
    private static final int VIEWER_PREFERRED_SIZE = 500;
    private static final int INSPECTOR_PREFERRED_WIDTH = 300;
    private static final int INSPECTOR_PREFERRED_HEIGHT = 500;
    private static final double SNAP_MIN_RESOLUTION = 0.001;
    private static final double SNAP_MAX_RESOLUTION = 1000.0;
    private static final NumberFormat FORMAT = new DecimalFormat("#0.000");
    private GMLMap map = new GMLMap();
    private GMLMapViewer viewer = new GMLMapViewer(this.map);
    private GMLObjectInspector inspector = new GMLObjectInspector(this.map);
    private JLabel x;
    private JLabel y;
    private boolean changed;
    private ViewerMouseListener viewerMouseListener;
    private Tool currentTool;
    private UndoManager undoManager = new UndoManager();
    private Action undoAction;
    private Action redoAction;
    private File saveFile;
    private File baseDir;
    private Snap snap;

    public GMLEditor(JMenuBar menuBar) {
        super(new BorderLayout());
        this.viewer.setPreferredSize(new Dimension(500, 500));
        this.inspector.setPreferredSize(new Dimension(300, 500));
        this.viewer.setBackground(Color.GRAY);
        this.viewer.getPanZoomListener().setPanOnRightMouse();
        this.snap = new Snap();
        this.changed = false;
        this.x = new JLabel("X: ");
        this.y = new JLabel("Y: ");
        JToolBar fileToolbar = new JToolBar("File");
        JToolBar viewToolbar = new JToolBar("View");
        JToolBar editToolbar = new JToolBar("Edit");
        JToolBar toolsToolbar = new JToolBar("Tools");
        JToolBar functionsToolbar = new JToolBar("Functions");
        JMenu fileMenu = new JMenu("File", false);
        JMenu viewMenu = new JMenu("View", false);
        JMenu editMenu = new JMenu("Edit", false);
        JMenu toolsMenu = new JMenu("Tools", false);
        JMenu functionsMenu = new JMenu("Functions", false);
        this.createFileActions(fileMenu, fileToolbar);
        this.createViewActions(viewMenu, viewToolbar);
        this.createEditActions(editMenu, editToolbar);
        this.createToolActions(toolsMenu, toolsToolbar);
        this.createFunctionActions(functionsMenu, functionsToolbar);
        JPanel main = new JPanel(new BorderLayout());
        JPanel labels = new JPanel(new GridLayout(1, 2));
        labels.add(this.x);
        labels.add(this.y);
        JSplitPane split = new JSplitPane(1, this.viewer, this.inspector);
        main.add((Component)split, "Center");
        main.add((Component)labels, "South");
        this.add((Component)main, "Center");
        JPanel toolbars = new JPanel(new GridLayout(0, 1));
        toolbars.add(fileToolbar);
        toolbars.add(viewToolbar);
        toolbars.add(editToolbar);
        toolbars.add(toolsToolbar);
        toolbars.add(functionsToolbar);
        this.add((Component)toolbars, "North");
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        menuBar.add(editMenu);
        menuBar.add(toolsMenu);
        menuBar.add(functionsMenu);
        this.viewerMouseListener = new ViewerMouseListener();
        this.viewer.addMouseListener(this.viewerMouseListener);
        this.viewer.addMouseMotionListener(this.viewerMouseListener);
        this.baseDir = new File(System.getProperty("user.dir"));
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("GMLEditor");
        JMenuBar menuBar = new JMenuBar();
        final GMLEditor editor = new GMLEditor(menuBar);
        if (args.length > 0 && args[0].length() > 0) {
            try {
                editor.load(args[0]);
            }
            catch (CancelledByUserException e) {
                return;
            }
            catch (MapException e) {
                e.printStackTrace();
            }
        }
        frame.setJMenuBar(menuBar);
        frame.setContentPane(editor);
        frame.setDefaultCloseOperation(0);
        frame.pack();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    editor.close();
                    frame.setVisible(false);
                    frame.dispose();
                    System.exit(0);
                }
                catch (CancelledByUserException ex) {
                    frame.setVisible(true);
                }
            }
        });
        frame.setVisible(true);
    }

    public void load() throws CancelledByUserException, MapException {
        JFileChooser chooser = new JFileChooser(this.baseDir);
        if (chooser.showOpenDialog(this) == 0) {
            this.load(chooser.getSelectedFile());
        }
    }

    public void load(String filename) throws CancelledByUserException, MapException {
        this.load(new File(filename));
    }

    public void load(File file) throws CancelledByUserException, MapException {
        this.setMap((GMLMap)MapReader.readMap(file));
        this.saveFile = file;
        this.baseDir = this.saveFile.getParentFile();
    }

    public void setMap(GMLMap newMap) throws CancelledByUserException {
        this.checkForChanges();
        this.map = newMap;
        this.changed = false;
        this.viewer.setMap(this.map);
        this.inspector.setMap(this.map);
        this.viewer.repaint();
    }

    public GMLMap getMap() {
        return this.map;
    }

    public void save() throws MapException {
        JFileChooser chooser;
        if (this.saveFile == null && (chooser = new JFileChooser(this.baseDir)).showSaveDialog(this) == 0) {
            this.saveFile = chooser.getSelectedFile();
        }
        if (this.saveFile != null) {
            Logger.debug((String)("Saving to " + this.saveFile.getAbsolutePath()));
            MapWriter.writeMap((Map)this.map, this.saveFile, (MapFormat)RobocupFormat.INSTANCE);
            this.baseDir = this.saveFile.getParentFile();
            this.changed = false;
        }
    }

    public void close() throws CancelledByUserException {
        this.checkForChanges();
    }

    public GMLMapViewer getViewer() {
        return this.viewer;
    }

    public GMLObjectInspector getInspector() {
        return this.inspector;
    }

    public void setChanged() {
        this.changed = true;
    }

    public void addEdit(UndoableEdit edit) {
        this.undoManager.addEdit(edit);
        this.undoAction.setEnabled(this.undoManager.canUndo());
        this.redoAction.setEnabled(this.undoManager.canRedo());
    }

    public GMLCoordinates snap(GMLCoordinates c) {
        this.snap.snap(c);
        return c;
    }

    private void updatePositionLabels(final Point p) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GMLCoordinates c = GMLEditor.this.viewer.getCoordinatesAtPoint(p.x, p.y);
                GMLEditor.this.x.setText("X: " + FORMAT.format(c.getX()));
                GMLEditor.this.y.setText("Y: " + FORMAT.format(c.getY()));
            }
        });
    }

    private void checkForChanges() throws CancelledByUserException {
        if (this.changed) {
            switch (JOptionPane.showConfirmDialog(null, "The current map has changes. Do you want to save them?")) {
                case 0: {
                    try {
                        this.save();
                        break;
                    }
                    catch (MapException e) {
                        JOptionPane.showMessageDialog(null, e);
                        throw new CancelledByUserException();
                    }
                }
                case 1: {
                    this.changed = false;
                    return;
                }
                case 2: {
                    throw new CancelledByUserException();
                }
                default: {
                    throw new RuntimeException("JOptionPane.showConfirmDialog returned something weird");
                }
            }
        }
    }

    private void createFileActions(JMenu menu, JToolBar toolbar) {
        AbstractAction newAction = new AbstractAction("New"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GMLEditor.this.checkForChanges();
                    GMLEditor.this.setMap(new GMLMap());
                }
                catch (CancelledByUserException ex) {
                    return;
                }
            }
        };
        AbstractAction loadAction = new AbstractAction("Load"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GMLEditor.this.checkForChanges();
                    GMLEditor.this.load();
                }
                catch (CancelledByUserException ex) {
                    return;
                }
                catch (MapException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
            }
        };
        AbstractAction saveAction = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GMLEditor.this.save();
                }
                catch (MapException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
            }
        };
        AbstractAction saveAsAction = new AbstractAction("Save as"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GMLEditor.this.saveFile = null;
                    GMLEditor.this.save();
                }
                catch (MapException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
            }
        };
        toolbar.add(newAction);
        toolbar.add(loadAction);
        toolbar.add(saveAction);
        toolbar.add(saveAsAction);
        menu.add(newAction);
        menu.add(loadAction);
        menu.add(saveAction);
        menu.add(saveAsAction);
    }

    private void createViewActions(JMenu menu, JToolBar toolbar) {
        final JCheckBox snapBox = new JCheckBox("Snap to grid", this.snap.isEnabled());
        final JSpinner snapSpinner = new JSpinner(new SpinnerNumberModel(this.snap.getResolution(), 0.001, 1000.0, 0.001));
        snapSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GMLEditor.this.snap.setResolution((Double)snapSpinner.getValue());
            }
        });
        snapBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GMLEditor.this.snap.setEnabled(snapBox.isSelected());
            }
        });
        AbstractAction gridAction = new AbstractAction("Show grid"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GMLEditor.this.viewer.setGridEnabled((Boolean)this.getValue("SwingSelectedKey"));
                GMLEditor.this.viewer.repaint();
            }
        };
        gridAction.putValue("SwingSelectedKey", false);
        toolbar.add(snapSpinner);
        toolbar.add(snapBox);
        toolbar.add(new JToggleButton(gridAction));
        menu.add(new JCheckBoxMenuItem(gridAction));
        final JTextField showField = new JTextField();
        JButton showButton = new JButton("Show");
        showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = showField.getText();
                ArrayList<GMLObject> objects = new ArrayList<GMLObject>();
                for (String next : s.split(",")) {
                    int id = Integer.parseInt(next.trim());
                    GMLObject o = GMLEditor.this.map.getObject(id);
                    if (o == null) continue;
                    objects.add(o);
                }
                GMLEditor.this.viewer.view(objects);
                GMLEditor.this.viewer.repaint();
            }
        });
        toolbar.addSeparator();
        toolbar.add(showField);
        toolbar.add(showButton);
        AbstractAction resetZoom = new AbstractAction("Reset zoom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GMLEditor.this.viewer.viewAll();
                GMLEditor.this.viewer.repaint();
            }
        };
        toolbar.addSeparator();
        menu.addSeparator();
        toolbar.add(resetZoom);
        menu.add(resetZoom);
    }

    private void createEditActions(JMenu menu, JToolBar toolbar) {
        this.undoAction = new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GMLEditor.this.undoManager.undo();
                }
                catch (CannotUndoException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
                this.setEnabled(GMLEditor.this.undoManager.canUndo());
                GMLEditor.this.redoAction.setEnabled(GMLEditor.this.undoManager.canRedo());
            }
        };
        this.redoAction = new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GMLEditor.this.undoManager.redo();
                }
                catch (CannotUndoException ex) {
                    JOptionPane.showMessageDialog(null, ex);
                }
                this.setEnabled(GMLEditor.this.undoManager.canRedo());
                GMLEditor.this.undoAction.setEnabled(GMLEditor.this.undoManager.canUndo());
            }
        };
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        toolbar.add(this.undoAction);
        toolbar.add(this.redoAction);
        menu.add(this.undoAction);
        menu.add(this.redoAction);
    }

    private void createToolActions(JMenu menu, JToolBar toolbar) {
        ButtonGroup toolbarGroup = new ButtonGroup();
        ButtonGroup menuGroup = new ButtonGroup();
        this.addTool(new InspectTool(this), menu, toolbar, menuGroup, toolbarGroup);
        menu.addSeparator();
        toolbar.addSeparator();
        this.addTool(new CreateNodeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new CreateEdgeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new CreateRoadTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new CreateBuildingTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new CreateSpaceTool(this), menu, toolbar, menuGroup, toolbarGroup);
        menu.addSeparator();
        toolbar.addSeparator();
        this.addTool(new DeleteNodeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new DeleteEdgeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new DeleteShapeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        menu.addSeparator();
        toolbar.addSeparator();
        this.addTool(new MoveNodeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new MergeNodesTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new MergeLinesTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new SplitEdgeTool(this), menu, toolbar, menuGroup, toolbarGroup);
        this.addTool(new TogglePassableTool(this), menu, toolbar, menuGroup, toolbarGroup);
    }

    private void createFunctionActions(JMenu menu, JToolBar toolbar) {
        this.addFunction(new ScaleFunction(this), menu, toolbar);
        this.addFunction(new FixNearbyNodesFunction(this), menu, toolbar);
        this.addFunction(new FixDuplicateEdgesFunction(this), menu, toolbar);
        this.addFunction(new SplitEdgesFunction(this), menu, toolbar);
        this.addFunction(new ComputePassableEdgesFunction(this), menu, toolbar);
        this.addFunction(new PruneOrphanNodesFunction(this), menu, toolbar);
        this.addFunction(new PruneOrphanEdgesFunction(this), menu, toolbar);
        this.addFunction(new FixDegenerateShapesFunction(this), menu, toolbar);
        this.addFunction(new FixAttachedObjectsFunction(this), menu, toolbar);
    }

    private void addTool(final Tool t, JMenu menu, JToolBar toolbar, ButtonGroup menuGroup, ButtonGroup toolbarGroup) {
        final JToggleButton toggle = new JToggleButton();
        final JCheckBoxMenuItem check = new JCheckBoxMenuItem();
        AbstractAction action = new AbstractAction(t.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GMLEditor.this.currentTool != null) {
                    GMLEditor.this.currentTool.deactivate();
                }
                GMLEditor.this.currentTool = t;
                toggle.setSelected(true);
                check.setSelected(true);
                GMLEditor.this.currentTool.activate();
            }
        };
        toggle.setAction(action);
        check.setAction(action);
        menu.add(check);
        toolbar.add(toggle);
        menuGroup.add(check);
        toolbarGroup.add(toggle);
    }

    private void addFunction(final Function f, JMenu menu, JToolBar toolbar) {
        AbstractAction action = new AbstractAction(f.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                f.execute();
            }
        };
        toolbar.add(action);
        menu.add(action);
    }

    private class ViewerMouseListener
    implements MouseListener,
    MouseMotionListener {
        private ViewerMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            GMLEditor.this.updatePositionLabels(this.fixEventPoint(e.getPoint()));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            GMLEditor.this.updatePositionLabels(this.fixEventPoint(e.getPoint()));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            GMLEditor.this.updatePositionLabels(this.fixEventPoint(e.getPoint()));
        }

        private Point fixEventPoint(Point p) {
            Insets insets = GMLEditor.this.viewer.getInsets();
            return new Point(p.x - insets.left, p.y - insets.top);
        }
    }
}

