/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.formats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLMap;
import maps.gml.GMLMapFormat;
import maps.gml.GMLNode;
import maps.gml.GMLRoad;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.XPath;
import rescuecore2.log.Logger;

public final class OrdnanceSurveyFormat
extends GMLMapFormat {
    public static final OrdnanceSurveyFormat INSTANCE = new OrdnanceSurveyFormat();
    private static final String FEATURE_CODE_BUILDING = "10021";
    private static final String FEATURE_CODE_ROAD = "10172";
    private static final String FEATURE_CODE_FOOTPATH = "10183";
    private static final String FEATURE_CODE_OPEN_SPACE = "10053";
    private static final String FEATURE_CODE_GENERAL_SPACE = "10056";
    private static final String OSGB_NAMESPACE_URI = "http://www.ordnancesurvey.co.uk/xml/namespaces/osgb";
    private static final Namespace OSGB_NAMESPACE = DocumentHelper.createNamespace((String)"osgb", (String)"http://www.ordnancesurvey.co.uk/xml/namespaces/osgb");
    private static final QName FEATURE_COLLECTION_QNAME = DocumentHelper.createQName((String)"FeatureCollection", (Namespace)OSGB_NAMESPACE);
    private static final QName TOPOGRAPHIC_AREA_QNAME = DocumentHelper.createQName((String)"TopographicArea", (Namespace)OSGB_NAMESPACE);
    private static final XPath BUILDING_XPATH = DocumentHelper.createXPath((String)"//osgb:topographicMember/osgb:TopographicArea[osgb:featureCode[text()='10021']]");
    private static final XPath ROAD_XPATH = DocumentHelper.createXPath((String)"//osgb:topographicMember/osgb:TopographicArea[osgb:featureCode[text()='10172']]");
    private static final XPath SPACE_XPATH = DocumentHelper.createXPath((String)"//osgb:topographicMember/osgb:TopographicArea[osgb:featureCode[text()='10053' or text()='10056']]");
    private static final XPath SHAPE_XPATH = DocumentHelper.createXPath((String)"osgb:polygon/gml:Polygon/gml:outerBoundaryIs/gml:LinearRing/gml:coordinates");
    private static final XPath INNER_RING_XPATH = DocumentHelper.createXPath((String)"osgb:polygon/gml:Polygon/gml:innerBoundaryIs/gml:LinearRing/gml:coordinates");
    private static final Map<String, String> URIS = new HashMap<String, String>();
    private static final int FID_PREFIX_LENGTH = 4;

    private OrdnanceSurveyFormat() {
    }

    public String toString() {
        return "Ordnance survey";
    }

    @Override
    public Map<String, String> getNamespaces() {
        return Collections.unmodifiableMap(URIS);
    }

    @Override
    public boolean isCorrectRootElement(String uri, String localName) {
        return OSGB_NAMESPACE_URI.equals(uri) && "FeatureCollection".equals(localName);
    }

    @Override
    public GMLMap read(Document doc) {
        GMLMap result = new GMLMap();
        this.readBuildings(doc, result);
        this.readRoads(doc, result);
        this.readSpaces(doc, result);
        return result;
    }

    @Override
    public Document write(GMLMap map) {
        throw new RuntimeException("OrdnanceSurveyFormat.write not implemented");
    }

    private void readBuildings(Document doc, GMLMap result) {
        for (Object next : BUILDING_XPATH.selectNodes((Object)doc)) {
            Logger.debug((String)("Found building element: " + next));
            Element e = (Element)next;
            String coordinatesString = ((Element)SHAPE_XPATH.evaluate((Object)e)).getText();
            List<GMLDirectedEdge> edges = this.readEdges(coordinatesString, result);
            GMLBuilding b = result.createBuilding(edges);
        }
    }

    private void readRoads(Document doc, GMLMap result) {
        for (Object next : ROAD_XPATH.selectNodes((Object)doc)) {
            Logger.debug((String)("Found road element: " + next));
            Element e = (Element)next;
            String coordinatesString = ((Element)SHAPE_XPATH.evaluate((Object)e)).getText();
            Object inner = INNER_RING_XPATH.evaluate((Object)e);
            if (inner instanceof Collection && ((Collection)inner).isEmpty()) {
                List<GMLDirectedEdge> edges = this.readEdges(coordinatesString, result);
                GMLRoad road = result.createRoad(edges);
                continue;
            }
            Logger.debug((String)"Inner ring found: ignoring");
            Logger.debug((String)("Found: " + inner));
        }
    }

    private void readSpaces(Document doc, GMLMap result) {
    }

    private List<GMLDirectedEdge> readEdges(String coordinatesString, GMLMap map) {
        ArrayList<GMLDirectedEdge> edges = new ArrayList<GMLDirectedEdge>();
        StringTokenizer tokens = new StringTokenizer(coordinatesString, " ");
        GMLCoordinates lastApex = null;
        GMLNode fromNode = null;
        GMLNode toNode = null;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            GMLCoordinates nextApex = new GMLCoordinates(token);
            toNode = map.createNode(nextApex);
            if (lastApex != null) {
                edges.add(new GMLDirectedEdge(map.createEdge(fromNode, toNode), true));
            }
            lastApex = nextApex;
            fromNode = toNode;
        }
        return edges;
    }

    static {
        URIS.put("gml", "http://www.opengis.net/gml");
        URIS.put("xlink", "http://www.w3.org/1999/xlink");
        URIS.put("osgb", OSGB_NAMESPACE_URI);
        BUILDING_XPATH.setNamespaceURIs(URIS);
        ROAD_XPATH.setNamespaceURIs(URIS);
        SPACE_XPATH.setNamespaceURIs(URIS);
        SHAPE_XPATH.setNamespaceURIs(URIS);
        INNER_RING_XPATH.setNamespaceURIs(URIS);
    }
}

