/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.List;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLRoad;
import maps.gml.GMLShape;
import maps.gml.GMLSpace;
import maps.gml.view.BuildingDecorator;
import maps.gml.view.RoadDecorator;
import maps.gml.view.SpaceDecorator;
import rescuecore2.misc.gui.ScreenTransform;

public class FilledShapeDecorator
implements BuildingDecorator,
RoadDecorator,
SpaceDecorator {
    private Color buildingColour;
    private Color roadColour;
    private Color spaceColour;

    public FilledShapeDecorator(Color buildingColour, Color roadColour, Color spaceColour) {
        this.buildingColour = buildingColour;
        this.roadColour = roadColour;
        this.spaceColour = spaceColour;
    }

    @Override
    public void decorate(GMLBuilding building, Graphics2D g, ScreenTransform transform) {
        g.setColor(this.buildingColour);
        this.draw(building, g, transform);
    }

    @Override
    public void decorate(GMLRoad road, Graphics2D g, ScreenTransform transform) {
        g.setColor(this.roadColour);
        this.draw(road, g, transform);
    }

    @Override
    public void decorate(GMLSpace space, Graphics2D g, ScreenTransform transform) {
        g.setColor(this.spaceColour);
        this.draw(space, g, transform);
    }

    private void draw(GMLShape shape, Graphics2D g, ScreenTransform transform) {
        List<GMLCoordinates> coords = shape.getUnderlyingCoordinates();
        int n = coords.size();
        int[] xs = new int[n];
        int[] ys = new int[n];
        int i = 0;
        for (GMLCoordinates next : coords) {
            xs[i] = transform.xToScreen(next.getX());
            ys[i] = transform.yToScreen(next.getY());
            ++i;
        }
        g.fill(new Polygon(xs, ys, n));
    }
}

