/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import java.awt.Polygon;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rescuecore2.misc.Pair;
import rescuecore2.standard.entities.Edge;
import rescuecore2.standard.entities.EdgeListProperty;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.EntityListener;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.properties.EntityRefListProperty;
import rescuecore2.worldmodel.properties.IntProperty;

public abstract class Area
extends StandardEntity {
    private IntProperty x;
    private IntProperty y;
    private EdgeListProperty edges;
    private EntityRefListProperty blockades;
    private Shape shape;
    private int[] apexList;
    private List<EntityID> neighbours;

    protected Area(EntityID id) {
        super(id);
        this.x = new IntProperty((Enum)StandardPropertyURN.X);
        this.y = new IntProperty((Enum)StandardPropertyURN.Y);
        this.edges = new EdgeListProperty(StandardPropertyURN.EDGES);
        this.blockades = new EntityRefListProperty((Enum)StandardPropertyURN.BLOCKADES);
        this.registerProperties(new Property[]{this.x, this.y, this.edges, this.blockades});
        this.shape = null;
        this.apexList = null;
        this.neighbours = null;
        this.addEntityListener(new EdgesListener());
    }

    protected Area(Area other) {
        super(other);
        this.x = new IntProperty(other.x);
        this.y = new IntProperty(other.y);
        this.edges = new EdgeListProperty(other.edges);
        this.blockades = new EntityRefListProperty(other.blockades);
        this.registerProperties(new Property[]{this.x, this.y, this.edges, this.blockades});
        this.shape = null;
        this.apexList = null;
        this.neighbours = null;
        this.addEntityListener(new EdgesListener());
    }

    @Override
    public Pair<Integer, Integer> getLocation(WorldModel<? extends StandardEntity> world) {
        return new Pair((Object)this.x.getValue(), (Object)this.y.getValue());
    }

    public Property getProperty(String urn) {
        StandardPropertyURN type;
        try {
            type = StandardPropertyURN.fromString(urn);
        }
        catch (IllegalArgumentException e) {
            return super.getProperty(urn);
        }
        switch (type) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case EDGES: {
                return this.edges;
            }
            case BLOCKADES: {
                return this.blockades;
            }
        }
        return super.getProperty(urn);
    }

    public IntProperty getXProperty() {
        return this.x;
    }

    public int getX() {
        return this.x.getValue();
    }

    public void setX(int x) {
        this.x.setValue(x);
    }

    public boolean isXDefined() {
        return this.x.isDefined();
    }

    public void undefineX() {
        this.x.undefine();
    }

    public IntProperty getYProperty() {
        return this.y;
    }

    public int getY() {
        return this.y.getValue();
    }

    public void setY(int y) {
        this.y.setValue(y);
    }

    public boolean isYDefined() {
        return this.y.isDefined();
    }

    public void undefineY() {
        this.y.undefine();
    }

    public EdgeListProperty getEdgesProperty() {
        return this.edges;
    }

    public List<Edge> getEdges() {
        return this.edges.getValue();
    }

    public void setEdges(List<Edge> edges) {
        this.edges.setEdges(edges);
    }

    public boolean isEdgesDefined() {
        return this.edges.isDefined();
    }

    public void undefineEdges() {
        this.edges.undefine();
    }

    public EntityRefListProperty getBlockadesProperty() {
        return this.blockades;
    }

    public List<EntityID> getBlockades() {
        return this.blockades.getValue();
    }

    public void setBlockades(List<EntityID> blockades) {
        this.blockades.setValue(blockades);
    }

    public boolean isBlockadesDefined() {
        return this.blockades.isDefined();
    }

    public void undefineBlockades() {
        this.blockades.undefine();
    }

    public List<EntityID> getNeighbours() {
        if (this.neighbours == null) {
            this.neighbours = new ArrayList<EntityID>();
            Iterator i$ = this.edges.getValue().iterator();
            while (i$.hasNext()) {
                Edge next = (Edge)i$.next();
                if (!next.isPassable()) continue;
                this.neighbours.add(next.getNeighbour());
            }
        }
        return this.neighbours;
    }

    public Edge getEdgeTo(EntityID neighbour) {
        for (Edge next : this.getEdges()) {
            if (!neighbour.equals((Object)next.getNeighbour())) continue;
            return next;
        }
        return null;
    }

    public int[] getApexList() {
        if (this.apexList == null) {
            List<Edge> e = this.getEdges();
            this.apexList = new int[e.size() * 2];
            int i = 0;
            for (Edge next : e) {
                this.apexList[i++] = next.getStartX();
                this.apexList[i++] = next.getStartY();
            }
        }
        return this.apexList;
    }

    public Shape getShape() {
        if (this.shape == null) {
            int[] apexes = this.getApexList();
            int count = apexes.length / 2;
            int[] xs = new int[count];
            int[] ys = new int[count];
            for (int i = 0; i < count; ++i) {
                xs[i] = apexes[i * 2];
                ys[i] = apexes[i * 2 + 1];
            }
            this.shape = new Polygon(xs, ys, count);
        }
        return this.shape;
    }

    static /* synthetic */ int[] access$302(Area x0, int[] x1) {
        x0.apexList = x1;
        return x1;
    }

    private class EdgesListener
    implements EntityListener {
        private EdgesListener() {
        }

        public void propertyChanged(Entity e, Property p, Object oldValue, Object newValue) {
            if (p == Area.this.edges) {
                Area.this.shape = null;
                Area.access$302(Area.this, null);
                Area.this.neighbours = null;
            }
        }
    }
}

