/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.worldmodel.EntityID;

public class Edge {
    private Point2D start;
    private Point2D end;
    private Line2D line;
    private EntityID neighbour;

    public Edge(int startX, int startY, int endX, int endY) {
        this(new Point2D((double)startX, (double)startY), new Point2D((double)endX, (double)endY), null);
    }

    public Edge(Point2D start, Point2D end) {
        this(start, end, null);
    }

    public Edge(int startX, int startY, int endX, int endY, EntityID neighbour) {
        this(new Point2D((double)startX, (double)startY), new Point2D((double)endX, (double)endY), neighbour);
    }

    public Edge(Point2D start, Point2D end, EntityID neighbour) {
        this.start = start;
        this.end = end;
        this.neighbour = neighbour;
        this.line = new Line2D(start, end);
    }

    public int getStartX() {
        return (int)this.start.getX();
    }

    public int getStartY() {
        return (int)this.start.getY();
    }

    public int getEndX() {
        return (int)this.end.getX();
    }

    public int getEndY() {
        return (int)this.end.getY();
    }

    public Point2D getStart() {
        return this.start;
    }

    public Point2D getEnd() {
        return this.end;
    }

    public EntityID getNeighbour() {
        return this.neighbour;
    }

    public boolean isPassable() {
        return this.neighbour != null;
    }

    public Line2D getLine() {
        return this.line;
    }

    public String toString() {
        return "Edge from " + this.start + " to " + this.end + " (" + (this.neighbour == null ? "impassable" : "neighbour: " + this.neighbour) + ")";
    }
}

