/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardPropertyURN;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.properties.IntProperty;

public class FireBrigade
extends Human {
    private IntProperty water;

    public FireBrigade(EntityID id) {
        super(id);
        this.water = new IntProperty((Enum)StandardPropertyURN.WATER_QUANTITY);
        this.registerProperties(new Property[]{this.water});
    }

    public FireBrigade(FireBrigade other) {
        super(other);
        this.water = new IntProperty(other.water);
        this.registerProperties(new Property[]{this.water});
    }

    protected Entity copyImpl() {
        return new FireBrigade(this.getID());
    }

    @Override
    public StandardEntityURN getStandardURN() {
        return StandardEntityURN.FIRE_BRIGADE;
    }

    @Override
    public Property getProperty(String urn) {
        StandardPropertyURN type;
        try {
            type = StandardPropertyURN.fromString(urn);
        }
        catch (IllegalArgumentException e) {
            return super.getProperty(urn);
        }
        switch (type) {
            case WATER_QUANTITY: {
                return this.water;
            }
        }
        return super.getProperty(urn);
    }

    public IntProperty getWaterProperty() {
        return this.water;
    }

    public int getWater() {
        return this.water.getValue();
    }

    public void setWater(int water) {
        this.water.setValue(water);
    }

    public boolean isWaterDefined() {
        return this.water.isDefined();
    }

    public void undefineWater() {
        this.water.undefine();
    }

    protected String getEntityName() {
        return "Fire brigade";
    }
}

