/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.entities;

import rescuecore2.registry.AbstractEntityFactory;
import rescuecore2.standard.entities.AmbulanceCentre;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.FireStation;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.PoliceOffice;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.World;
import rescuecore2.worldmodel.EntityID;

public final class StandardEntityFactory
extends AbstractEntityFactory<StandardEntityURN> {
    public static final StandardEntityFactory INSTANCE = new StandardEntityFactory();

    private StandardEntityFactory() {
        super(StandardEntityURN.class);
    }

    public StandardEntity makeEntity(StandardEntityURN urn, EntityID id) {
        switch (urn) {
            case WORLD: {
                return new World(id);
            }
            case ROAD: {
                return new Road(id);
            }
            case BUILDING: {
                return new Building(id);
            }
            case BLOCKADE: {
                return new Blockade(id);
            }
            case REFUGE: {
                return new Refuge(id);
            }
            case FIRE_STATION: {
                return new FireStation(id);
            }
            case AMBULANCE_CENTRE: {
                return new AmbulanceCentre(id);
            }
            case POLICE_OFFICE: {
                return new PoliceOffice(id);
            }
            case CIVILIAN: {
                return new Civilian(id);
            }
            case FIRE_BRIGADE: {
                return new FireBrigade(id);
            }
            case AMBULANCE_TEAM: {
                return new AmbulanceTeam(id);
            }
            case POLICE_FORCE: {
                return new PoliceForce(id);
            }
        }
        throw new IllegalArgumentException("Unrecognised entity urn: " + (Object)((Object)urn));
    }
}

