/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kernel.AgentProxy;
import kernel.Perception;
import rescuecore2.GUIComponent;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.misc.Pair;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Edge;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.view.BuildingLayer;
import rescuecore2.standard.view.HumanLayer;
import rescuecore2.standard.view.RoadBlockageLayer;
import rescuecore2.standard.view.RoadLayer;
import rescuecore2.standard.view.StandardViewLayer;
import rescuecore2.standard.view.StandardWorldModelViewer;
import rescuecore2.view.RenderedObject;
import rescuecore2.view.ViewComponent;
import rescuecore2.view.ViewLayer;
import rescuecore2.view.ViewListener;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.properties.IntProperty;

public class LineOfSightPerception
implements Perception,
GUIComponent {
    private static final int DEFAULT_VIEW_DISTANCE = 30000;
    private static final int DEFAULT_HP_PRECISION = 1000;
    private static final int DEFAULT_DAMAGE_PRECISION = 100;
    private static final int DEFAULT_RAY_COUNT = 720;
    private static final String VIEW_DISTANCE_KEY = "perception.los.max-distance";
    private static final String RAY_COUNT_KEY = "perception.los.ray-count";
    private static final String HP_PRECISION_KEY = "perception.los.precision.hp";
    private static final String DAMAGE_PRECISION_KEY = "perception.los.precision.damage";
    private static final IntersectionSorter INTERSECTION_SORTER = new IntersectionSorter();
    private int viewDistance;
    private int hpPrecision;
    private int damagePrecision;
    private int rayCount;
    private StandardWorldModel world;
    private Config config;
    private LOSView view;

    public void initialise(Config newConfig, WorldModel<? extends Entity> model) {
        this.world = StandardWorldModel.createStandardWorldModel(model);
        this.config = newConfig;
        this.viewDistance = this.config.getIntValue(VIEW_DISTANCE_KEY, 30000);
        this.hpPrecision = this.config.getIntValue(HP_PRECISION_KEY, 1000);
        this.damagePrecision = this.config.getIntValue(DAMAGE_PRECISION_KEY, 100);
        this.rayCount = this.config.getIntValue(RAY_COUNT_KEY, 720);
        this.view = null;
    }

    public String toString() {
        return "Line of sight perception";
    }

    public JComponent getGUIComponent() {
        if (this.view == null) {
            this.view = new LOSView();
            this.view.refresh();
        }
        return this.view;
    }

    public String getGUIComponentName() {
        return "Line of sight";
    }

    public void setTime(int timestep) {
        if (this.view != null) {
            this.view.clear();
            this.view.refresh();
        }
    }

    public ChangeSet getVisibleEntities(AgentProxy agent) {
        StandardEntity agentEntity = (StandardEntity)agent.getControlledEntity();
        Logger.debug((String)("Finding visible entities for " + (Object)((Object)agentEntity)));
        ChangeSet result = new ChangeSet();
        Pair<Integer, Integer> location = agentEntity.getLocation((WorldModel<? extends StandardEntity>)this.world);
        if (location != null) {
            Point2D point = new Point2D((double)((Integer)location.first()).intValue(), (double)((Integer)location.second()).intValue());
            Collection<StandardEntity> nearby = this.world.getObjectsInRange((Integer)location.first(), (Integer)location.second(), this.viewDistance);
            Collection<StandardEntity> visible = this.findVisible(agentEntity, point, nearby);
            for (StandardEntity next : visible) {
                StandardEntityURN urn = next.getStandardURN();
                switch (urn) {
                    case ROAD: {
                        this.addRoadProperties((Road)next, result);
                        break;
                    }
                    case BUILDING: 
                    case REFUGE: 
                    case FIRE_STATION: 
                    case AMBULANCE_CENTRE: 
                    case POLICE_OFFICE: {
                        this.addBuildingProperties((Building)next, result);
                        break;
                    }
                    case CIVILIAN: 
                    case FIRE_BRIGADE: 
                    case AMBULANCE_TEAM: 
                    case POLICE_FORCE: {
                        if (next == agentEntity) {
                            this.addSelfProperties((Human)next, result);
                            break;
                        }
                        this.addHumanProperties((Human)next, result);
                        break;
                    }
                    case BLOCKADE: {
                        this.addBlockadeProperties((Blockade)next, result);
                        break;
                    }
                }
            }
        }
        if (this.view != null) {
            this.view.repaint();
        }
        return result;
    }

    private void addRoadProperties(Road road, ChangeSet result) {
        this.addAreaProperties(road, result);
        result.addChange((Entity)road, (Property)road.getBlockadesProperty());
        if (road.isBlockadesDefined()) {
            for (EntityID id : road.getBlockades()) {
                Blockade blockade = (Blockade)this.world.getEntity(id);
                if (blockade == null) {
                    Logger.error((String)("Blockade " + id + " is null!"));
                    Logger.error((String)road.getFullDescription());
                    continue;
                }
                this.addBlockadeProperties(blockade, result);
            }
        }
    }

    private void addBuildingProperties(Building building, ChangeSet result) {
        this.addAreaProperties(building, result);
        result.addChange((Entity)building, (Property)building.getTemperatureProperty());
        result.addChange((Entity)building, (Property)building.getFierynessProperty());
        result.addChange((Entity)building, (Property)building.getBrokennessProperty());
    }

    private void addAreaProperties(Area area, ChangeSet result) {
    }

    private void addFarBuildingProperties(Building building, ChangeSet result) {
        result.addChange((Entity)building, (Property)building.getFierynessProperty());
    }

    private void addHumanProperties(Human human, ChangeSet result) {
        result.addChange((Entity)human, (Property)human.getPositionProperty());
        result.addChange((Entity)human, (Property)human.getXProperty());
        result.addChange((Entity)human, (Property)human.getYProperty());
        result.addChange((Entity)human, (Property)human.getDirectionProperty());
        result.addChange((Entity)human, (Property)human.getStaminaProperty());
        result.addChange((Entity)human, (Property)human.getBuriednessProperty());
        IntProperty hp = human.getHPProperty().copy();
        this.roundProperty(hp, this.hpPrecision);
        result.addChange((Entity)human, (Property)hp);
        IntProperty damage = human.getDamageProperty().copy();
        this.roundProperty(damage, this.damagePrecision);
        result.addChange((Entity)human, (Property)damage);
    }

    private void addSelfProperties(Human human, ChangeSet result) {
        this.addHumanProperties(human, result);
        result.addChange((Entity)human, (Property)human.getPositionHistoryProperty());
        result.addChange((Entity)human, (Property)human.getHPProperty());
        result.addChange((Entity)human, (Property)human.getDamageProperty());
        if (human instanceof FireBrigade) {
            FireBrigade fb = (FireBrigade)human;
            result.addChange((Entity)fb, (Property)fb.getWaterProperty());
        }
    }

    private void addBlockadeProperties(Blockade blockade, ChangeSet result) {
        result.addChange((Entity)blockade, (Property)blockade.getXProperty());
        result.addChange((Entity)blockade, (Property)blockade.getYProperty());
        result.addChange((Entity)blockade, (Property)blockade.getPositionProperty());
        result.addChange((Entity)blockade, (Property)blockade.getApexesProperty());
        result.addChange((Entity)blockade, (Property)blockade.getRepairCostProperty());
    }

    private void roundProperty(IntProperty p, int precision) {
        if (precision != 1 && p.isDefined()) {
            p.setValue(this.round(p.getValue(), precision));
        }
    }

    private int round(int value, int precision) {
        int remainder = value % precision;
        value -= remainder;
        if (remainder >= precision / 2) {
            value += precision;
        }
        return value;
    }

    private Collection<StandardEntity> findVisible(StandardEntity agentEntity, Point2D location, Collection<StandardEntity> nearby) {
        Logger.debug((String)("Finding visible entities from " + location));
        Logger.debug((String)(nearby.size() + " nearby entities"));
        Collection<LineInfo> lines = this.getAllLines(nearby);
        double dAngle = Math.PI * 2 / (double)this.rayCount;
        HashSet<StandardEntity> result = new HashSet<StandardEntity>();
        for (int i = 0; i < this.rayCount; ++i) {
            double angle = (double)i * dAngle;
            Vector2D vector = new Vector2D(Math.sin(angle), Math.cos(angle)).scale((double)this.viewDistance);
            Ray ray = new Ray(new Line2D(location, vector), lines);
            for (LineInfo hit : ray.getLinesHit()) {
                StandardEntity e = hit.getEntity();
                result.add(e);
            }
            if (this.view == null) continue;
            this.view.addRay(agentEntity, ray);
        }
        for (StandardEntity next : nearby) {
            Human h;
            if (!(next instanceof Human) || !this.canSee(agentEntity, location, h = (Human)next, lines)) continue;
            result.add(h);
        }
        result.add(agentEntity);
        Logger.debug((String)((Object)((Object)agentEntity) + " can see " + result));
        return result;
    }

    private boolean canSee(StandardEntity agent, Point2D location, Human h, Collection<LineInfo> lines) {
        if (h.isXDefined() && h.isYDefined()) {
            int y;
            int x = h.getX();
            Point2D humanLocation = new Point2D((double)x, (double)(y = h.getY()));
            Ray ray = new Ray(new Line2D(location, humanLocation), lines);
            if (ray.getVisibleLength() >= 1.0) {
                if (this.view != null) {
                    this.view.addRay(agent, ray);
                }
                return true;
            }
        } else if (h.isPositionDefined()) {
            if (h.getPosition().equals((Object)agent.getID())) {
                return true;
            }
            Entity e = this.world.getEntity(h.getPosition());
            if (e instanceof AmbulanceTeam) {
                return this.canSee(agent, location, (Human)e, lines);
            }
        }
        return false;
    }

    private Collection<LineInfo> getAllLines(Collection<StandardEntity> entities) {
        HashSet<LineInfo> result = new HashSet<LineInfo>();
        for (StandardEntity next : entities) {
            Line2D line;
            if (next instanceof Building) {
                for (Edge edge : ((Building)next).getEdges()) {
                    line = edge.getLine();
                    result.add(new LineInfo(line, next, !edge.isPassable()));
                }
            }
            if (next instanceof Road) {
                for (Edge edge : ((Road)next).getEdges()) {
                    line = edge.getLine();
                    result.add(new LineInfo(line, next, false));
                }
                continue;
            }
            if (!(next instanceof Blockade)) continue;
            int[] apexes = ((Blockade)next).getApexes();
            List points = GeometryTools2D.vertexArrayToPoints((int[])apexes);
            List lines = GeometryTools2D.pointsToLines((List)points, (boolean)true);
            for (Line2D line2 : lines) {
                result.add(new LineInfo(line2, next, false));
            }
        }
        return result;
    }

    private class LOSView
    extends JPanel {
        private transient StandardWorldModelViewer viewer;
        private transient Collection<Ray> rays;
        private transient Map<StandardEntity, Collection<Ray>> sources;
        private transient StandardEntity selected;

        public LOSView() {
            super(new BorderLayout());
            this.viewer = new StandardWorldModelViewer();
            this.viewer.removeAllLayers();
            this.viewer.addLayer((ViewLayer)new BuildingLayer());
            this.viewer.addLayer((ViewLayer)new RoadLayer());
            this.viewer.addLayer((ViewLayer)new RoadBlockageLayer());
            this.viewer.addLayer((ViewLayer)new HumanLayer());
            this.viewer.addLayer((ViewLayer)new RayLayer());
            this.rays = new ArrayList<Ray>();
            this.sources = new LazyMap<StandardEntity, Collection<Ray>>(){

                public Collection<Ray> createValue() {
                    return new HashSet<Ray>();
                }
            };
            this.selected = null;
            this.viewer.addViewListener(new ViewListener(){

                public void objectsClicked(ViewComponent v, List<RenderedObject> objects) {
                    LOSView.this.selected = null;
                    for (RenderedObject o : objects) {
                        if (!(o.getObject() instanceof Human)) continue;
                        LOSView.this.selected = (StandardEntity)((Object)o.getObject());
                        LOSView.this.viewer.repaint();
                    }
                }

                public void objectsRollover(ViewComponent v, List<RenderedObject> objects) {
                }
            });
            this.add((Component)((Object)this.viewer), "Center");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Collection<Ray> collection = this.rays;
            synchronized (collection) {
                this.rays.clear();
                this.sources.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRay(StandardEntity source, Ray ray) {
            Collection<Ray> collection = this.rays;
            synchronized (collection) {
                this.rays.add(ray);
                this.sources.get((Object)source).add(ray);
            }
        }

        public void refresh() {
            this.viewer.view(new Object[]{LineOfSightPerception.this.world});
        }

        private class RayLayer
        extends StandardViewLayer {
            private RayLayer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Collection<RenderedObject> render(Graphics2D g, ScreenTransform transform, int width, int height) {
                HashSet toDraw = new HashSet();
                Collection collection = LOSView.this.rays;
                synchronized (collection) {
                    if (LOSView.this.selected == null) {
                        toDraw.addAll(LOSView.this.rays);
                    } else {
                        toDraw.addAll((Collection)LOSView.this.sources.get((Object)LOSView.this.selected));
                    }
                }
                g.setColor(Color.CYAN);
                for (Ray next : toDraw) {
                    Line2D line = next.getRay();
                    Point2D origin = line.getOrigin();
                    Point2D end = line.getPoint(next.getVisibleLength());
                    int x1 = transform.xToScreen(origin.getX());
                    int y1 = transform.yToScreen(origin.getY());
                    int x2 = transform.xToScreen(end.getX());
                    int y2 = transform.yToScreen(end.getY());
                    g.drawLine(x1, y1, x2, y2);
                }
                return new ArrayList<RenderedObject>();
            }

            public String getName() {
                return "Line of sight rays";
            }
        }
    }

    private static class IntersectionSorter
    implements Comparator<Pair<LineInfo, Double>>,
    Serializable {
        private IntersectionSorter() {
        }

        @Override
        public int compare(Pair<LineInfo, Double> a, Pair<LineInfo, Double> b) {
            double d2;
            double d1 = (Double)a.second();
            if (d1 < (d2 = ((Double)b.second()).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    private static class LineInfo {
        private Line2D line;
        private StandardEntity entity;
        private boolean blocking;

        public LineInfo(Line2D line, StandardEntity entity, boolean blocking) {
            this.line = line;
            this.entity = entity;
            this.blocking = blocking;
        }

        public Line2D getLine() {
            return this.line;
        }

        public StandardEntity getEntity() {
            return this.entity;
        }

        public boolean isBlocking() {
            return this.blocking;
        }
    }

    private static class Ray {
        private Line2D ray;
        private double length;
        private List<LineInfo> hit;

        public Ray(Line2D ray, Collection<LineInfo> otherLines) {
            this.ray = ray;
            ArrayList<Pair> intersections = new ArrayList<Pair>();
            for (LineInfo other : otherLines) {
                double d1 = ray.getIntersection(other.getLine());
                double d2 = other.getLine().getIntersection(ray);
                if (!(d2 >= 0.0) || !(d2 <= 1.0) || !(d1 > 0.0) || !(d1 <= 1.0)) continue;
                intersections.add(new Pair((Object)other, (Object)d1));
            }
            Collections.sort(intersections, INTERSECTION_SORTER);
            this.hit = new ArrayList<LineInfo>();
            this.length = 1.0;
            for (Pair next : intersections) {
                LineInfo l = (LineInfo)next.first();
                this.hit.add(l);
                if (!l.isBlocking()) continue;
                this.length = (Double)next.second();
                break;
            }
        }

        public Line2D getRay() {
            return this.ray;
        }

        public double getVisibleLength() {
            return this.length;
        }

        public List<LineInfo> getLinesHit() {
            return Collections.unmodifiableList(this.hit);
        }
    }
}

