/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel;

import handy.swing.SliderComponent;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kernel.AgentProxy;
import kernel.Perception;
import rescuecore2.GUIComponent;
import rescuecore2.config.Config;
import rescuecore2.misc.Pair;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.properties.IntProperty;

public class StandardPerception
implements Perception,
GUIComponent {
    private static final boolean DEFAULT_USE_FAR_FIRES = true;
    private static final int DEFAULT_HP_PRECISION = 1000;
    private static final int DEFAULT_DAMAGE_PRECISION = 100;
    private static final String VIEW_DISTANCE_KEY = "perception.standard.view-distance";
    private static final String FAR_FIRE_DISTANCE_KEY = "perception.standard.far-fire-distance";
    private static final String USE_FAR_FIRES_KEY = "perception.standard.use-far-fires";
    private static final String HP_PRECISION_KEY = "perception.standard.hp-precision";
    private static final String DAMAGE_PRECISION_KEY = "perception.standard.damage-precision";
    private static final int PRECISION_STEP_SIZE = 1000;
    private static final int PRECISION_MAX = 10000;
    private static final int VIEW_DISTANCE_MAX = 1000000;
    private static final int VIEW_DISTANCE_MAJOR_TICK = 100000;
    private static final int VIEW_DISTANCE_MINOR_TICK = 10000;
    private static final int PRECISION_MAJOR_TICK = 1000;
    private static final int PRECISION_MINOR_TICK = 100;
    private int viewDistance;
    private int farFireDistance;
    private boolean useFarFires;
    private int hpPrecision;
    private int damagePrecision;
    private StandardWorldModel world;
    private int time;
    private Set<Building> unburntBuildings;
    private Map<Building, Integer> ignitionTimes;
    private Config config;
    private final Object lock = new Object();

    public void initialise(Config newConfig, WorldModel<? extends Entity> model) {
        this.world = StandardWorldModel.createStandardWorldModel(model);
        this.config = newConfig;
        this.viewDistance = this.config.getIntValue(VIEW_DISTANCE_KEY);
        this.farFireDistance = this.config.getIntValue(FAR_FIRE_DISTANCE_KEY);
        this.useFarFires = this.config.getBooleanValue(USE_FAR_FIRES_KEY, true);
        this.hpPrecision = this.config.getIntValue(HP_PRECISION_KEY, 1000);
        this.damagePrecision = this.config.getIntValue(DAMAGE_PRECISION_KEY, 100);
        this.ignitionTimes = new HashMap<Building, Integer>();
        this.unburntBuildings = new HashSet<Building>();
        this.time = 0;
        Iterator i$ = this.world.iterator();
        while (i$.hasNext()) {
            StandardEntity next = (StandardEntity)((Object)i$.next());
            if (!(next instanceof Building)) continue;
            Building b = (Building)next;
            if (!b.isFierynessDefined() || b.getFieryness() == 0) {
                this.unburntBuildings.add(b);
                continue;
            }
            this.ignitionTimes.put(b, this.time);
        }
    }

    public String toString() {
        return "Standard perception";
    }

    public JComponent getGUIComponent() {
        return new TunePanel();
    }

    public String getGUIComponentName() {
        return "Perception parameters";
    }

    public void setTime(int timestep) {
        Iterator<Building> it = this.unburntBuildings.iterator();
        while (it.hasNext()) {
            Building next = it.next();
            if (!next.isFierynessDefined()) continue;
            switch (next.getFierynessEnum()) {
                case HEATING: 
                case BURNING: 
                case INFERNO: {
                    this.ignitionTimes.put(next, this.time);
                    it.remove();
                    break;
                }
            }
        }
        this.time = timestep;
        this.checkForScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSet getVisibleEntities(AgentProxy agent) {
        Object object = this.lock;
        synchronized (object) {
            StandardEntity agentEntity = (StandardEntity)agent.getControlledEntity();
            ChangeSet result = new ChangeSet();
            Pair<Integer, Integer> location = agentEntity.getLocation((WorldModel<? extends StandardEntity>)this.world);
            if (location != null) {
                int x = (Integer)location.first();
                int y = (Integer)location.second();
                Collection<StandardEntity> nearby = this.world.getObjectsInRange(x, y, this.viewDistance);
                for (StandardEntity standardEntity : nearby) {
                    StandardEntityURN urn = standardEntity.getStandardURN();
                    switch (urn) {
                        case ROAD: {
                            this.addRoadProperties((Road)standardEntity, result);
                            break;
                        }
                        case BUILDING: 
                        case REFUGE: 
                        case FIRE_STATION: 
                        case AMBULANCE_CENTRE: 
                        case POLICE_OFFICE: {
                            this.addBuildingProperties((Building)standardEntity, result);
                            break;
                        }
                        case CIVILIAN: 
                        case FIRE_BRIGADE: 
                        case AMBULANCE_TEAM: 
                        case POLICE_FORCE: {
                            if (standardEntity == agentEntity) {
                                this.addSelfProperties((Human)standardEntity, result);
                                break;
                            }
                            this.addHumanProperties((Human)standardEntity, result);
                            break;
                        }
                        case BLOCKADE: {
                            this.addBlockadeProperties((Blockade)standardEntity, result);
                            break;
                        }
                    }
                }
                if (this.useFarFires) {
                    for (Map.Entry entry : this.ignitionTimes.entrySet()) {
                        Building b = (Building)((Object)entry.getKey());
                        int ignitionTime = (Integer)entry.getValue();
                        int timeDelta = this.time - ignitionTime;
                        int visibleRange = timeDelta * this.farFireDistance;
                        int range = this.world.getDistance(agentEntity, b);
                        if (range > visibleRange) continue;
                        this.addFarBuildingProperties(b, result);
                    }
                }
            }
            return result;
        }
    }

    private void addRoadProperties(Road road, ChangeSet result) {
        this.addAreaProperties(road, result);
        result.addChange((Entity)road, (Property)road.getBlockadesProperty());
        if (road.isBlockadesDefined()) {
            for (EntityID id : road.getBlockades()) {
                Blockade blockade = (Blockade)this.world.getEntity(id);
                this.addBlockadeProperties(blockade, result);
            }
        }
    }

    private void addBuildingProperties(Building building, ChangeSet result) {
        this.addAreaProperties(building, result);
        result.addChange((Entity)building, (Property)building.getTemperatureProperty());
        result.addChange((Entity)building, (Property)building.getFierynessProperty());
        result.addChange((Entity)building, (Property)building.getBrokennessProperty());
    }

    private void addAreaProperties(Area area, ChangeSet result) {
    }

    private void addFarBuildingProperties(Building building, ChangeSet result) {
        result.addChange((Entity)building, (Property)building.getFierynessProperty());
    }

    private void addHumanProperties(Human human, ChangeSet result) {
        result.addChange((Entity)human, (Property)human.getPositionProperty());
        result.addChange((Entity)human, (Property)human.getDirectionProperty());
        result.addChange((Entity)human, (Property)human.getStaminaProperty());
        result.addChange((Entity)human, (Property)human.getBuriednessProperty());
        IntProperty hp = human.getHPProperty().copy();
        this.roundProperty(hp, this.hpPrecision);
        result.addChange((Entity)human, (Property)hp);
        IntProperty damage = human.getDamageProperty().copy();
        this.roundProperty(damage, this.damagePrecision);
        result.addChange((Entity)human, (Property)damage);
    }

    private void addSelfProperties(Human human, ChangeSet result) {
        this.addHumanProperties(human, result);
        result.addChange((Entity)human, (Property)human.getPositionHistoryProperty());
        result.addChange((Entity)human, (Property)human.getHPProperty());
        result.addChange((Entity)human, (Property)human.getDamageProperty());
    }

    private void addBlockadeProperties(Blockade blockade, ChangeSet result) {
        result.addChange((Entity)blockade, (Property)blockade.getXProperty());
        result.addChange((Entity)blockade, (Property)blockade.getYProperty());
        result.addChange((Entity)blockade, (Property)blockade.getPositionProperty());
        result.addChange((Entity)blockade, (Property)blockade.getApexesProperty());
        result.addChange((Entity)blockade, (Property)blockade.getRepairCostProperty());
    }

    private void roundProperty(IntProperty p, int precision) {
        if (precision != 1 && p.isDefined()) {
            p.setValue(this.round(p.getValue(), precision));
        }
    }

    private int round(int value, int precision) {
        int remainder = value % precision;
        value -= remainder;
        if (remainder >= precision / 2) {
            value += precision;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewDistance(int value) {
        Object object = this.lock;
        synchronized (object) {
            this.viewDistance = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHPPrecision(int value) {
        Object object = this.lock;
        synchronized (object) {
            if (value == 0) {
                value = 1;
            }
            this.hpPrecision = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDamagePrecision(int value) {
        Object object = this.lock;
        synchronized (object) {
            if (value == 0) {
                value = 1;
            }
            this.damagePrecision = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUseFarFires(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            this.useFarFires = value;
        }
    }

    private void checkForScript() {
        this.viewDistance = this.config.getIntValue("perception.standard.view-distance.script." + this.time, this.viewDistance);
        this.farFireDistance = this.config.getIntValue("perception.standard.far-fire-distance.script." + this.time, this.farFireDistance);
        this.useFarFires = this.config.getBooleanValue("perception.standard.use-far-fires.script." + this.time, this.useFarFires);
        this.hpPrecision = this.config.getIntValue("perception.standard.hp-precision.script." + this.time, this.hpPrecision);
        this.damagePrecision = this.config.getIntValue("perception.standard.damage-precision.script." + this.time, this.damagePrecision);
    }

    private class TunePanel
    extends JPanel {
        private JSlider viewDistanceSlider;
        private JSlider hpPrecisionSlider;
        private JSlider damagePrecisionSlider;
        private JCheckBox farFiresBox;

        public TunePanel() {
            super(new GridLayout(1, 4));
            this.viewDistanceSlider = new JSlider(1, 0, 1000000, StandardPerception.this.viewDistance);
            this.hpPrecisionSlider = new JSlider(1, 0, 10000, StandardPerception.this.hpPrecision);
            this.damagePrecisionSlider = new JSlider(1, 0, 10000, StandardPerception.this.damagePrecision);
            this.farFiresBox = new JCheckBox("Use far fires?", StandardPerception.this.useFarFires);
            SliderComponent s = new SliderComponent(this.viewDistanceSlider);
            s.setBorder((Border)BorderFactory.createTitledBorder("View distance"));
            this.add((Component)s);
            s = new SliderComponent(this.hpPrecisionSlider);
            s.setBorder((Border)BorderFactory.createTitledBorder("HP precision"));
            this.add((Component)s);
            s = new SliderComponent(this.damagePrecisionSlider);
            s.setBorder((Border)BorderFactory.createTitledBorder("Damage precision"));
            this.add((Component)s);
            this.add(this.farFiresBox);
            this.viewDistanceSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    StandardPerception.this.updateViewDistance(TunePanel.this.viewDistanceSlider.getValue());
                }
            });
            this.hpPrecisionSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    StandardPerception.this.updateHPPrecision(TunePanel.this.hpPrecisionSlider.getValue());
                }
            });
            this.damagePrecisionSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    StandardPerception.this.updateDamagePrecision(TunePanel.this.damagePrecisionSlider.getValue());
                }
            });
            this.farFiresBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardPerception.this.updateUseFarFires(TunePanel.this.farFiresBox.isSelected());
                }
            });
            this.viewDistanceSlider.setPaintLabels(true);
            this.viewDistanceSlider.setPaintTicks(true);
            this.viewDistanceSlider.setMajorTickSpacing(100000);
            this.viewDistanceSlider.setMinorTickSpacing(10000);
            this.hpPrecisionSlider.setPaintLabels(true);
            this.hpPrecisionSlider.setPaintTicks(true);
            this.hpPrecisionSlider.setMajorTickSpacing(1000);
            this.hpPrecisionSlider.setMinorTickSpacing(100);
            this.damagePrecisionSlider.setPaintLabels(true);
            this.damagePrecisionSlider.setPaintTicks(true);
            this.damagePrecisionSlider.setMajorTickSpacing(1000);
            this.damagePrecisionSlider.setMinorTickSpacing(100);
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            ((Dictionary)labels).put(1, new JLabel("Accurate"));
            for (int i = 1000; i <= 10000; i += 1000) {
                ((Dictionary)labels).put(i, new JLabel(String.valueOf(i)));
            }
            this.hpPrecisionSlider.setLabelTable(labels);
            this.damagePrecisionSlider.setLabelTable(labels);
        }
    }
}

