/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.List;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Edge;
import rescuecore2.standard.view.StandardEntityViewLayer;

public abstract class AreaLayer<E extends Area>
extends StandardEntityViewLayer<E> {
    protected AreaLayer(Class<E> clazz) {
        super(clazz);
    }

    @Override
    public Shape render(E area, Graphics2D g, ScreenTransform t) {
        List<Edge> edges = ((Area)((Object)area)).getEdges();
        if (edges.isEmpty()) {
            return null;
        }
        int count = edges.size();
        int[] xs = new int[count];
        int[] ys = new int[count];
        int i = 0;
        for (Edge e : edges) {
            xs[i] = t.xToScreen((double)e.getStartX());
            ys[i] = t.yToScreen((double)e.getStartY());
            ++i;
        }
        Polygon shape = new Polygon(xs, ys, count);
        this.paintShape(area, shape, g);
        for (Edge edge : edges) {
            this.paintEdge(edge, g, t);
        }
        return shape;
    }

    protected void paintEdge(Edge e, Graphics2D g, ScreenTransform t) {
    }

    protected void paintShape(E area, Polygon p, Graphics2D g) {
    }
}

