/*
 * Decompiled with CFR 0.152.
 */
package commlib.data;

import commlib.data.EntityIDData;
import commlib.data.EntityIDListData;
import commlib.data.RCRSCSData;
import commlib.data.ValueData;
import rescuecore2.worldmodel.EntityID;

public enum DataType {
    TIME,
    X_COORDINATE,
    Y_COORDINATE,
    AREA,
    ROAD,
    BUILDING,
    REFUGE,
    BLOCKADE,
    HUMAN,
    FIRE_BRIGADE,
    AMBULANCE_TEAM,
    POLICE_FORCE,
    PLATOON_AGENT,
    FIRE_STATION,
    AMBULANCE_CENTER,
    POLICE_OFFICE,
    CENTER_AGENT,
    RESCUE_AGENT,
    HP,
    DAMAGE,
    BURIEDNESS,
    FIERYNESS,
    WATER_POWER,
    REPAIR_COST,
    BROKENNESS,
    WATER,
    ID_LIST,
    AREA_LIST;


    public static RCRSCSData<?> createData(DataType type, int value) {
        RCRSCSData res = null;
        switch (type) {
            case TIME: 
            case X_COORDINATE: 
            case Y_COORDINATE: 
            case HP: 
            case DAMAGE: 
            case BURIEDNESS: 
            case FIERYNESS: 
            case WATER_POWER: 
            case REPAIR_COST: 
            case BROKENNESS: 
            case WATER: {
                res = new ValueData(type, value);
                break;
            }
            case AREA: 
            case ROAD: 
            case BUILDING: 
            case REFUGE: 
            case BLOCKADE: 
            case HUMAN: 
            case FIRE_BRIGADE: 
            case AMBULANCE_TEAM: 
            case POLICE_FORCE: 
            case PLATOON_AGENT: 
            case CENTER_AGENT: 
            case RESCUE_AGENT: {
                res = new EntityIDData(type, new EntityID(value));
            }
        }
        return res;
    }

    public static EntityIDListData createIDListData(DataType type) {
        EntityIDListData res = null;
        switch (type) {
            case ID_LIST: 
            case AREA_LIST: {
                res = new EntityIDListData(type);
            }
        }
        return res;
    }
}

