/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.geom.util.Matrix;

public class AffineTransformationBuilder {
    private Coordinate src0;
    private Coordinate src1;
    private Coordinate src2;
    private Coordinate dest0;
    private Coordinate dest1;
    private Coordinate dest2;
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;

    public AffineTransformationBuilder(Coordinate src0, Coordinate src1, Coordinate src2, Coordinate dest0, Coordinate dest1, Coordinate dest2) {
        this.src0 = src0;
        this.src1 = src1;
        this.src2 = src2;
        this.dest0 = dest0;
        this.dest1 = dest1;
        this.dest2 = dest2;
    }

    public AffineTransformation getTransformation() {
        boolean isSolvable = this.compute();
        if (isSolvable) {
            return new AffineTransformation(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12);
        }
        return null;
    }

    private boolean compute() {
        double[] bx = new double[]{this.dest0.x, this.dest1.x, this.dest2.x};
        double[] row0 = this.solve(bx);
        if (row0 == null) {
            return false;
        }
        this.m00 = row0[0];
        this.m01 = row0[1];
        this.m02 = row0[2];
        double[] by = new double[]{this.dest0.y, this.dest1.y, this.dest2.y};
        double[] row1 = this.solve(by);
        if (row1 == null) {
            return false;
        }
        this.m10 = row1[0];
        this.m11 = row1[1];
        this.m12 = row1[2];
        return true;
    }

    private double[] solve(double[] b) {
        double[][] a = new double[][]{{this.src0.x, this.src0.y, 1.0}, {this.src1.x, this.src1.y, 1.0}, {this.src2.x, this.src2.y, 1.0}};
        return Matrix.solve(a, b);
    }
}

