/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.kdtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.kdtree.KdNode;
import java.util.ArrayList;
import java.util.List;

public class KdTree {
    private KdNode root = null;
    private KdNode last = null;
    private long numberOfNodes;
    private double tolerance;

    public KdTree() {
        this(0.0);
    }

    public KdTree(double tolerance) {
        this.tolerance = tolerance;
    }

    public KdNode insert(Coordinate p) {
        return this.insert(p, null);
    }

    public KdNode insert(Coordinate p, Object data) {
        if (this.root == null) {
            this.root = new KdNode(p, data);
            return this.root;
        }
        KdNode currentNode = this.root;
        KdNode leafNode = this.root;
        boolean isOddLevel = true;
        boolean isLessThan = true;
        while (currentNode != this.last) {
            isLessThan = isOddLevel ? p.x < currentNode.getX() : p.y < currentNode.getY();
            leafNode = currentNode;
            currentNode = isLessThan ? currentNode.getLeft() : currentNode.getRight();
            if (currentNode != null) {
                boolean isInTolerance;
                boolean bl = isInTolerance = p.distance(currentNode.getCoordinate()) < this.tolerance;
                if (isInTolerance) {
                    currentNode.increment();
                    return currentNode;
                }
            }
            isOddLevel = !isOddLevel;
        }
        ++this.numberOfNodes;
        KdNode node = new KdNode(p, data);
        node.setLeft(this.last);
        node.setRight(this.last);
        if (isLessThan) {
            leafNode.setLeft(node);
        } else {
            leafNode.setRight(node);
        }
        return node;
    }

    private void queryNode(KdNode currentNode, KdNode bottomNode, Envelope queryEnv, boolean odd, List result) {
        boolean searchRight;
        double discriminant;
        double max;
        double min;
        if (currentNode == bottomNode) {
            return;
        }
        if (odd) {
            min = queryEnv.getMinX();
            max = queryEnv.getMaxX();
            discriminant = currentNode.getX();
        } else {
            min = queryEnv.getMinY();
            max = queryEnv.getMaxY();
            discriminant = currentNode.getY();
        }
        boolean searchLeft = min < discriminant;
        boolean bl = searchRight = discriminant <= max;
        if (searchLeft) {
            this.queryNode(currentNode.getLeft(), bottomNode, queryEnv, !odd, result);
        }
        if (queryEnv.contains(currentNode.getCoordinate())) {
            result.add(currentNode);
        }
        if (searchRight) {
            this.queryNode(currentNode.getRight(), bottomNode, queryEnv, !odd, result);
        }
    }

    public List query(Envelope queryEnv) {
        ArrayList result = new ArrayList();
        this.queryNode(this.root, this.last, queryEnv, true, result);
        return result;
    }

    public void query(Envelope queryEnv, List result) {
        this.queryNode(this.root, this.last, queryEnv, true, result);
    }
}

