/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import rescuecore.Connection;
import rescuecore.LongUDPFragment;
import rescuecore.LongUDPMessage;

public class LongUDPConnection
implements Connection {
    private short nextID = 0;
    private DatagramSocket socket = new DatagramSocket();
    private List q;
    private ReadThread read;
    private IOException toThrow;
    private InetAddress destination;
    private int port;
    private static final long WAIT = 10000L;

    public LongUDPConnection() throws SocketException {
        this(null, -1);
    }

    public LongUDPConnection(InetAddress destination, int port) throws SocketException {
        this.socket.setSoTimeout(1000);
        this.q = new LinkedList();
        this.toThrow = null;
        this.read = new ReadThread();
        this.read.start();
        this.destination = destination;
        this.port = port;
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void close() {
        this.read.kill();
        this.socket.close();
    }

    @Override
    public void send(byte[] bytes) throws IOException {
        if (this.destination == null || this.port < 0) {
            throw new IOException("No destination given");
        }
        this.send(new LongUDPMessage(bytes), this.destination, this.port);
    }

    public void send(LongUDPMessage msg, InetAddress destination, int port) throws IOException {
        short s = this.nextID;
        this.nextID = (short)(s + 1);
        LongUDPFragment[] fragments = msg.fragment(s);
        for (int i = 0; i < fragments.length; ++i) {
            byte[] buffer = fragments[i].toByteArray();
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, destination, port);
            packet.setLength(buffer.length);
            try {
                this.socket.send(packet);
                continue;
            }
            catch (InterruptedIOException e) {
                System.out.println("send interrupted");
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] receive(int timeout) throws IOException, InterruptedException {
        List list = this.q;
        synchronized (list) {
            if (this.toThrow != null) {
                throw this.toThrow;
            }
            if (this.q.size() == 0) {
                if (timeout < 1) {
                    this.q.wait();
                } else {
                    this.q.wait(timeout);
                }
            }
            if (this.toThrow != null) {
                throw this.toThrow;
            }
            if (this.q.size() == 0) {
                return null;
            }
            return ((LongUDPMessage)this.q.remove(0)).getData();
        }
    }

    private class ReadThread
    extends Thread {
        private boolean running = true;
        private boolean alive = true;
        private final Object aliveLock = new Object();
        private Set partial = new HashSet();
        private long lastCheck;

        ReadThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            this.running = false;
            Object object = this.aliveLock;
            synchronized (object) {
                while (this.alive) {
                    try {
                        this.aliveLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] input = new byte[65536];
            this.lastCheck = System.currentTimeMillis();
            DatagramPacket packet = new DatagramPacket(input, input.length);
            while (this.running) {
                try {
                    LongUDPConnection.this.socket.receive(packet);
                    byte[] packetData = packet.getData();
                    byte[] result = new byte[packet.getLength()];
                    System.arraycopy(packetData, 0, result, 0, result.length);
                    LongUDPFragment fragment = new LongUDPFragment(result);
                    this.addFragment(fragment);
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                    List list = LongUDPConnection.this.q;
                    synchronized (list) {
                        LongUDPConnection.this.toThrow = e;
                    }
                }
                if (System.currentTimeMillis() <= this.lastCheck + 10000L) continue;
                this.checkForTimeouts();
            }
            Object object = this.aliveLock;
            synchronized (object) {
                this.alive = false;
                this.aliveLock.notifyAll();
            }
        }

        private void addFragment(LongUDPFragment fragment) {
            boolean found = false;
            Iterator it = this.partial.iterator();
            while (it.hasNext() && !found) {
                PartialMessage next = (PartialMessage)it.next();
                if (next.id != fragment.getID()) continue;
                found = true;
                if (next.addFragment(fragment)) {
                    this.finishedMessage(next.fragments);
                    it.remove();
                }
                if (next.total <= 10) continue;
                System.out.println(next.received + "/" + next.total);
            }
            if (!found) {
                PartialMessage pm = new PartialMessage(fragment.getID(), fragment.getTotal());
                if (pm.addFragment(fragment)) {
                    this.finishedMessage(pm.fragments);
                } else {
                    this.partial.add(pm);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishedMessage(LongUDPFragment[] fragments) {
            List list = LongUDPConnection.this.q;
            synchronized (list) {
                LongUDPConnection.this.q.add(LongUDPMessage.defragment(fragments));
                LongUDPConnection.this.q.notifyAll();
            }
        }

        private void checkForTimeouts() {
            Iterator it = this.partial.iterator();
            while (it.hasNext()) {
                PartialMessage next = (PartialMessage)it.next();
                if (System.currentTimeMillis() <= next.last + 10000L) continue;
                System.out.println("Message " + next.id + " timed out - we received " + next.received + " of " + next.total + " packets");
                it.remove();
            }
            this.lastCheck = System.currentTimeMillis();
        }

        private class PartialMessage {
            int id;
            int total;
            int received;
            long last;
            int size;
            LongUDPFragment[] fragments;

            PartialMessage(int id, int total) {
                this.id = id;
                this.total = total;
                this.received = 0;
                this.last = System.currentTimeMillis();
                this.fragments = new LongUDPFragment[total];
                this.size = 0;
            }

            public String toString() {
                return "Partial message " + this.id + ": received " + this.received + " of " + this.total + ", last fragment at time " + this.last;
            }

            public boolean addFragment(LongUDPFragment fragment) {
                if (fragment.getID() == this.id && this.fragments[fragment.getNumber()] == null) {
                    this.fragments[fragment.getNumber()] = fragment;
                    ++this.received;
                    this.last = System.currentTimeMillis();
                    this.size += fragment.getData().length;
                    if (this.received == this.total) {
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

