/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.RescueConstants;
import rescuecore.RescueObject;
import rescuecore.commands.Command;

public class KASense
extends Command {
    private int id;
    private int time;
    private RescueObject[] updates;

    public KASense(int id, int time, RescueObject[] updates) {
        super(68);
        this.id = id;
        this.time = time;
        this.updates = updates;
    }

    public KASense(InputBuffer in) {
        super(68);
        this.read(in);
    }

    @Override
    public void read(InputBuffer in) {
        this.id = in.readInt();
        this.time = in.readInt();
        this.updates = in.readObjects(this.time, RescueConstants.SOURCE_SENSE);
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.id);
        out.writeInt(this.time);
        out.writeObjects(this.updates);
    }

    public int getID() {
        return this.id;
    }

    public int getTime() {
        return this.time;
    }

    public RescueObject[] getUpdatedObjects() {
        return this.updates;
    }
}

