/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import rescuecore.config.ConfigException;
import rescuecore.config.NoSuchConfigOptionException;

public class Config {
    private static final String INCLUDE = "!include";
    private Map<String, String> data = new HashMap<String, String>();
    private Map<String, Integer> intData = new HashMap<String, Integer>();
    private Map<String, Double> floatData = new HashMap<String, Double>();
    private Map<String, Boolean> booleanData = new HashMap<String, Boolean>();

    public Config() {
    }

    public Config(File file) throws IOException, ConfigException {
        this();
        this.read(file);
    }

    public void read(File file) throws IOException, ConfigException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " does not exist");
        }
        if (file.isDirectory()) {
            for (File next : file.listFiles()) {
                this.read(next);
            }
        } else {
            this.readConfigFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(File in) throws IOException, ConfigException {
        BufferedReader reader = new BufferedReader(new FileReader(in));
        String name = in.getAbsolutePath();
        String line = "";
        int lineNumber = 0;
        try {
            while (line != null) {
                line = reader.readLine();
                ++lineNumber;
                if (line == null || "".equals(line = line.trim()) || line.startsWith("#")) continue;
                if (line.startsWith(INCLUDE)) {
                    if (INCLUDE.equals(line)) {
                        throw new ConfigException(name, "Line " + lineNumber + ": Empty include directive");
                    }
                    String includeName = line.substring(INCLUDE.length() + 1).trim();
                    if ("".equals(includeName)) {
                        throw new ConfigException(name, "Line " + lineNumber + ": Empty include directive");
                    }
                    this.read(new File(in.getParentFile(), includeName));
                    continue;
                }
                int index = line.indexOf(58);
                if (index == -1) {
                    throw new ConfigException(name, "Line " + lineNumber + ": No ':' found");
                }
                if (index == line.length() - 1) {
                    throw new ConfigException(name, "Line " + lineNumber + ": No value found");
                }
                if (index == 0) {
                    throw new ConfigException(name, "Line " + lineNumber + ": No key found");
                }
                String key = line.substring(0, index).trim();
                String value = line.substring(index + 1).trim();
                this.data.put(key, value);
                this.intData.remove(key);
                this.floatData.remove(key);
                this.booleanData.remove(key);
            }
        }
        finally {
            reader.close();
        }
    }

    public void write(PrintWriter out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        for (Map.Entry<String, String> next : this.data.entrySet()) {
            out.print(next.getKey());
            out.print(" : ");
            out.println(next.getValue());
        }
    }

    public Set<String> getAllKeys() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public String getValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (!this.data.containsKey(key)) {
            throw new NoSuchConfigOptionException(key);
        }
        return this.data.get(key);
    }

    public int getIntValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.intData.containsKey(key)) {
            return this.intData.get(key);
        }
        int result = Integer.parseInt(this.getValue(key));
        this.intData.put(key, result);
        return result;
    }

    public double getFloatValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.floatData.containsKey(key)) {
            return this.floatData.get(key);
        }
        double result = Double.parseDouble(this.getValue(key));
        this.floatData.put(key, result);
        return result;
    }

    public boolean getBooleanValue(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (this.booleanData.containsKey(key)) {
            return this.booleanData.get(key);
        }
        boolean result = false;
        String value = this.getValue(key);
        if ("true".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            result = true;
        }
        this.booleanData.put(key, result);
        return result;
    }

    public void setValue(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (value == null) {
            this.removeKey(key);
            return;
        }
        this.data.put(key, value);
        this.intData.remove(key);
        this.floatData.remove(key);
        this.booleanData.remove(key);
    }

    public void setIntValue(String key, int value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.data.put(key, Integer.valueOf(value).toString());
        this.intData.put(key, value);
        this.floatData.remove(key);
        this.booleanData.remove(key);
    }

    public void setFloatValue(String key, double value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.data.put(key, Double.valueOf(value).toString());
        this.intData.remove(key);
        this.floatData.put(key, value);
        this.booleanData.remove(key);
    }

    public void setBooleanValue(String key, boolean value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.data.put(key, value ? "true" : "false");
        this.intData.remove(key);
        this.floatData.remove(key);
        this.booleanData.put(key, value);
    }

    public void removeKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.data.remove(key);
        this.intData.remove(key);
        this.floatData.remove(key);
        this.booleanData.remove(key);
    }

    public void removeAllKeys() {
        this.data.clear();
        this.intData.clear();
        this.floatData.clear();
        this.booleanData.clear();
    }
}

