/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import rescuecore.CannotFindLocationException;
import rescuecore.Memory;
import rescuecore.RescueObject;
import rescuecore.commands.AKClear;
import rescuecore.commands.AKExtinguish;
import rescuecore.commands.AKLoad;
import rescuecore.commands.AKMove;
import rescuecore.commands.AKRescue;
import rescuecore.commands.AKSay;
import rescuecore.commands.AKTell;
import rescuecore.commands.AKUnload;
import rescuecore.commands.Command;
import rescuecore.commands.Nozzle;
import rescuecore.debug.ExtinguishCommand;
import rescuecore.debug.ExtinguishCommandRenderer;
import rescuecore.debug.Handler;
import rescuecore.debug.OutlineRenderer;
import rescuecore.objects.Building;
import rescuecore.objects.Humanoid;
import rescuecore.view.HumanoidRenderer;
import rescuecore.view.Layer;

public class CommandHandler
implements Handler {
    private Layer commandLayer;
    private DefaultListModel messages;
    private JScrollPane messagePane;
    private int timeStep = -1;
    private Memory memory;

    public CommandHandler() {
        JPanel messagePanel = new JPanel(new BorderLayout());
        TitledBorder bord = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Commands");
        messagePanel.setBorder(bord);
        this.messages = new DefaultListModel();
        JList messageList = new JList(this.messages);
        messagePanel.add(messageList, "Center");
        this.messagePane = new JScrollPane(messagePanel);
        this.messagePane.setPreferredSize(new Dimension(200, 80));
    }

    @Override
    public void setMemory(Memory m) {
        this.memory = m;
    }

    @Override
    public JComponent getComponent() {
        return this.messagePane;
    }

    @Override
    public Layer getLayer() {
        if (this.commandLayer == null) {
            this.commandLayer = new Layer("Move Commands");
            this.commandLayer.addRenderer(RescueObject[].class, OutlineRenderer.ORANGE);
            this.commandLayer.addRenderer(Humanoid.class, HumanoidRenderer.outlinedHumanoidRenderer(0, new Color(255, 255, 255, 96)));
            this.commandLayer.addRenderer(ExtinguishCommand.class, new ExtinguishCommandRenderer());
        }
        return this.commandLayer;
    }

    @Override
    public boolean handle(Object o, int timeStep) {
        if (this.timeStep != timeStep) {
            this.commandLayer.removeAllObjects();
            this.messages.clear();
            this.timeStep = timeStep;
        }
        if (!(o instanceof Command)) {
            return false;
        }
        Command c = (Command)o;
        if (c == null) {
            return true;
        }
        switch (c.getType()) {
            case 129: {
                int[] path = ((AKMove)c).getPath();
                RescueObject[] rs = new RescueObject[path.length];
                rs[0] = this.memory.lookup(path[0]);
                RescueObject last = null;
                for (int i = 0; i < rs.length; ++i) {
                    rs[i] = this.memory.lookup(path[i]);
                    if (rs[i] == null) {
                        this.messages.addElement("Bad ID in path. Index " + i + ". ID " + path[i]);
                        continue;
                    }
                    if (!rs[i].isNode()) continue;
                    if (last != null) {
                        this.commandLayer.addObject(new RescueObject[]{last, rs[i]});
                    }
                    last = rs[i];
                }
                break;
            }
            case 132: {
                this.messages.addElement("Say of " + ((AKSay)c).getMessage().length + " bytes.");
                break;
            }
            case 133: {
                this.messages.addElement("Tell of " + ((AKTell)c).getMessage().length + " bytes.");
                break;
            }
            case 134: {
                AKExtinguish ex = (AKExtinguish)c;
                int id = ex.getSender();
                Nozzle[] nozzles = ex.getNozzles();
                for (int i = 0; i < nozzles.length; ++i) {
                    int targetID = nozzles[i].getTarget();
                    this.messages.addElement("Extinguishing building " + targetID);
                    try {
                        this.commandLayer.addObject(new ExtinguishCommand((Building)this.memory.lookup(targetID), (Humanoid)this.memory.lookup(id), this.memory));
                        continue;
                    }
                    catch (CannotFindLocationException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            case 137: {
                int id = ((AKClear)c).getSender();
                this.commandLayer.addObject(this.memory.lookup(id));
                this.messages.addElement("Clearing road.");
                break;
            }
            case 136: {
                int id = ((AKRescue)c).getSender();
                this.commandLayer.addObject(this.memory.lookup(id));
                this.messages.addElement("Rescuing.");
                break;
            }
            case 130: {
                int id = ((AKLoad)c).getSender();
                this.commandLayer.addObject(this.memory.lookup(id));
                this.messages.addElement("Loading.");
                break;
            }
            case 131: {
                int id = ((AKUnload)c).getSender();
                this.commandLayer.addObject(this.memory.lookup(id));
                this.messages.addElement("Unloading.");
            }
        }
        return true;
    }
}

