/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import rescuecore.CannotFindLocationException;
import rescuecore.PlatoonAgent;
import rescuecore.RescueObject;
import rescuecore.commands.AKChannel;
import rescuecore.event.MemoryListener;
import rescuecore.event.ObjectAddedEvent;
import rescuecore.event.ObjectChangedEvent;
import rescuecore.objects.Building;
import rescuecore.objects.FireBrigade;
import rescuecore.objects.Node;
import rescuecore.objects.Refuge;
import rescuecore.objects.Road;
import rescuecore.sample.SampleSearch;

public class SampleFireBrigade
extends PlatoonAgent {
    private static final byte CHANNEL = 1;
    private boolean enableDebug = false;
    private List targets = new ArrayList();

    public SampleFireBrigade() {
        super(66);
    }

    public SampleFireBrigade(String[] args) {
        this();
        for (String next : args) {
            if (!next.equalsIgnoreCase("debug")) continue;
            this.enableDebug = true;
        }
    }

    private FireBrigade me() {
        return (FireBrigade)this.memory.lookup(this.id);
    }

    @Override
    public void initialise(RescueObject[] knowledge) {
        if (this.enableDebug) {
            try {
                this.enableDebug("debug.log");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.initialise(knowledge);
        this.memory.addMemoryListener(new MemoryListener(){

            @Override
            public void objectAdded(ObjectAddedEvent event) {
                RescueObject o = event.getObject();
                if (o.isBuilding() && ((Building)o).isOnFire()) {
                    SampleFireBrigade.this.targets.add(o);
                }
            }

            @Override
            public void objectChanged(ObjectChangedEvent event) {
                RescueObject o = event.getObject();
                if (o.isBuilding() && event.getProperty() == 31) {
                    if (((Building)o).isOnFire()) {
                        SampleFireBrigade.this.targets.add(o);
                    } else {
                        SampleFireBrigade.this.targets.remove(o);
                    }
                }
            }
        });
    }

    @Override
    public void sense() {
        int[] path;
        if (this.timeStep == 1) {
            this.appendCommand(new AKChannel(this.id, this.timeStep, 1));
        }
        if (this.getLocation().isRefuge() && this.me().getWaterQuantity() < 15000) {
            return;
        }
        if (this.me().getWaterQuantity() == 0) {
            this.moveToClosestRefuge();
            return;
        }
        SampleSearch.sortByDistance(this.targets, (RescueObject)this.me(), this.memory);
        Iterator it = this.targets.iterator();
        while (it.hasNext()) {
            Building next = (Building)it.next();
            if (!next.isOnFire()) {
                it.remove();
                continue;
            }
            try {
                if (this.memory.getDistance(this.me(), next) < 30000.0) {
                    this.extinguish(next);
                    this.tell(("Extinguishing " + next.getID()).getBytes(), (byte)1);
                    return;
                }
            }
            catch (CannotFindLocationException e) {
                System.err.println("PANIC! I don't know where I am!");
                System.err.println(e);
            }
            Node entrance = (Node)this.memory.lookup(next.getEntrances()[0]);
            path = SampleSearch.breadthFirstSearch(this.getLocation(), entrance, this.memory);
            if (path == null) continue;
            this.move(path);
            return;
        }
        Collection<RescueObject> allRoads = this.memory.getObjectsOfType(2);
        Road[] roads = new Road[allRoads.size()];
        allRoads.toArray(roads);
        Road target = roads[(int)(Math.random() * (double)roads.length)];
        path = SampleSearch.breadthFirstSearch(this.getLocation(), target, this.memory);
        if (path != null) {
            this.move(path);
        }
    }

    @Override
    protected void hear(int from, byte[] msg, byte channel) {
    }

    private void moveToClosestRefuge() {
        Collection<RescueObject> allRefuges = this.memory.getObjectsOfType(33);
        RescueObject[] refuges = new Refuge[allRefuges.size()];
        allRefuges.toArray(refuges);
        SampleSearch.sortByDistance(refuges, (RescueObject)this.me(), this.memory);
        for (int i = 0; i < refuges.length; ++i) {
            RescueObject next = refuges[i];
            int[] path = SampleSearch.breadthFirstSearch(this.getLocation(), next, this.memory);
            if (path == null) continue;
            this.move(path);
            return;
        }
    }
}

